/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.composite;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.jackrabbit.oak.api.Blob;
import org.apache.jackrabbit.oak.api.CommitFailedException;
import org.apache.jackrabbit.oak.api.PropertyState;
import org.apache.jackrabbit.oak.commons.PathUtils;
import org.apache.jackrabbit.oak.composite.CommitHookEnhancer;
import org.apache.jackrabbit.oak.composite.CompositeNodeBuilder;
import org.apache.jackrabbit.oak.composite.CompositeNodeState;
import org.apache.jackrabbit.oak.composite.CompositeNodeStoreMonitor;
import org.apache.jackrabbit.oak.composite.CompositionContext;
import org.apache.jackrabbit.oak.composite.ModifiedPathDiff;
import org.apache.jackrabbit.oak.composite.MountedNodeStore;
import org.apache.jackrabbit.oak.composite.checks.NodeStoreChecks;
import org.apache.jackrabbit.oak.spi.commit.CommitHook;
import org.apache.jackrabbit.oak.spi.commit.CommitInfo;
import org.apache.jackrabbit.oak.spi.commit.EmptyHook;
import org.apache.jackrabbit.oak.spi.commit.Observable;
import org.apache.jackrabbit.oak.spi.commit.Observer;
import org.apache.jackrabbit.oak.spi.mount.Mount;
import org.apache.jackrabbit.oak.spi.mount.MountInfoProvider;
import org.apache.jackrabbit.oak.spi.state.NodeBuilder;
import org.apache.jackrabbit.oak.spi.state.NodeState;
import org.apache.jackrabbit.oak.spi.state.NodeStore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CompositeNodeStore
implements NodeStore,
Observable {
    private static final Logger LOG = LoggerFactory.getLogger(CompositeNodeStore.class);
    static final String CHECKPOINT_METADATA = "composite.checkpoint.";
    private static final String CHECKPOINT_METADATA_MOUNT = "composite.checkpoint.mount.";
    private final TreeSet<String> ignoreReadOnlyWritePaths;
    final CompositionContext ctx;
    private final List<Observer> observers = new CopyOnWriteArrayList<Observer>();
    private final Lock mergeLock;

    CompositeNodeStore(MountInfoProvider mip, NodeStore globalStore, List<MountedNodeStore> nonDefaultStore) {
        this(mip, globalStore, nonDefaultStore, Collections.emptyList(), CompositeNodeStoreMonitor.EMPTY_INSTANCE, CompositeNodeStoreMonitor.EMPTY_INSTANCE);
    }

    CompositeNodeStore(MountInfoProvider mip, NodeStore globalStore, List<MountedNodeStore> nonDefaultStore, List<String> ignoreReadOnlyWritePaths, CompositeNodeStoreMonitor nodeStateMonitor, CompositeNodeStoreMonitor nodeBuilderMonitor) {
        this.ctx = new CompositionContext(mip, globalStore, nonDefaultStore, nodeStateMonitor, nodeBuilderMonitor);
        this.ignoreReadOnlyWritePaths = new TreeSet<String>(ignoreReadOnlyWritePaths);
        this.mergeLock = new ReentrantLock();
    }

    public NodeState getRoot() {
        HashMap nodeStates = Maps.newHashMap();
        for (MountedNodeStore nodeStore : this.ctx.getAllMountedNodeStores()) {
            nodeStates.put(nodeStore, nodeStore.getNodeStore().getRoot());
        }
        return this.ctx.createRootNodeState(nodeStates);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NodeState merge(NodeBuilder builder, CommitHook commitHook, CommitInfo info) throws CommitFailedException {
        Preconditions.checkArgument((boolean)(builder instanceof CompositeNodeBuilder));
        CompositeNodeBuilder nodeBuilder = (CompositeNodeBuilder)builder;
        if (!PathUtils.denotesRoot((String)nodeBuilder.getPath())) {
            throw new IllegalArgumentException();
        }
        this.assertNoChangesOnReadOnlyMounts(nodeBuilder);
        this.mergeLock.lock();
        try {
            HashMap resultStates = Maps.newHashMap();
            MountedNodeStore globalStore = this.ctx.getGlobalStore();
            CommitHookEnhancer hookEnhancer = new CommitHookEnhancer(commitHook, this.ctx, nodeBuilder);
            NodeState globalResult = globalStore.getNodeStore().merge(nodeBuilder.getNodeBuilder(globalStore), (CommitHook)hookEnhancer, info);
            resultStates.put(globalStore, globalResult);
            if (!hookEnhancer.getUpdatedBuilder().isPresent()) {
                hookEnhancer.processCommit(globalResult, globalResult, info);
            }
            CompositeNodeBuilder updatedBuilder = hookEnhancer.getUpdatedBuilder().get();
            for (MountedNodeStore mns : this.ctx.getNonDefaultStores()) {
                NodeBuilder partialBuilder = updatedBuilder.getNodeBuilder(mns);
                if (mns.getMount().isReadOnly()) {
                    this.assertNoChange(mns, partialBuilder);
                    resultStates.put(mns, mns.getNodeStore().getRoot());
                    continue;
                }
                NodeState partialState = mns.getNodeStore().merge(partialBuilder, EmptyHook.INSTANCE, info);
                resultStates.put(mns, partialState);
            }
            CompositeNodeState newRoot = this.ctx.createRootNodeState(resultStates);
            for (Observer observer : this.observers) {
                observer.contentChanged((NodeState)newRoot, info);
            }
            Object object = newRoot;
            return object;
        }
        finally {
            this.mergeLock.unlock();
        }
    }

    private void assertNoChangesOnReadOnlyMounts(CompositeNodeBuilder nodeBuilder) throws CommitFailedException {
        for (MountedNodeStore mountedNodeStore : this.ctx.getAllMountedNodeStores()) {
            if (!mountedNodeStore.getMount().isReadOnly()) continue;
            NodeBuilder partialBuilder = nodeBuilder.getNodeBuilder(mountedNodeStore);
            this.assertNoChange(mountedNodeStore, partialBuilder);
        }
    }

    private void assertNoChange(MountedNodeStore mountedNodeStore, NodeBuilder partialBuilder) throws CommitFailedException {
        NodeState baseState = partialBuilder.getBaseState();
        NodeState nodeState = partialBuilder.getNodeState();
        if (!nodeState.equals(baseState)) {
            Sets.SetView failingChangedPaths;
            Set<String> changedPaths = ModifiedPathDiff.getModifiedPaths(baseState, nodeState);
            Set<String> ignoredChangedPaths = this.getIgnoredPaths(changedPaths);
            if (!ignoredChangedPaths.isEmpty()) {
                LOG.debug("Can't merge following read-only paths (they are configured to be ignored): {}.", ignoredChangedPaths);
            }
            if (!(failingChangedPaths = Sets.difference(changedPaths, ignoredChangedPaths)).isEmpty()) {
                throw new CommitFailedException("CompositeStore", 31, "Unable to perform changes on read-only mount " + mountedNodeStore.getMount().getName() + ". Failing paths: " + failingChangedPaths.toString());
            }
        }
    }

    public NodeState rebase(NodeBuilder builder) {
        Preconditions.checkArgument((boolean)(builder instanceof CompositeNodeBuilder));
        CompositeNodeBuilder nodeBuilder = (CompositeNodeBuilder)builder;
        HashMap resultStates = Maps.newHashMap();
        for (MountedNodeStore mountedNodeStore : this.ctx.getAllMountedNodeStores()) {
            NodeState result;
            NodeStore nodeStore = mountedNodeStore.getNodeStore();
            if (mountedNodeStore.getMount().isReadOnly()) {
                result = nodeStore.getRoot();
            } else {
                NodeBuilder partialBuilder = nodeBuilder.getNodeBuilder(mountedNodeStore);
                result = nodeStore.rebase(partialBuilder);
            }
            resultStates.put(mountedNodeStore, result);
        }
        return this.ctx.createRootNodeState(resultStates);
    }

    public NodeState reset(NodeBuilder builder) {
        Preconditions.checkArgument((boolean)(builder instanceof CompositeNodeBuilder));
        CompositeNodeBuilder nodeBuilder = (CompositeNodeBuilder)builder;
        HashMap resultStates = Maps.newHashMap();
        for (MountedNodeStore mountedNodeStore : this.ctx.getAllMountedNodeStores()) {
            NodeState result;
            NodeStore nodeStore = mountedNodeStore.getNodeStore();
            if (mountedNodeStore.getMount().isReadOnly()) {
                result = nodeStore.getRoot();
            } else {
                NodeBuilder partialBuilder = nodeBuilder.getNodeBuilder(mountedNodeStore);
                result = nodeStore.reset(partialBuilder);
            }
            resultStates.put(mountedNodeStore, result);
        }
        return this.ctx.createRootNodeState(resultStates);
    }

    public Blob createBlob(InputStream inputStream) throws IOException {
        return this.ctx.createBlob(inputStream);
    }

    public Blob getBlob(String reference) {
        for (MountedNodeStore nodeStore : this.ctx.getAllMountedNodeStores()) {
            Blob found = nodeStore.getNodeStore().getBlob(reference);
            if (found == null) continue;
            return found;
        }
        return null;
    }

    public Iterable<String> checkpoints() {
        NodeStore globalNodeStore = this.ctx.getGlobalStore().getNodeStore();
        return Iterables.filter((Iterable)globalNodeStore.checkpoints(), (Predicate)new Predicate<String>(){

            public boolean apply(String checkpoint) {
                return CompositeNodeStore.this.isCompositeCheckpoint(checkpoint);
            }
        });
    }

    private boolean isCompositeCheckpoint(String checkpoint) {
        Map props = this.ctx.getGlobalStore().getNodeStore().checkpointInfo(checkpoint);
        if (props == null) {
            return false;
        }
        return props.containsKey("composite.checkpoint.created");
    }

    public String checkpoint(long lifetime, Map<String, String> properties) {
        HashMap globalProperties = Maps.newHashMap(properties);
        globalProperties.put("composite.checkpoint.created", Long.toString(System.currentTimeMillis()));
        globalProperties.put("composite.checkpoint.expires", Long.toString(System.currentTimeMillis() + lifetime));
        for (MountedNodeStore mns : this.ctx.getNonDefaultStores()) {
            if (mns.getMount().isReadOnly()) continue;
            String checkpoint = mns.getNodeStore().checkpoint(lifetime, properties);
            globalProperties.put(CHECKPOINT_METADATA_MOUNT + mns.getMount().getName(), checkpoint);
        }
        String newCheckpoint = this.ctx.getGlobalStore().getNodeStore().checkpoint(lifetime, (Map)globalProperties);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Created checkpoint {}. Debug info:\n{}", (Object)newCheckpoint, (Object)this.checkpointDebugInfo());
        }
        return newCheckpoint;
    }

    public String checkpoint(long lifetime) {
        return this.checkpoint(lifetime, Collections.emptyMap());
    }

    public Map<String, String> checkpointInfo(String checkpoint) {
        if (!CompositeNodeStore.checkpointExists(this.ctx.getGlobalStore().getNodeStore(), checkpoint)) {
            LOG.warn("Checkpoint {} doesn't exist. Debug info:\n{}", (Object)checkpoint, (Object)this.checkpointDebugInfo());
            return Collections.emptyMap();
        }
        return ImmutableMap.copyOf((Map)Maps.filterKeys((Map)this.ctx.getGlobalStore().getNodeStore().checkpointInfo(checkpoint), (Predicate)new Predicate<String>(){

            public boolean apply(String input) {
                return !input.startsWith(CompositeNodeStore.CHECKPOINT_METADATA);
            }
        }));
    }

    Map<String, String> allCheckpointInfo(String checkpoint) {
        return this.ctx.getGlobalStore().getNodeStore().checkpointInfo(checkpoint);
    }

    public NodeState retrieve(String checkpoint) {
        if (!CompositeNodeStore.checkpointExists(this.ctx.getGlobalStore().getNodeStore(), checkpoint)) {
            LOG.warn("Checkpoint {} doesn't exist on the global store. Debug info:\n{}", (Object)checkpoint, (Object)this.checkpointDebugInfo());
            return null;
        }
        Map props = this.ctx.getGlobalStore().getNodeStore().checkpointInfo(checkpoint);
        HashMap nodeStates = Maps.newHashMap();
        nodeStates.put(this.ctx.getGlobalStore(), this.ctx.getGlobalStore().getNodeStore().retrieve(checkpoint));
        for (MountedNodeStore nodeStore : this.ctx.getNonDefaultStores()) {
            NodeState nodeState = null;
            String partialCheckpoint = this.getPartialCheckpointName(nodeStore, checkpoint, props, true);
            if (partialCheckpoint == null && nodeStore.getMount().isReadOnly()) {
                nodeState = nodeStore.getNodeStore().getRoot();
            } else if (partialCheckpoint != null) {
                nodeState = nodeStore.getNodeStore().retrieve(partialCheckpoint);
            }
            nodeStates.put(nodeStore, nodeState);
        }
        if (Iterables.any(nodeStates.values(), (Predicate)Predicates.isNull())) {
            LOG.warn("Checkpoint {} doesn't exist. Debug info:\n{}", (Object)checkpoint, (Object)this.checkpointDebugInfo());
            return null;
        }
        return this.ctx.createRootNodeState(nodeStates);
    }

    public boolean release(String checkpoint) {
        boolean result;
        Map props;
        if (CompositeNodeStore.checkpointExists(this.ctx.getGlobalStore().getNodeStore(), checkpoint)) {
            props = this.ctx.getGlobalStore().getNodeStore().checkpointInfo(checkpoint);
            result = this.ctx.getGlobalStore().getNodeStore().release(checkpoint);
        } else {
            props = Collections.emptyMap();
            result = true;
        }
        for (MountedNodeStore nodeStore : this.ctx.getNonDefaultStores()) {
            if (nodeStore.getMount().isReadOnly()) continue;
            boolean released = false;
            String partialCheckpoint = this.getPartialCheckpointName(nodeStore, checkpoint, props, false);
            if (partialCheckpoint != null) {
                released = nodeStore.getNodeStore().release(partialCheckpoint);
            }
            result &= released;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Released checkpoint {}. Result: {}. Debug info:\n{}", new Object[]{checkpoint, result, this.checkpointDebugInfo()});
        }
        return result;
    }

    private String getPartialCheckpointName(MountedNodeStore nodeStore, String globalCheckpoint, Map<String, String> globalCheckpointProperties, boolean resolveByName) {
        ImmutableSet validCheckpointNames = ImmutableSet.copyOf((Iterable)nodeStore.getNodeStore().checkpoints());
        String result = globalCheckpointProperties.get(CHECKPOINT_METADATA_MOUNT + nodeStore.getMount().getName());
        if (result != null && validCheckpointNames.contains(result)) {
            return result;
        }
        if (globalCheckpoint != null && validCheckpointNames.contains(globalCheckpoint)) {
            return globalCheckpoint;
        }
        if (resolveByName) {
            String nameProp = globalCheckpointProperties.get("name");
            if (nameProp == null) {
                return null;
            }
            for (String c : validCheckpointNames) {
                Map partialCheckpointProperties = nodeStore.getNodeStore().checkpointInfo(c);
                if (!nameProp.equals(partialCheckpointProperties.get("name"))) continue;
                return c;
            }
        }
        return null;
    }

    private static boolean checkpointExists(NodeStore nodeStore, String checkpoint) {
        return Iterables.any((Iterable)nodeStore.checkpoints(), (Predicate)Predicates.equalTo((Object)checkpoint));
    }

    private String checkpointDebugInfo() {
        StringBuilder builder = new StringBuilder();
        for (MountedNodeStore mns : this.ctx.getAllMountedNodeStores()) {
            Mount mount = mns.getMount();
            NodeStore nodeStore = mns.getNodeStore();
            builder.append("Mount: ").append(mount.isDefault() ? "[default]" : mount.getName()).append('\n');
            builder.append("Checkpoints:").append('\n');
            for (String checkpoint : nodeStore.checkpoints()) {
                builder.append(" - ").append(checkpoint).append(": ").append(nodeStore.checkpointInfo(checkpoint)).append('\n');
            }
            builder.append("/:async node: ");
            NodeState asyncNode = nodeStore.getRoot().getChildNode(":async");
            if (asyncNode.exists()) {
                builder.append("{");
                Iterator i = asyncNode.getProperties().iterator();
                while (i.hasNext()) {
                    PropertyState p = (PropertyState)i.next();
                    if (p.isArray()) {
                        builder.append(p.getName()).append(": [...]");
                    } else {
                        builder.append(p.toString());
                    }
                    if (!i.hasNext()) continue;
                    builder.append(", ");
                }
                builder.append("}");
            } else {
                builder.append("N/A");
            }
            builder.append('\n');
        }
        return builder.toString();
    }

    public Closeable addObserver(final Observer observer) {
        observer.contentChanged(this.getRoot(), CommitInfo.EMPTY_EXTERNAL);
        this.observers.add(observer);
        return new Closeable(){

            @Override
            public void close() throws IOException {
                CompositeNodeStore.this.observers.remove(observer);
            }
        };
    }

    private Set<String> getIgnoredPaths(Set<String> paths) {
        return Sets.newHashSet((Iterable)Sets.filter(paths, (Predicate)new Predicate<String>(){

            public boolean apply(String path) {
                String previousPath = CompositeNodeStore.this.ignoreReadOnlyWritePaths.floor(path);
                return previousPath != null && (previousPath.equals(path) || PathUtils.isAncestor((String)previousPath, (String)path));
            }
        }));
    }

    public static class Builder {
        private final MountInfoProvider mip;
        private final NodeStore globalStore;
        private final List<MountedNodeStore> nonDefaultStores = Lists.newArrayList();
        private final List<String> ignoreReadOnlyWritePaths = Lists.newArrayList();
        private CompositeNodeStoreMonitor nodeStateMonitor = CompositeNodeStoreMonitor.EMPTY_INSTANCE;
        private CompositeNodeStoreMonitor nodeBuilderMonitor = CompositeNodeStoreMonitor.EMPTY_INSTANCE;
        private boolean partialReadOnly = true;
        private NodeStoreChecks checks;

        public Builder(MountInfoProvider mip, NodeStore globalStore) {
            this.mip = (MountInfoProvider)Preconditions.checkNotNull((Object)mip, (Object)"mountInfoProvider");
            this.globalStore = (NodeStore)Preconditions.checkNotNull((Object)globalStore, (Object)"globalStore");
        }

        public Builder with(NodeStoreChecks checks) {
            this.checks = checks;
            return this;
        }

        public Builder with(CompositeNodeStoreMonitor nodeStateMonitor, CompositeNodeStoreMonitor nodeBuilderMonitor) {
            this.nodeStateMonitor = nodeStateMonitor;
            this.nodeBuilderMonitor = nodeBuilderMonitor;
            return this;
        }

        public Builder addMount(String mountName, NodeStore store) {
            Preconditions.checkNotNull((Object)store, (Object)"store");
            Preconditions.checkNotNull((Object)mountName, (Object)"mountName");
            Mount mount = (Mount)Preconditions.checkNotNull((Object)this.mip.getMountByName(mountName), (String)"No mount with name %s found in %s", (Object[])new Object[]{mountName, this.mip});
            this.nonDefaultStores.add(new MountedNodeStore(mount, store));
            return this;
        }

        public Builder addIgnoredReadOnlyWritePath(String path) {
            this.ignoreReadOnlyWritePaths.add(path);
            return this;
        }

        public Builder setPartialReadOnly(boolean partialReadOnly) {
            this.partialReadOnly = partialReadOnly;
            return this;
        }

        public CompositeNodeStore build() {
            this.checkMountsAreConsistentWithMounts();
            if (this.partialReadOnly) {
                this.assertPartialMountsAreReadOnly();
            }
            if (this.checks != null) {
                this.nonDefaultStores.forEach(s -> this.checks.check(this.globalStore, (MountedNodeStore)s));
            }
            return new CompositeNodeStore(this.mip, this.globalStore, this.nonDefaultStores, this.ignoreReadOnlyWritePaths, this.nodeStateMonitor, this.nodeBuilderMonitor);
        }

        public void assertPartialMountsAreReadOnly() {
            ArrayList readWriteMountNames = Lists.newArrayList();
            for (Mount mount : this.mip.getNonDefaultMounts()) {
                if (mount.isReadOnly()) continue;
                readWriteMountNames.add(mount.getName());
            }
            Preconditions.checkArgument((boolean)readWriteMountNames.isEmpty(), (String)"Following partial mounts are write-enabled: ", (Object[])new Object[]{readWriteMountNames});
        }

        private void checkMountsAreConsistentWithMounts() {
            int mipMountCount;
            int buildMountCount = this.nonDefaultStores.size();
            Preconditions.checkArgument((buildMountCount == (mipMountCount = this.mip.getNonDefaultMounts().size()) ? 1 : 0) != 0, (String)"Inconsistent mount configuration. Builder received %s mounts, but MountInfoProvider knows about %s.", (Object[])new Object[]{buildMountCount, mipMountCount});
        }
    }
}

