/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.composite;

import com.google.common.collect.FluentIterable;
import java.util.Collections;
import java.util.List;
import org.apache.jackrabbit.oak.api.PropertyState;
import org.apache.jackrabbit.oak.commons.PathUtils;
import org.apache.jackrabbit.oak.composite.CompositeNodeBuilder;
import org.apache.jackrabbit.oak.composite.CompositionContext;
import org.apache.jackrabbit.oak.composite.MountedNodeStore;
import org.apache.jackrabbit.oak.composite.NodeMap;
import org.apache.jackrabbit.oak.plugins.memory.MemoryChildNodeEntry;
import org.apache.jackrabbit.oak.spi.state.AbstractNodeState;
import org.apache.jackrabbit.oak.spi.state.ChildNodeEntry;
import org.apache.jackrabbit.oak.spi.state.NodeState;
import org.apache.jackrabbit.oak.spi.state.NodeStateDiff;
import org.apache.jackrabbit.oak.spi.state.ReadOnlyBuilder;

class CompositeNodeState
extends AbstractNodeState {
    static final String STOP_COUNTING_CHILDREN = new String(CompositeNodeState.class.getName() + ".stopCountingChildren");
    private final NodeMap<NodeState> nodeStates;
    private final CompositionContext ctx;
    private final String path;

    CompositeNodeState(String path, NodeMap<NodeState> nodeStates, CompositionContext ctx) {
        this.path = ctx.getPathCache().get(path);
        this.ctx = ctx;
        this.nodeStates = nodeStates;
        ctx.getNodeStateMonitor().onCreateNodeObject(path);
    }

    NodeState getNodeState(MountedNodeStore mns) {
        return this.nodeStates.get(mns);
    }

    public boolean exists() {
        return this.getWrappedNodeState().exists();
    }

    public boolean hasProperty(String name) {
        return this.getWrappedNodeState().hasProperty(name);
    }

    public PropertyState getProperty(String name) {
        return this.getWrappedNodeState().getProperty(name);
    }

    public long getPropertyCount() {
        return this.getWrappedNodeState().getPropertyCount();
    }

    public Iterable<? extends PropertyState> getProperties() {
        return this.getWrappedNodeState().getProperties();
    }

    public boolean hasChildNode(String name) {
        String childPath = CompositeNodeBuilder.simpleConcat(this.getPath(), name);
        MountedNodeStore mountedStore = this.ctx.getOwningStore(childPath);
        return this.nodeStates.get(mountedStore).hasChildNode(name);
    }

    public NodeState getChildNode(String name) {
        String childPath = CompositeNodeBuilder.simpleConcat(this.getPath(), name);
        if (!this.ctx.shouldBeComposite(childPath)) {
            MountedNodeStore mns2 = this.ctx.getOwningStore(childPath);
            this.ctx.getNodeStateMonitor().onSwitchNodeToNative(mns2.getMount());
            return this.nodeStates.get(mns2).getChildNode(name);
        }
        NodeMap<NodeState> newNodeStates = this.nodeStates.lazyApply((mns, n) -> n.getChildNode(name));
        return new CompositeNodeState(childPath, newNodeStates, this.ctx);
    }

    public long getChildNodeCount(long max) {
        List<MountedNodeStore> contributingStores = this.ctx.getContributingStoresForNodes(this.getPath(), this.nodeStates);
        if (contributingStores.isEmpty()) {
            return 0L;
        }
        if (contributingStores.size() == 1) {
            return this.getWrappedNodeState().getChildNodeCount(max);
        }
        return CompositeNodeState.accumulateChildSizes((Iterable<String>)FluentIterable.from(contributingStores).transformAndConcat(mns -> {
            NodeState node = this.nodeStates.get((MountedNodeStore)mns);
            if (node.getChildNodeCount(max) == Long.MAX_VALUE) {
                return Collections.singleton(STOP_COUNTING_CHILDREN);
            }
            return FluentIterable.from((Iterable)node.getChildNodeNames()).filter(e -> this.belongsToStore((MountedNodeStore)mns, (String)e));
        }), max);
    }

    static long accumulateChildSizes(Iterable<String> nodeNames, long max) {
        long totalCount = 0L;
        for (String name : nodeNames) {
            if (name != STOP_COUNTING_CHILDREN && ++totalCount < max) continue;
            return Long.MAX_VALUE;
        }
        return totalCount;
    }

    public Iterable<? extends ChildNodeEntry> getChildNodeEntries() {
        return FluentIterable.from(this.ctx.getContributingStoresForNodes(this.path, this.nodeStates)).transformAndConcat(mns -> FluentIterable.from((Iterable)this.nodeStates.get((MountedNodeStore)mns).getChildNodeNames()).filter(n -> this.belongsToStore((MountedNodeStore)mns, (String)n))).transform(n -> new MemoryChildNodeEntry(n, this.getChildNode((String)n)));
    }

    public boolean compareAgainstBaseState(NodeState base, NodeStateDiff diff) {
        if (base instanceof CompositeNodeState) {
            CompositeNodeState multiBase = (CompositeNodeState)base;
            WrappingDiff wrappingDiff = new WrappingDiff(diff, multiBase);
            boolean full = this.getWrappedNodeState().compareAgainstBaseState(multiBase.getWrappedNodeState(), (NodeStateDiff)new ChildrenDiffFilter(wrappingDiff, this.ctx.getGlobalStore(), true));
            for (MountedNodeStore mns : this.ctx.getContributingStoresForNodes(this.path, this.nodeStates)) {
                if (this.ctx.getGlobalStore() == mns) continue;
                ChildrenDiffFilter childrenDiffFilter = new ChildrenDiffFilter(wrappingDiff, mns, false);
                NodeState contributing = this.nodeStates.get(mns);
                NodeState contributingBase = multiBase.nodeStates.get(mns);
                full = full && contributing.compareAgainstBaseState(contributingBase, (NodeStateDiff)childrenDiffFilter);
            }
            return full;
        }
        return super.compareAgainstBaseState(base, diff);
    }

    public CompositeNodeBuilder builder() {
        return new CompositeNodeBuilder(this.nodeStates.lazyApply((mns, n) -> {
            if (mns.getMount().isReadOnly()) {
                return new ReadOnlyBuilder(n);
            }
            return n.builder();
        }), this.ctx);
    }

    private NodeState getWrappedNodeState() {
        return this.nodeStates.get(this.ctx.getGlobalStore());
    }

    private boolean belongsToStore(MountedNodeStore mns, String childName) {
        return this.ctx.belongsToStore(mns, this.getPath(), childName);
    }

    private String getPath() {
        return this.path;
    }

    private class WrappingDiff
    implements NodeStateDiff {
        private final NodeStateDiff diff;
        private final CompositeNodeState base;

        public WrappingDiff(NodeStateDiff diff, CompositeNodeState base) {
            this.diff = diff;
            this.base = base;
        }

        public boolean propertyAdded(PropertyState after) {
            return this.diff.propertyAdded(after);
        }

        public boolean propertyChanged(PropertyState before, PropertyState after) {
            return this.diff.propertyChanged(before, after);
        }

        public boolean propertyDeleted(PropertyState before) {
            return this.diff.propertyDeleted(before);
        }

        public boolean childNodeAdded(String name, NodeState after) {
            return this.diff.childNodeAdded(name, this.wrapAfter(name));
        }

        public boolean childNodeChanged(String name, NodeState before, NodeState after) {
            return this.diff.childNodeChanged(name, this.wrapBefore(name), this.wrapAfter(name));
        }

        public boolean childNodeDeleted(String name, NodeState before) {
            return this.diff.childNodeDeleted(name, this.wrapBefore(name));
        }

        private NodeState wrapBefore(String name) {
            return this.base.getChildNode(name);
        }

        private NodeState wrapAfter(String name) {
            return CompositeNodeState.this.getChildNode(name);
        }
    }

    private class ChildrenDiffFilter
    implements NodeStateDiff {
        private final NodeStateDiff diff;
        private final MountedNodeStore mns;
        private final boolean includeProperties;

        public ChildrenDiffFilter(NodeStateDiff diff, MountedNodeStore mns, boolean includeProperties) {
            this.diff = diff;
            this.mns = mns;
            this.includeProperties = includeProperties;
        }

        public boolean propertyAdded(PropertyState after) {
            if (this.includeProperties) {
                return this.diff.propertyAdded(after);
            }
            return true;
        }

        public boolean propertyChanged(PropertyState before, PropertyState after) {
            if (this.includeProperties) {
                return this.diff.propertyChanged(before, after);
            }
            return true;
        }

        public boolean propertyDeleted(PropertyState before) {
            if (this.includeProperties) {
                return this.diff.propertyDeleted(before);
            }
            return true;
        }

        public boolean childNodeAdded(String name, NodeState after) {
            if (this.belongsToNodeStore(name)) {
                return this.diff.childNodeAdded(name, after);
            }
            return true;
        }

        public boolean childNodeChanged(String name, NodeState before, NodeState after) {
            if (this.belongsToNodeStore(name)) {
                return this.diff.childNodeChanged(name, before, after);
            }
            return true;
        }

        public boolean childNodeDeleted(String name, NodeState before) {
            if (this.belongsToNodeStore(name)) {
                return this.diff.childNodeDeleted(name, before);
            }
            return true;
        }

        private boolean belongsToNodeStore(String name) {
            return CompositeNodeState.this.ctx.getOwningStore(PathUtils.concat((String)CompositeNodeState.this.path, (String)name)) == this.mns;
        }
    }
}

