/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.composite;

import com.google.common.base.Preconditions;
import com.google.common.collect.FluentIterable;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.List;
import org.apache.jackrabbit.oak.api.Blob;
import org.apache.jackrabbit.oak.api.PropertyState;
import org.apache.jackrabbit.oak.api.Type;
import org.apache.jackrabbit.oak.commons.PathUtils;
import org.apache.jackrabbit.oak.composite.CompositeNodeState;
import org.apache.jackrabbit.oak.composite.CompositionContext;
import org.apache.jackrabbit.oak.composite.MountedNodeStore;
import org.apache.jackrabbit.oak.composite.NodeMap;
import org.apache.jackrabbit.oak.plugins.memory.EmptyNodeState;
import org.apache.jackrabbit.oak.plugins.memory.MemoryNodeBuilder;
import org.apache.jackrabbit.oak.spi.state.AbstractNodeState;
import org.apache.jackrabbit.oak.spi.state.NodeBuilder;
import org.apache.jackrabbit.oak.spi.state.NodeState;

class CompositeNodeBuilder
implements NodeBuilder {
    private final CompositionContext ctx;
    private final NodeMap<NodeBuilder> nodeBuilders;

    CompositeNodeBuilder(NodeMap<NodeBuilder> nodeBuilders, CompositionContext ctx) {
        this.ctx = ctx;
        this.nodeBuilders = nodeBuilders;
        ctx.getNodeBuilderMonitor().onCreateNodeObject(this.getPath());
    }

    NodeBuilder getNodeBuilder(MountedNodeStore mns) {
        return this.nodeBuilders.get(mns);
    }

    public CompositeNodeState getNodeState() {
        return new CompositeNodeState(this.getPath(), this.nodeBuilders.getAndApply((mns, b) -> b.exists() ? b.getNodeState() : EmptyNodeState.MISSING_NODE), this.ctx);
    }

    public CompositeNodeState getBaseState() {
        return new CompositeNodeState(this.getPath(), this.nodeBuilders.getAndApply((mns, b) -> b.getBaseState()), this.ctx);
    }

    public boolean exists() {
        return this.getWrappedNodeBuilder().exists();
    }

    public boolean isNew() {
        return this.getWrappedNodeBuilder().isNew();
    }

    public boolean isNew(String name) {
        return this.getWrappedNodeBuilder().isNew(name);
    }

    public boolean isModified() {
        return this.getWrappedNodeBuilder().isModified();
    }

    public boolean isReplaced() {
        return this.getWrappedNodeBuilder().isReplaced();
    }

    public boolean isReplaced(String name) {
        return this.getWrappedNodeBuilder().isReplaced(name);
    }

    public long getPropertyCount() {
        return this.getWrappedNodeBuilder().getPropertyCount();
    }

    public Iterable<? extends PropertyState> getProperties() {
        return this.getWrappedNodeBuilder().getProperties();
    }

    public boolean hasProperty(String name) {
        return this.getWrappedNodeBuilder().hasProperty(name);
    }

    public PropertyState getProperty(String name) {
        return this.getWrappedNodeBuilder().getProperty(name);
    }

    public boolean getBoolean(String name) {
        return this.getWrappedNodeBuilder().getBoolean(name);
    }

    public String getString(String name) {
        return this.getWrappedNodeBuilder().getString(name);
    }

    public String getName(String name) {
        return this.getWrappedNodeBuilder().getName(name);
    }

    public Iterable<String> getNames(String name) {
        return this.getWrappedNodeBuilder().getNames(name);
    }

    public NodeBuilder setProperty(PropertyState property) throws IllegalArgumentException {
        this.getWrappedNodeBuilder().setProperty(property);
        return this;
    }

    public <T> NodeBuilder setProperty(String name, T value) throws IllegalArgumentException {
        this.getWrappedNodeBuilder().setProperty(name, value);
        return this;
    }

    public <T> NodeBuilder setProperty(String name, T value, Type<T> type) throws IllegalArgumentException {
        this.getWrappedNodeBuilder().setProperty(name, value, type);
        return this;
    }

    public NodeBuilder removeProperty(String name) {
        this.getWrappedNodeBuilder().removeProperty(name);
        return this;
    }

    public long getChildNodeCount(long max) {
        List<MountedNodeStore> contributingStores = this.ctx.getContributingStoresForBuilders(this.getPath(), this.nodeBuilders);
        if (contributingStores.isEmpty()) {
            return 0L;
        }
        if (contributingStores.size() == 1) {
            return this.getWrappedNodeBuilder().getChildNodeCount(max);
        }
        return CompositeNodeState.accumulateChildSizes((Iterable<String>)FluentIterable.from(contributingStores).transformAndConcat(mns -> {
            NodeBuilder node = this.nodeBuilders.get((MountedNodeStore)mns);
            if (node.getChildNodeCount(max) == Long.MAX_VALUE) {
                return Collections.singleton(CompositeNodeState.STOP_COUNTING_CHILDREN);
            }
            return FluentIterable.from((Iterable)node.getChildNodeNames()).filter(e -> this.belongsToStore((MountedNodeStore)mns, (String)e));
        }), max);
    }

    public Iterable<String> getChildNodeNames() {
        return FluentIterable.from(this.ctx.getContributingStoresForBuilders(this.getPath(), this.nodeBuilders)).transformAndConcat(mns -> FluentIterable.from((Iterable)this.nodeBuilders.get((MountedNodeStore)mns).getChildNodeNames()).filter(e -> this.belongsToStore((MountedNodeStore)mns, (String)e)));
    }

    public boolean hasChildNode(String name) {
        String childPath = CompositeNodeBuilder.simpleConcat(this.getPath(), name);
        MountedNodeStore mountedStore = this.ctx.getOwningStore(childPath);
        return this.nodeBuilders.get(mountedStore).hasChildNode(name);
    }

    public NodeBuilder child(String name) {
        if (this.hasChildNode(name)) {
            return this.getChildNode(name);
        }
        return this.setChildNode(name);
    }

    public NodeBuilder getChildNode(String name) {
        String childPath = CompositeNodeBuilder.simpleConcat(this.getPath(), name);
        if (!this.ctx.shouldBeComposite(childPath)) {
            MountedNodeStore mns2 = this.ctx.getOwningStore(childPath);
            this.ctx.getNodeBuilderMonitor().onSwitchNodeToNative(mns2.getMount());
            return this.nodeBuilders.get(mns2).getChildNode(name);
        }
        return new CompositeNodeBuilder(this.nodeBuilders.lazyApply((mns, b) -> b.getChildNode(name)), this.ctx);
    }

    public NodeBuilder setChildNode(String name) throws IllegalArgumentException {
        return this.setChildNode(name, EmptyNodeState.EMPTY_NODE);
    }

    public NodeBuilder setChildNode(String name, NodeState nodeState) {
        Preconditions.checkState((boolean)this.exists(), (Object)("This builder does not exist: " + PathUtils.getName((String)this.getPath())));
        String childPath = CompositeNodeBuilder.simpleConcat(this.getPath(), name);
        MountedNodeStore childStore = this.ctx.getOwningStore(childPath);
        if (childStore != this.ctx.getGlobalStore() && !this.nodeBuilders.get(childStore).exists()) {
            throw new IllegalStateException("The mount root doesn't exist: " + this.getPath() + " for " + childStore);
        }
        NodeBuilder childBuilder = this.nodeBuilders.get(childStore).setChildNode(name, nodeState);
        if (!this.ctx.shouldBeComposite(childPath)) {
            return childBuilder;
        }
        return new CompositeNodeBuilder(this.nodeBuilders.lazyApply((mns, b) -> b.getChildNode(name)).replaceNode(childStore, childBuilder), this.ctx);
    }

    public boolean remove() {
        return this.getWrappedNodeBuilder().remove();
    }

    public boolean moveTo(NodeBuilder newParent, String newName) {
        return this.getWrappedNodeBuilder().moveTo(newParent, newName);
    }

    public Blob createBlob(InputStream stream) throws IOException {
        return this.ctx.createBlob(stream);
    }

    private NodeBuilder getWrappedNodeBuilder() {
        return this.nodeBuilders.get(this.ctx.getGlobalStore());
    }

    String getPath() {
        return ((MemoryNodeBuilder)this.getWrappedNodeBuilder()).getPath();
    }

    private boolean belongsToStore(MountedNodeStore mns, String childName) {
        return this.ctx.belongsToStore(mns, this.getPath(), childName);
    }

    static String simpleConcat(String parentPath, String name) {
        AbstractNodeState.checkValidName((String)name);
        if (PathUtils.denotesRoot((String)parentPath)) {
            return parentPath + name;
        }
        return new StringBuilder(parentPath.length() + name.length() + 1).append(parentPath).append('/').append(name).toString();
    }
}

