/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.composite;

import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Optional;
import javax.annotation.Nonnull;
import org.apache.jackrabbit.oak.api.CommitFailedException;
import org.apache.jackrabbit.oak.composite.CompositeNodeBuilder;
import org.apache.jackrabbit.oak.composite.CompositeNodeState;
import org.apache.jackrabbit.oak.composite.CompositionContext;
import org.apache.jackrabbit.oak.composite.MountedNodeStore;
import org.apache.jackrabbit.oak.spi.commit.CommitHook;
import org.apache.jackrabbit.oak.spi.commit.CommitInfo;
import org.apache.jackrabbit.oak.spi.state.ApplyDiff;
import org.apache.jackrabbit.oak.spi.state.NodeBuilder;
import org.apache.jackrabbit.oak.spi.state.NodeState;
import org.apache.jackrabbit.oak.spi.state.NodeStateDiff;

class CommitHookEnhancer
implements CommitHook {
    private final CompositionContext ctx;
    private final CompositeNodeBuilder builder;
    private final CommitHook hook;
    private Optional<CompositeNodeBuilder> updatedBuilder = Optional.empty();

    CommitHookEnhancer(CommitHook hook, CompositionContext ctx, CompositeNodeBuilder builder) {
        this.ctx = ctx;
        this.builder = builder;
        this.hook = hook;
    }

    @Nonnull
    public NodeState processCommit(NodeState before, NodeState after, CommitInfo info) throws CommitFailedException {
        HashMap beforeStates = Maps.newHashMap();
        HashMap afterStates = Maps.newHashMap();
        for (MountedNodeStore mns : this.ctx.getNonDefaultStores()) {
            if (mns.getMount().isReadOnly()) {
                NodeState root = mns.getNodeStore().getRoot();
                afterStates.put(mns, root);
                beforeStates.put(mns, root);
                continue;
            }
            afterStates.put(mns, mns.getNodeStore().rebase(this.builder.getNodeBuilder(mns)));
            beforeStates.put(mns, this.builder.getNodeBuilder(mns).getBaseState());
        }
        afterStates.put(this.ctx.getGlobalStore(), after);
        beforeStates.put(this.ctx.getGlobalStore(), before);
        CompositeNodeState compositeBefore = this.ctx.createRootNodeState(beforeStates);
        CompositeNodeState compositeAfter = this.ctx.createRootNodeState(afterStates);
        NodeState result = this.hook.processCommit((NodeState)compositeBefore, (NodeState)compositeAfter, info);
        this.updatedBuilder = Optional.of(this.toComposite(result, compositeBefore));
        if (result instanceof CompositeNodeState) {
            return ((CompositeNodeState)result).getNodeState(this.ctx.getGlobalStore());
        }
        throw new IllegalStateException("The commit hook result should be a composite node state");
    }

    Optional<CompositeNodeBuilder> getUpdatedBuilder() {
        return this.updatedBuilder;
    }

    private CompositeNodeBuilder toComposite(NodeState nodeState, CompositeNodeState compositeRoot) {
        CompositeNodeBuilder builder = compositeRoot.builder();
        nodeState.compareAgainstBaseState((NodeState)compositeRoot, (NodeStateDiff)new ApplyDiff((NodeBuilder)builder));
        return builder;
    }
}

