/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.javax.activation.internal;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import javax.activation.CommandMap;
import org.apache.sling.javax.activation.internal.OsgiMailcapCommandMap;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleEvent;
import org.osgi.util.tracker.BundleTracker;
import org.osgi.util.tracker.BundleTrackerCustomizer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Activator
implements BundleActivator {
    private static final String MAILCAP_FILE_NAME = "/META-INF/mailcap";
    private static final Logger log = LoggerFactory.getLogger(Activator.class);
    private BundleTracker bundleTracker;
    private OsgiMailcapCommandMap commandMap;

    public void start(BundleContext context) throws Exception {
        this.commandMap = new OsgiMailcapCommandMap();
        for (Bundle bundle : context.getBundles()) {
            this.registerBundleMailcapEntries(bundle);
        }
        CommandMap.setDefaultCommandMap(this.commandMap);
        this.bundleTracker = new BundleTracker(context, 33, new BundleTrackerCustomizer(){

            public void removedBundle(Bundle bundle, BundleEvent event, Object object) {
                Activator.this.unregisterBundleMailcapEntries(bundle);
            }

            public void modifiedBundle(Bundle bundle, BundleEvent event, Object object) {
                Activator.this.unregisterBundleMailcapEntries(bundle);
                Activator.this.registerBundleMailcapEntries(bundle);
            }

            public Object addingBundle(Bundle bundle, BundleEvent event) {
                Activator.this.registerBundleMailcapEntries(bundle);
                return bundle;
            }
        });
        this.bundleTracker.open();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void registerBundleMailcapEntries(Bundle bundle) {
        if (bundle.getState() != 32) {
            return;
        }
        URL mailcapEntry = bundle.getEntry(MAILCAP_FILE_NAME);
        if (mailcapEntry == null) {
            return;
        }
        InputStream input = null;
        try {
            input = mailcapEntry.openStream();
            this.commandMap.addMailcapEntries(input, bundle);
        }
        catch (IOException e) {
            log.warn("Failed loading /META-INF/mailcap from bundle " + bundle, (Throwable)e);
        }
        finally {
            try {
                input.close();
            }
            catch (IOException e) {}
        }
    }

    private void unregisterBundleMailcapEntries(Bundle bundle) {
        this.commandMap.removeMailcapEntriesForBundle(bundle);
    }

    public void stop(BundleContext context) throws Exception {
        if (this.bundleTracker != null) {
            this.bundleTracker.close();
            this.bundleTracker = null;
        }
        CommandMap.setDefaultCommandMap(null);
    }
}

