/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.hc.webconsole.impl;

import java.io.PrintWriter;
import org.apache.sling.api.request.ResponseUtil;

class WebConsoleHelper {
    final PrintWriter pw;

    WebConsoleHelper(PrintWriter w) {
        this.pw = w;
    }

    PrintWriter writer() {
        return this.pw;
    }

    void tdContent() {
        this.pw.print("<td class='content' colspan='2'>");
    }

    void closeTd() {
        this.pw.print("</td>");
    }

    void closeTr() {
        this.pw.println("</tr>");
    }

    void tdLabel(String label) {
        this.pw.print("<td class='content'>");
        this.pw.print(ResponseUtil.escapeXml((String)label));
        this.pw.println("</td>");
    }

    void tr() {
        this.pw.println("<tr class='content'>");
    }

    void titleHtml(String title, String description) {
        this.tr();
        this.pw.print("<th colspan='3' class='content container'>");
        this.pw.print(ResponseUtil.escapeXml((String)title));
        this.pw.println("</th>");
        this.closeTr();
        if (description != null) {
            this.tr();
            this.pw.print("<td colspan='3' class='content'>");
            this.pw.print(ResponseUtil.escapeXml((String)description));
            this.pw.println("</th>");
            this.closeTr();
        }
    }
}

