/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.hc.webconsole.impl;

import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.text.SimpleDateFormat;
import java.util.List;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Properties;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.api.request.ResponseUtil;
import org.apache.sling.hc.api.Result;
import org.apache.sling.hc.api.ResultLog;
import org.apache.sling.hc.api.execution.HealthCheckExecutionOptions;
import org.apache.sling.hc.api.execution.HealthCheckExecutionResult;
import org.apache.sling.hc.api.execution.HealthCheckExecutor;
import org.apache.sling.hc.util.FormattingResultLog;
import org.apache.sling.hc.webconsole.impl.WebConsoleHelper;

@Component
@Service(value={Servlet.class})
@Properties(value={@Property(name="service.description", value={"Apache Sling Health Check Web Console Plugin"}), @Property(name="felix.webconsole.label", value={"healthcheck"}), @Property(name="felix.webconsole.title", value={"Sling Health Check"}), @Property(name="felix.webconsole.category", value={"Sling"}), @Property(name="felix.webconsole.css", value={"/healthcheck/res/ui/healthcheck.css"})})
public class HealthCheckWebconsolePlugin
extends HttpServlet {
    public static final String TITLE = "Sling Health Check";
    public static final String LABEL = "healthcheck";
    public static final String CATEGORY = "Sling";
    public static final String PARAM_TAGS = "tags";
    public static final String PARAM_DEBUG = "debug";
    public static final String PARAM_QUIET = "quiet";
    public static final String PARAM_FORCE_INSTANT_EXECUTION = "forceInstantExecution";
    public static final String PARAM_COMBINE_TAGS_WITH_OR = "combineTagsWithOr";
    public static final String PARAM_OVERRIDE_GLOBAL_TIMEOUT = "overrideGlobalTimeout";
    @Reference
    private HealthCheckExecutor healthCheckExecutor;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean getStaticResource(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        String pathInfo = req.getPathInfo();
        if (pathInfo != null && pathInfo.contains("res/ui")) {
            String prefix = "/healthcheck";
            InputStream is = ((Object)((Object)this)).getClass().getResourceAsStream(pathInfo.substring("/healthcheck".length()));
            if (is == null) {
                resp.sendError(404, pathInfo);
            } else {
                ServletOutputStream os = resp.getOutputStream();
                try {
                    byte[] buffer = new byte[16384];
                    int n = 0;
                    while ((n = is.read(buffer, 0, buffer.length)) > 0) {
                        os.write(buffer, 0, n);
                    }
                }
                finally {
                    try {
                        is.close();
                    }
                    catch (IOException ignore) {}
                }
            }
            return true;
        }
        return false;
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        if (this.getStaticResource(req, resp)) {
            return;
        }
        String tags = this.getParam(req, PARAM_TAGS, null);
        boolean debug = Boolean.valueOf(this.getParam(req, PARAM_DEBUG, "false"));
        boolean quiet = Boolean.valueOf(this.getParam(req, PARAM_QUIET, "false"));
        boolean combineTagsWithOr = Boolean.valueOf(this.getParam(req, PARAM_COMBINE_TAGS_WITH_OR, "false"));
        boolean forceInstantExecution = Boolean.valueOf(this.getParam(req, PARAM_FORCE_INSTANT_EXECUTION, "false"));
        String overrideGlobalTimeoutStr = this.getParam(req, PARAM_OVERRIDE_GLOBAL_TIMEOUT, "");
        PrintWriter pw = resp.getWriter();
        this.doForm(pw, tags, debug, quiet, combineTagsWithOr, forceInstantExecution, overrideGlobalTimeoutStr);
        if (tags != null) {
            HealthCheckExecutionOptions options = new HealthCheckExecutionOptions();
            options.setCombineTagsWithOr(combineTagsWithOr);
            options.setForceInstantExecution(forceInstantExecution);
            try {
                options.setOverrideGlobalTimeout(Integer.valueOf(overrideGlobalTimeoutStr).intValue());
            }
            catch (NumberFormatException nfe) {
                // empty catch block
            }
            List results = this.healthCheckExecutor.execute(options, tags.split(","));
            pw.println("<table class='content healthcheck' cellpadding='0' cellspacing='0' width='100%'>");
            int total = 0;
            int failed = 0;
            for (HealthCheckExecutionResult exR : results) {
                Result r = exR.getHealthCheckResult();
                ++total;
                if (!r.isOk()) {
                    ++failed;
                }
                if (quiet && r.isOk()) continue;
                this.renderResult(pw, exR, debug);
            }
            WebConsoleHelper c = new WebConsoleHelper(resp.getWriter());
            c.titleHtml("Summary", total + " HealthCheck executed, " + failed + " failures");
            pw.println("</table>");
            pw.println("<a href='configMgr/org.apache.sling.hc.core.impl.executor.HealthCheckExecutorImpl'>Configure executor</a><br/><br/>");
        }
    }

    private void renderResult(PrintWriter pw, HealthCheckExecutionResult exResult, boolean debug) throws IOException {
        Result result = exResult.getHealthCheckResult();
        WebConsoleHelper c = new WebConsoleHelper(pw);
        StringBuilder status = new StringBuilder();
        status.append("Tags: ").append(exResult.getHealthCheckMetadata().getTags());
        status.append(" Finished: ").append(new SimpleDateFormat("yyyy-MM-dd mm:ss").format(exResult.getFinishedAt()) + " after " + FormattingResultLog.msHumanReadable((long)exResult.getElapsedTimeInMs()));
        c.titleHtml(exResult.getHealthCheckMetadata().getTitle(), null);
        c.tr();
        c.tdContent();
        c.writer().print(ResponseUtil.escapeXml((String)status.toString()));
        c.writer().print("<br/>Result: <span class='resultOk");
        c.writer().print(result.isOk());
        c.writer().print("'>");
        c.writer().print(result.getStatus().toString());
        c.writer().print("</span>");
        c.closeTd();
        c.closeTr();
        c.tr();
        c.tdContent();
        for (ResultLog.Entry e : result) {
            if (!debug && e.getStatus().equals((Object)Result.Status.DEBUG)) continue;
            c.writer().print("<div class='log");
            c.writer().print(e.getStatus().toString());
            c.writer().print("'>");
            c.writer().print(e.getStatus().toString());
            c.writer().print(' ');
            c.writer().print(ResponseUtil.escapeXml((String)e.getMessage()));
            if (e.getException() != null) {
                c.writer().print(" ");
                c.writer().print(ResponseUtil.escapeXml((String)e.getException().toString()));
            }
            c.writer().println("</div>");
        }
        c.closeTd();
    }

    private void doForm(PrintWriter pw, String tags, boolean debug, boolean quiet, boolean combineTagsWithOr, boolean forceInstantExecution, String overrideGlobalTimeoutStr) throws IOException {
        WebConsoleHelper c = new WebConsoleHelper(pw);
        pw.print("<form method='get'>");
        pw.println("<table class='content' cellpadding='0' cellspacing='0' width='100%'>");
        c.titleHtml(TITLE, "To execute health check services, enter  an optional list of tags, to select specific health checks, or no tags for all checks. Prefix a tag with a minus sign (-) to omit checks having that tag.");
        c.tr();
        c.tdLabel("Health Check tags (comma-separated)");
        c.tdContent();
        c.writer().print("<input type='text' name='tags' value='");
        if (tags != null) {
            c.writer().print(ResponseUtil.escapeXml((String)tags));
        }
        c.writer().println("' class='input' size='80'>");
        c.closeTd();
        c.closeTr();
        c.tr();
        c.tdLabel("Combine tags with logical 'OR' instead of the default 'AND'");
        c.tdContent();
        c.writer().print("<input type='checkbox' name='combineTagsWithOr' class='input' value='true'");
        if (combineTagsWithOr) {
            c.writer().print(" checked=true");
        }
        c.writer().println(">");
        c.closeTd();
        c.closeTr();
        c.tr();
        c.tdLabel("Show DEBUG logs");
        c.tdContent();
        c.writer().print("<input type='checkbox' name='debug' class='input' value='true'");
        if (debug) {
            c.writer().print(" checked=true");
        }
        c.writer().println(">");
        c.closeTd();
        c.closeTr();
        c.tr();
        c.tdLabel("Show failed checks only");
        c.tdContent();
        c.writer().print("<input type='checkbox' name='quiet' class='input' value='true'");
        if (quiet) {
            c.writer().print(" checked=true");
        }
        c.writer().println(">");
        c.closeTd();
        c.closeTr();
        c.tr();
        c.tdLabel("Force instant execution (no cache, async checks are executed)");
        c.tdContent();
        c.writer().print("<input type='checkbox' name='forceInstantExecution' class='input' value='true'");
        if (forceInstantExecution) {
            c.writer().print(" checked=true");
        }
        c.writer().println(">");
        c.closeTd();
        c.closeTr();
        c.tr();
        c.tdLabel("Override global timeout");
        c.tdContent();
        c.writer().print("<input type='text' name='overrideGlobalTimeout' value='");
        if (overrideGlobalTimeoutStr != null) {
            c.writer().print(ResponseUtil.escapeXml((String)overrideGlobalTimeoutStr));
        }
        c.writer().println("' class='input' size='80'>");
        c.closeTd();
        c.closeTr();
        c.tr();
        c.tdContent();
        c.writer().println("<input type='submit' value='Execute selected health checks'/>");
        c.closeTd();
        c.closeTr();
        c.writer().println("</table></form>");
    }

    private String getParam(HttpServletRequest req, String name, String defaultValue) {
        String result = req.getParameter(name);
        if (result == null) {
            result = defaultValue;
        }
        return result;
    }

    protected void bindHealthCheckExecutor(HealthCheckExecutor healthCheckExecutor) {
        this.healthCheckExecutor = healthCheckExecutor;
    }

    protected void unbindHealthCheckExecutor(HealthCheckExecutor healthCheckExecutor) {
        if (this.healthCheckExecutor == healthCheckExecutor) {
            this.healthCheckExecutor = null;
        }
    }
}

