/*
 * Decompiled with CFR 0.152.
 */
package com.composum.sling.nodes.servlet;

import com.composum.sling.core.BeanContext;
import com.composum.sling.core.util.ResourceUtil;
import com.composum.sling.nodes.NodesConfiguration;
import com.composum.sling.nodes.servlet.SourceModel;
import java.io.IOException;
import java.io.OutputStream;
import javax.jcr.RepositoryException;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import org.apache.commons.lang3.StringUtils;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.sling.SlingServlet;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.api.request.RequestPathInfo;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.servlets.SlingSafeMethodsServlet;
import org.osgi.framework.BundleContext;

@SlingServlet(methods={"GET"}, paths={"/bin/cpm/nodes/source"}, extensions={"xml", "zip", "pkg"})
public class SourceServlet
extends SlingSafeMethodsServlet {
    @Reference
    protected NodesConfiguration nodesConfig;
    protected BundleContext bundleContext;

    @Activate
    private void activate(BundleContext bundleContext) {
        this.bundleContext = bundleContext;
    }

    protected boolean isEnabled() {
        return this.nodesConfig.isEnabled((Servlet)this);
    }

    protected void doGet(SlingHttpServletRequest request, SlingHttpServletResponse response) throws ServletException, IOException {
        if (!this.isEnabled()) {
            response.sendError(503);
            return;
        }
        Resource resource = null;
        RequestPathInfo pathInfo = request.getRequestPathInfo();
        String resourcePath = pathInfo.getSuffix();
        if (StringUtils.isNotBlank((CharSequence)resourcePath)) {
            ResourceResolver resolver = request.getResourceResolver();
            resource = resolver.getResource(resourcePath);
        }
        if (resource != null && !ResourceUtil.isNonExistingResource(resource)) {
            try {
                SourceModel sourceModel = new SourceModel(this.nodesConfig, (BeanContext)new BeanContext.Servlet(this.getServletContext(), this.bundleContext, request, response), resource);
                String name = resource.getName();
                switch (pathInfo.getExtension()) {
                    case "xml": {
                        response.setCharacterEncoding("UTF-8");
                        response.setContentType("text/plain;charset=UTF-8");
                        response.setHeader("Content-Disposition", "inline; filename=.content.xml");
                        sourceModel.writeFile(response.getWriter(), false);
                        break;
                    }
                    case "zip": {
                        if (!name.endsWith(".zip")) {
                            name = name + ".zip";
                        }
                        response.setContentType("application/octet-stream");
                        response.setHeader("Content-Disposition", "inline; filename=" + name);
                        sourceModel.writeArchive((OutputStream)response.getOutputStream());
                        break;
                    }
                    case "pkg": {
                        String group = "source";
                        if (name.endsWith(".zip")) {
                            name = name.substring(0, name.length() - 4);
                        }
                        name = name + "-source-package";
                        String version = "current";
                        response.setContentType("application/octet-stream");
                        response.setHeader("Content-Disposition", "inline; filename=" + name + "-" + version + ".zip");
                        sourceModel.writePackage((OutputStream)response.getOutputStream(), group, name, version);
                        break;
                    }
                    default: {
                        response.sendError(400);
                        break;
                    }
                }
            }
            catch (RepositoryException ex) {
                throw new ServletException((Throwable)ex);
            }
        } else {
            response.sendError(404);
        }
    }

    protected void bindNodesConfig(NodesConfiguration nodesConfiguration) {
        this.nodesConfig = nodesConfiguration;
    }

    protected void unbindNodesConfig(NodesConfiguration nodesConfiguration) {
        if (this.nodesConfig == nodesConfiguration) {
            this.nodesConfig = null;
        }
    }
}

