/*
 * Decompiled with CFR 0.152.
 */
package com.composum.sling.nodes.servlet;

import com.composum.sling.core.BeanContext;
import com.composum.sling.core.util.ResourceUtil;
import com.composum.sling.nodes.NodesConfiguration;
import com.composum.sling.nodes.console.ConsoleSlingBean;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.jcr.RepositoryException;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.jackrabbit.util.ISO9075;
import org.apache.sling.api.resource.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SourceModel
extends ConsoleSlingBean {
    private static final Logger LOG = LoggerFactory.getLogger(SourceModel.class);
    public static final Map<String, String> NAMESPACES = new HashMap<String, String>();
    public static final List<Pattern> EXCLUDED_PROPS;
    public static final String DATE_FORMAT = "yyyy-MM-dd'T'HH:mm:ss.SSSXXX";
    protected final NodesConfiguration config;
    private transient List<Property> propertyList;
    private transient List<Resource> subnodeList;

    public SourceModel(NodesConfiguration config, BeanContext context, Resource resource) {
        this.config = config;
        this.initialize(context, resource);
    }

    public String getName() {
        return this.resource.getName();
    }

    public String getPrimaryType() {
        return StringUtils.defaultString((String)ResourceUtil.getPrimaryType((Resource)this.resource));
    }

    public List<Property> getPropertyList() {
        if (this.propertyList == null) {
            this.propertyList = new ArrayList<Property>();
            for (Map.Entry entry : this.resource.getProperties().entrySet()) {
                Property property = new Property((String)entry.getKey(), entry.getValue());
                if (this.isExcluded(property)) continue;
                this.propertyList.add(property);
            }
            Collections.sort(this.propertyList);
        }
        return this.propertyList;
    }

    protected boolean isExcluded(Property property) {
        for (Pattern rule : EXCLUDED_PROPS) {
            if (!rule.matcher(property.getName()).matches()) continue;
            return true;
        }
        return false;
    }

    public boolean getHasSubnodes() {
        return !this.getSubnodeList().isEmpty();
    }

    public List<Resource> getSubnodeList() {
        if (this.subnodeList == null) {
            this.subnodeList = new ArrayList<Resource>();
            Iterator iterator = this.resource.listChildren();
            while (iterator.hasNext()) {
                Resource subnode = (Resource)iterator.next();
                if (!this.config.getSourceNodesFilter().accept(subnode)) continue;
                this.subnodeList.add(subnode);
            }
        }
        return this.subnodeList;
    }

    public void determineNamespaces(List<String> keys, boolean contentOnly) {
        String primaryType = this.getPrimaryType();
        this.addNameNamespace(keys, primaryType);
        List<Property> properties = this.getPropertyList();
        for (Property property : properties) {
            String ns = property.getNs();
            this.addNamespace(keys, ns);
        }
        if (contentOnly) {
            Resource contentResource = this.resource.getChild("jcr:content");
            if (contentResource != null) {
                SourceModel subnodeModel = new SourceModel(this.config, this.context, contentResource);
                subnodeModel.determineNamespaces(keys, false);
            }
        } else {
            for (Resource subnode : this.getSubnodeList()) {
                SourceModel subnodeModel = new SourceModel(this.config, this.context, subnode);
                subnodeModel.determineNamespaces(keys, false);
            }
        }
    }

    public void addNameNamespace(List<String> keys, String name) {
        String ns = this.getNamespace(name);
        this.addNamespace(keys, ns);
    }

    public void addNamespace(List<String> keys, String ns) {
        if (StringUtils.isNotBlank((CharSequence)ns) && !keys.contains(ns)) {
            keys.add(ns);
        }
    }

    public String getNamespace(String name) {
        int delim = name.indexOf(58);
        return delim < 0 ? "" : name.substring(0, delim);
    }

    public void writePackage(OutputStream output, String group, String name, String version) throws IOException, RepositoryException {
        String root = "jcr_root";
        ZipOutputStream zipStream = new ZipOutputStream(output);
        this.writeProperties(zipStream, group, name, version);
        this.writeFilter(zipStream);
        this.writeParents(zipStream, root, (Resource)this.resource.getParent());
        this.writeZip(zipStream, root, true);
        zipStream.flush();
        zipStream.close();
    }

    public void writeProperties(ZipOutputStream zipStream, String group, String name, String version) throws IOException {
        ZipEntry entry = new ZipEntry("META-INF/vault/properties.xml");
        zipStream.putNextEntry(entry);
        OutputStreamWriter writer = new OutputStreamWriter((OutputStream)zipStream, "UTF-8");
        ((Writer)writer).append("<?xml version=\"1.0\" encoding=\"utf-8\" standalone=\"no\"?>\n").append("<!DOCTYPE properties SYSTEM \"http://java.sun.com/dtd/properties.dtd\">\n").append("<properties>\n").append("<comment>FileVault Package Properties</comment>\n").append("<entry key=\"name\">").append(name).append("</entry>\n").append("<entry key=\"buildCount\">1</entry>\n").append("<entry key=\"version\">").append(version).append("</entry>\n").append("<entry key=\"packageFormatVersion\">2</entry>\n").append("<entry key=\"group\">").append(group).append("</entry>\n").append("<entry key=\"description\">created from source download</entry>\n").append("</properties>");
        ((Writer)writer).flush();
        zipStream.closeEntry();
    }

    public void writeFilter(ZipOutputStream zipStream) throws IOException {
        String path = this.resource.getPath();
        ZipEntry entry = new ZipEntry("META-INF/vault/filter.xml");
        zipStream.putNextEntry(entry);
        OutputStreamWriter writer = new OutputStreamWriter((OutputStream)zipStream, "UTF-8");
        ((Writer)writer).append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n").append("<workspaceFilter version=\"1.0\">\n").append("    <filter root=\"").append(path).append("\"/>\n").append("</workspaceFilter>\n");
        ((Writer)writer).flush();
        zipStream.closeEntry();
    }

    public void writeParents(ZipOutputStream zipStream, String root, Resource parent) throws IOException, RepositoryException {
        if (parent != null && !"/".equals(parent.getPath())) {
            this.writeParents(zipStream, root, parent.getParent());
            SourceModel parentModel = new SourceModel(this.config, this.context, parent);
            parentModel.writeZip(zipStream, root, false);
        }
    }

    public void writeArchive(OutputStream output) throws IOException, RepositoryException {
        ZipOutputStream zipStream = new ZipOutputStream(output);
        this.writeZip(zipStream, this.resource.getPath(), true);
        zipStream.flush();
        zipStream.close();
    }

    public void writeZip(ZipOutputStream zipStream, String root, boolean writeDeep) throws IOException, RepositoryException {
        String path = this.resource.getPath();
        ZipEntry entry = new ZipEntry(this.getZipName(root, path + "/.content.xml"));
        zipStream.putNextEntry(entry);
        OutputStreamWriter writer = new OutputStreamWriter((OutputStream)zipStream, "UTF-8");
        this.writeFile(writer, true);
        ((Writer)writer).flush();
        zipStream.closeEntry();
        if (writeDeep) {
            for (Resource subnode : this.getSubnodeList()) {
                if ("jcr:content".equals(subnode.getName())) continue;
                if (ResourceUtil.isFile((Resource)subnode)) {
                    this.writeFile(zipStream, root, subnode);
                    continue;
                }
                SourceModel subnodeModel = new SourceModel(this.config, this.context, subnode);
                subnodeModel.writeZip(zipStream, root, true);
            }
        }
    }

    public void writeFile(ZipOutputStream zipStream, String root, Resource file) throws IOException, RepositoryException {
        String path = file.getPath();
        ZipEntry entry = new ZipEntry(this.getZipName(root, path));
        zipStream.putNextEntry(entry);
        try (InputStream fileContent = ResourceUtil.getBinaryData((Resource)file).getStream();){
            IOUtils.copy((InputStream)fileContent, (OutputStream)zipStream);
        }
        zipStream.closeEntry();
    }

    public String getZipName(String root, String path) {
        String name = path;
        name = name.startsWith(root) ? name.substring(root.length() + 1) : root + name;
        return name;
    }

    public void writeFile(Writer writer, boolean contentOnly) throws IOException {
        ArrayList<String> namespaces = new ArrayList<String>();
        namespaces.add("jcr");
        this.determineNamespaces(namespaces, contentOnly);
        Collections.sort(namespaces);
        writer.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n");
        writer.append("<jcr:root");
        int i = 0;
        while (i < namespaces.size()) {
            String ns = (String)namespaces.get(i);
            String url = NAMESPACES.get(ns);
            if (StringUtils.isNotBlank((CharSequence)url)) {
                writer.append(" xmlns:").append(ns).append("=\"").append(url).append("\"");
                if (++i >= namespaces.size()) continue;
                writer.append("\n         ");
                continue;
            }
            ++i;
        }
        this.writeProperty(writer, "        ", "jcr:primaryType", this.getPrimaryType());
        this.writeProperties(writer, "        ");
        writer.append(">\n");
        Resource contentResource = this.resource.getChild("jcr:content");
        if (contentResource != null) {
            SourceModel subnodeModel = new SourceModel(this.config, this.context, contentResource);
            subnodeModel.writeXml(writer, "    ");
            for (Resource subnode : this.getSubnodeList()) {
                String name = subnode.getName();
                if ("jcr:content".equals(name)) continue;
                writer.append("    <").append(name).append("/>\n");
            }
        } else if (!contentOnly) {
            this.writeSubnodes(writer, "    ");
        }
        writer.append("</jcr:root>\n");
    }

    public void writeXml(Writer writer, String indent) throws IOException {
        String name = this.escapeXmlName(this.getName());
        writer.append(indent).append("<").append(name).append('\n');
        writer.append(indent).append("        ").append("jcr:primaryType=\"").append(this.getPrimaryType()).append("\"");
        this.writeProperties(writer, indent + "        ");
        if (this.getHasSubnodes()) {
            writer.append(">\n");
            this.writeSubnodes(writer, indent + "    ");
            writer.append(indent).append("</").append(name).append(">\n");
        } else {
            writer.append("/>\n");
        }
    }

    public void writeSubnodes(Writer writer, String indent) throws IOException {
        for (Resource subnode : this.getSubnodeList()) {
            SourceModel subnodeModel = new SourceModel(this.config, this.context, subnode);
            subnodeModel.writeXml(writer, indent);
        }
    }

    public void writeProperties(Writer writer, String indent) throws IOException {
        for (Property property : this.getPropertyList()) {
            this.writeProperty(writer, indent, property.getName(), property.getString(indent));
        }
    }

    public void writeProperty(Writer writer, String indent, String name, String value) throws IOException {
        writer.append("\n");
        writer.append(indent);
        writer.append(this.escapeXmlName(name));
        writer.append("=\"");
        writer.append(this.escapeXmlAttribute(value));
        writer.append("\"");
    }

    public String escapeXmlName(String name) {
        return ISO9075.encode((String)name).replaceAll("&", "&amp;").replaceAll("<", "&lt;").replaceAll(">", "&gt;").replaceAll("'", "&apos;").replaceAll("\"", "&quot;");
    }

    public String escapeXmlAttribute(String value) {
        return value.replaceAll("&", "&amp;").replaceAll("<", "&lt;").replaceAll("'", "&apos;").replaceAll("\"", "&quot;").replaceAll("\t", "&#x9;").replaceAll("\n", "&#xa;").replaceAll("\r", "\n");
    }

    static {
        NAMESPACES.put("jcr", "http://www.jcp.org/jcr/1.0");
        NAMESPACES.put("nt", "http://www.jcp.org/jcr/nt/1.0");
        NAMESPACES.put("mix", "http://www.jcp.org/jcr/mix/1.0");
        NAMESPACES.put("sling", "http://sling.apache.org/jcr/sling/1.0");
        NAMESPACES.put("cpp", "http://sling.composum.com/pages/1.0");
        NAMESPACES.put("cpa", "http://sling.composum.com/assets/1.0");
        NAMESPACES.put("cq", "http://www.day.com/jcr/cq/1.0");
        EXCLUDED_PROPS = new ArrayList<Pattern>();
        EXCLUDED_PROPS.add(Pattern.compile("^jcr:primaryType"));
        EXCLUDED_PROPS.add(Pattern.compile("^jcr:baseVersion"));
        EXCLUDED_PROPS.add(Pattern.compile("^jcr:predecessors"));
        EXCLUDED_PROPS.add(Pattern.compile("^jcr:versionHistory"));
        EXCLUDED_PROPS.add(Pattern.compile("^jcr:isCheckedOut"));
        EXCLUDED_PROPS.add(Pattern.compile("^jcr:created.*"));
        EXCLUDED_PROPS.add(Pattern.compile("^jcr:lastModified.*"));
        EXCLUDED_PROPS.add(Pattern.compile("^jcr:uuid"));
        EXCLUDED_PROPS.add(Pattern.compile("^jcr:data"));
        EXCLUDED_PROPS.add(Pattern.compile("^cq:lastModified.*"));
        EXCLUDED_PROPS.add(Pattern.compile("^cq:lastReplicat.*"));
    }

    public class Property
    implements Comparable<Property> {
        protected final String name;
        protected final Object value;

        public Property(String name, Object value) {
            this.name = name;
            this.value = value;
        }

        public String getNs() {
            int ddot = this.name.indexOf(58);
            return ddot > 0 ? this.name.substring(0, ddot) : "";
        }

        public boolean isMultiValue() {
            return this.value instanceof Object[];
        }

        public String getName() {
            return this.name;
        }

        public String getString(String indent) {
            if (this.isMultiValue()) {
                StringBuilder buffer = new StringBuilder();
                buffer.append(this.getTypePrefix(this.value));
                Object[] array = (Object[])this.value;
                String lineBreak = "";
                if (array.length > 0 && this.getString(array[0]).startsWith(" ")) {
                    lineBreak = "\r";
                }
                buffer.append("[").append(lineBreak);
                int i = 0;
                while (i < array.length) {
                    String string = this.getString(array[i]);
                    string = string.replaceAll(",", "\\\\,");
                    if (StringUtils.isNotEmpty((CharSequence)lineBreak)) {
                        string = string.trim();
                        buffer.append(indent).append("    ");
                    }
                    buffer.append(string);
                    if (++i >= array.length) continue;
                    buffer.append(',').append(lineBreak);
                }
                if (StringUtils.isNotEmpty((CharSequence)lineBreak)) {
                    buffer.append(lineBreak).append(indent);
                }
                buffer.append("]");
                return buffer.toString();
            }
            return this.getTypePrefix(this.value) + this.getString(this.value);
        }

        public String getString(Object value) {
            if (value instanceof Calendar) {
                SimpleDateFormat formatter = new SimpleDateFormat(SourceModel.DATE_FORMAT);
                return formatter.format(((Calendar)value).getTime());
            }
            return value != null ? value.toString() : "";
        }

        public String getTypePrefix(Object value) {
            if (value instanceof String || value instanceof String[]) {
                return "";
            }
            if (value instanceof Boolean || value instanceof Boolean[]) {
                return "{Boolean}";
            }
            if (value instanceof BigDecimal || value instanceof BigDecimal[]) {
                return "{Decimal}";
            }
            if (value instanceof Long || value instanceof Long[]) {
                return "{Long}";
            }
            if (value instanceof Double || value instanceof Double[]) {
                return "{Double}";
            }
            if (value instanceof Calendar || value instanceof Calendar[]) {
                return "{Date}";
            }
            return "";
        }

        @Override
        public int compareTo(Property other) {
            if (other == null) {
                return 1;
            }
            String ns = this.getNs();
            String ons = other.getNs();
            if (ns.isEmpty() && !ons.isEmpty()) {
                return 1;
            }
            if (!ns.isEmpty() && ons.isEmpty()) {
                return -1;
            }
            if (!ns.equals(ons)) {
                return ns.compareTo(ons);
            }
            return this.getName().compareTo(other.getName());
        }
    }
}

