/*
 * Decompiled with CFR 0.152.
 */
package com.composum.sling.nodes.servlet;

import com.composum.sling.core.ResourceHandle;
import com.composum.sling.core.servlet.AbstractServiceServlet;
import com.composum.sling.core.servlet.ServletOperation;
import com.composum.sling.core.servlet.ServletOperationSet;
import com.composum.sling.core.util.JsonUtil;
import com.composum.sling.core.util.RequestUtil;
import com.composum.sling.core.util.ResponseUtil;
import com.composum.sling.nodes.NodesConfiguration;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.security.AccessControlEntry;
import javax.jcr.security.AccessControlList;
import javax.jcr.security.AccessControlManager;
import javax.jcr.security.AccessControlPolicy;
import javax.jcr.security.AccessControlPolicyIterator;
import javax.jcr.security.NamedAccessControlPolicy;
import javax.jcr.security.Privilege;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.sling.SlingServlet;
import org.apache.jackrabbit.api.JackrabbitSession;
import org.apache.jackrabbit.api.security.JackrabbitAccessControlEntry;
import org.apache.jackrabbit.api.security.JackrabbitAccessControlList;
import org.apache.jackrabbit.api.security.principal.PrincipalManager;
import org.apache.jackrabbit.api.security.user.Authorizable;
import org.apache.jackrabbit.api.security.user.Query;
import org.apache.jackrabbit.api.security.user.QueryBuilder;
import org.apache.jackrabbit.commons.jackrabbit.authorization.AccessControlUtils;
import org.apache.jackrabbit.value.StringValue;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.api.resource.ResourceResolver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@SlingServlet(paths={"/bin/cpm/nodes/security"}, methods={"GET", "POST", "PUT", "DELETE"})
public class SecurityServlet
extends AbstractServiceServlet {
    private static final Logger LOG = LoggerFactory.getLogger(SecurityServlet.class);
    public static final String PARAM_SCOPE = "scope";
    @Reference
    private NodesConfiguration coreConfig;
    protected ServletOperationSet<Extension, Operation> operations = new ServletOperationSet((Enum)Extension.json);

    protected ServletOperationSet getOperations() {
        return this.operations;
    }

    protected boolean isEnabled() {
        return this.coreConfig.isEnabled((Servlet)this);
    }

    public void init() throws ServletException {
        super.init();
        this.operations.setOperation(ServletOperationSet.Method.GET, (Enum)Extension.json, (Enum)Operation.accessPolicies, (ServletOperation)new GetAccessPolicies());
        this.operations.setOperation(ServletOperationSet.Method.GET, (Enum)Extension.json, (Enum)Operation.allPolicies, (ServletOperation)new GetAllAccessPolicies());
        this.operations.setOperation(ServletOperationSet.Method.GET, (Enum)Extension.html, (Enum)Operation.allPolicies, (ServletOperation)new GetHtmlAccessRules());
        this.operations.setOperation(ServletOperationSet.Method.GET, (Enum)Extension.json, (Enum)Operation.supportedPrivileges, (ServletOperation)new SupportedPrivileges());
        this.operations.setOperation(ServletOperationSet.Method.GET, (Enum)Extension.json, (Enum)Operation.restrictionNames, (ServletOperation)new RestrictionNames());
        this.operations.setOperation(ServletOperationSet.Method.GET, (Enum)Extension.json, (Enum)Operation.principals, (ServletOperation)new GetPrincipals());
        this.operations.setOperation(ServletOperationSet.Method.POST, (Enum)Extension.json, (Enum)Operation.reorder, (ServletOperation)new ReorderOperation());
        this.operations.setOperation(ServletOperationSet.Method.PUT, (Enum)Extension.json, (Enum)Operation.accessPolicy, (ServletOperation)new PutAccessPolicy());
        this.operations.setOperation(ServletOperationSet.Method.DELETE, (Enum)Extension.json, (Enum)Operation.accessPolicy, (ServletOperation)new RemoveAccessPolicy());
    }

    protected boolean sameEntry(JackrabbitAccessControlEntry jrEntry, AccessPolicyEntry entrySendFromClient) throws RepositoryException {
        String p1 = jrEntry.getPrincipal().getName();
        String p2 = entrySendFromClient.principal;
        boolean a1 = jrEntry.isAllow();
        boolean a2 = entrySendFromClient.allow;
        return p1.equals(p2) && a1 == a2 && this.samePrivileges(jrEntry, entrySendFromClient) && this.sameRestrictions(jrEntry, entrySendFromClient);
    }

    protected boolean samePrivileges(JackrabbitAccessControlEntry jrEntry, AccessPolicyEntry entrySendFromClient) {
        if (jrEntry.getPrivileges().length != entrySendFromClient.privileges.length) {
            return false;
        }
        for (Privilege privilegeDefined : jrEntry.getPrivileges()) {
            boolean privilegeFound = false;
            for (String privilegeFromClient : entrySendFromClient.privileges) {
                if (!privilegeDefined.getName().equals(privilegeFromClient)) continue;
                privilegeFound = true;
                break;
            }
            if (privilegeFound) continue;
            return false;
        }
        return true;
    }

    protected boolean sameRestrictions(JackrabbitAccessControlEntry jrEntry, AccessPolicyEntry entrySendFromClient) throws RepositoryException {
        if (jrEntry.getRestrictionNames().length != entrySendFromClient.restrictions.length) {
            return false;
        }
        for (String restrictionName : jrEntry.getRestrictionNames()) {
            String restrictionDefined = restrictionName + "=" + jrEntry.getRestriction(restrictionName).getString();
            boolean restrictionFound = false;
            for (String restrictionFromClient : entrySendFromClient.restrictions) {
                if (!restrictionFromClient.equals(restrictionDefined)) continue;
                restrictionFound = true;
                break;
            }
            if (restrictionFound) continue;
            return false;
        }
        return true;
    }

    protected void bindCoreConfig(NodesConfiguration nodesConfiguration) {
        this.coreConfig = nodesConfiguration;
    }

    protected void unbindCoreConfig(NodesConfiguration nodesConfiguration) {
        if (this.coreConfig == nodesConfiguration) {
            this.coreConfig = null;
        }
    }

    public class GetHtmlAccessRules
    implements ServletOperation {
        public void doIt(SlingHttpServletRequest request, SlingHttpServletResponse response, ResourceHandle resource) throws ServletException, IOException {
            try {
                ResourceResolver resolver = request.getResourceResolver();
                Session session = (Session)resolver.adaptTo(Session.class);
                AccessControlManager acManager = session.getAccessControlManager();
                String path = AbstractServiceServlet.getPath((SlingHttpServletRequest)request);
                PrintWriter writer = response.getWriter();
                writer.append("<tbody>");
                writer.append("<tr class=\"policies info\"><th colspan=\"5\">node policies</th></tr>");
                AccessControlPolicy[] policies = acManager.getPolicies(path);
                this.writePolicies(writer, policies, "policies");
                writer.append("<tr class=\"effective info\"><th colspan=\"5\">effective policies</th></tr>");
                policies = acManager.getEffectivePolicies(path);
                this.writePolicies(writer, policies, "effective");
                writer.append("</tbody>");
            }
            catch (RepositoryException ex) {
                LOG.error(ex.getMessage(), (Throwable)ex);
                response.sendError(400, ex.getMessage());
            }
        }

        protected void writePolicies(PrintWriter writer, AccessControlPolicy[] policies, String rowCss) throws IOException, RepositoryException {
            if (policies.length > 0) {
                for (AccessControlPolicy policy : policies) {
                    this.writePolicy(writer, policy, rowCss);
                }
            } else {
                writer.append("<tr class=\"empty\"><td colspan=\"5\">no rules found</td></tr>");
            }
        }

        protected void writePolicies(PrintWriter writer, AccessControlPolicyIterator policies, String rowCss) throws IOException, RepositoryException {
            if (policies.hasNext()) {
                while (policies.hasNext()) {
                    this.writePolicy(writer, policies.nextAccessControlPolicy(), rowCss);
                }
            } else {
                writer.append("<tr class=\"empty\"><td colspan=\"5\">no rules found</td></tr>");
            }
        }

        protected void writePolicy(PrintWriter writer, AccessControlPolicy policy, String rowCss) throws IOException, RepositoryException {
            if (policy instanceof JackrabbitAccessControlList) {
                JackrabbitAccessControlList acl = (JackrabbitAccessControlList)policy;
                for (AccessControlEntry entry : acl.getAccessControlEntries()) {
                    JackrabbitAccessControlEntry jrEntry = (JackrabbitAccessControlEntry)entry;
                    writer.append("<tr class=\"").append(rowCss).append("\">");
                    writer.append("<td class=\"principal\">").append(entry.getPrincipal().getName()).append("</td>");
                    writer.append("<td class=\"path\">").append(acl.getPath()).append("</td>");
                    writer.append("<td class=\"type ").append(jrEntry.isAllow() ? "allow" : "deny").append("\">").append(jrEntry.isAllow() ? "allow" : "deny").append("</td>");
                    writer.append("<td class=\"privileges\">");
                    this.writePrivileges(writer, entry);
                    writer.append("</td>");
                    writer.append("<td class=\"restrictions\">");
                    this.writeRestrictions(writer, jrEntry);
                    writer.append("</td>");
                }
                writer.append("</tr>");
            } else if (policy instanceof AccessControlList) {
                AccessControlList acl = (AccessControlList)policy;
                for (AccessControlEntry entry : acl.getAccessControlEntries()) {
                    writer.append("<tr class=\"").append(rowCss).append("\">");
                    writer.append("<td class=\"principal\">").append(entry.getPrincipal().getName()).append("</td>");
                    writer.append("<td class=\"path\">").append("").append("</td>");
                    writer.append("<td class=\"type\">").append("</td>");
                    writer.append("<td class=\"privileges\">");
                    this.writePrivileges(writer, entry);
                    writer.append("</td>");
                    writer.append("<td class=\"restrictions\">");
                    writer.append("</td>");
                }
                writer.append("</tr>");
            } else if (policy instanceof NamedAccessControlPolicy) {
                NamedAccessControlPolicy namedPolicy = (NamedAccessControlPolicy)policy;
                writer.append("<tr class=\"named warning\"><td colspan=\"5\">named policy: ").append(namedPolicy.getName()).append("</td></tr>");
            } else {
                writer.append("<tr class=\"unknown warning\"><td colspan=\"5\">uknown policy type: ").append(policy.getClass().getName()).append("</td></tr>");
            }
        }

        protected void writePrivileges(PrintWriter writer, AccessControlEntry entry) throws IOException, RepositoryException {
            Privilege[] privileges = entry.getPrivileges();
            int i = 0;
            while (i < privileges.length) {
                writer.append(privileges[i].getName());
                if (++i >= privileges.length) continue;
                writer.append(", ");
            }
        }

        protected void writeRestrictions(PrintWriter writer, JackrabbitAccessControlEntry entry) throws IOException, RepositoryException {
            String[] restrictionNames = entry.getRestrictionNames();
            int i = 0;
            while (i < restrictionNames.length) {
                writer.append(restrictionNames[i]).append("=").append(entry.getRestriction(restrictionNames[i]).getString());
                if (++i >= restrictionNames.length) continue;
                writer.append(", ");
            }
        }
    }

    public class GetAllAccessPolicies
    extends GetAccessPolicies {
        @Override
        public void doIt(SlingHttpServletRequest request, SlingHttpServletResponse response, ResourceHandle resource) throws ServletException, IOException {
            try {
                ResourceResolver resolver = request.getResourceResolver();
                Session session = (Session)resolver.adaptTo(Session.class);
                AccessControlManager acManager = session.getAccessControlManager();
                String path = AbstractServiceServlet.getPath((SlingHttpServletRequest)request);
                JsonWriter jsonWriter = ResponseUtil.getJsonWriter((SlingHttpServletResponse)response);
                jsonWriter.setIndent("  ");
                jsonWriter.beginObject();
                jsonWriter.name("policies");
                AccessControlPolicy[] policies = acManager.getPolicies(path);
                this.writePolicies(jsonWriter, policies);
                jsonWriter.name("effective");
                policies = acManager.getEffectivePolicies(path);
                this.writePolicies(jsonWriter, policies);
                jsonWriter.name("applicable");
                AccessControlPolicyIterator iterator = acManager.getApplicablePolicies(path);
                this.writePolicies(jsonWriter, iterator);
                jsonWriter.name("privileges");
                Privilege[] privileges = acManager.getPrivileges(path);
                this.writePrivileges(jsonWriter, privileges);
                jsonWriter.name("supported");
                privileges = acManager.getSupportedPrivileges(path);
                this.writePrivileges(jsonWriter, privileges);
                jsonWriter.endObject();
            }
            catch (RepositoryException ex) {
                LOG.error(ex.getMessage(), (Throwable)ex);
                response.sendError(400, ex.getMessage());
            }
        }
    }

    public class GetAccessPolicies
    implements ServletOperation {
        public void doIt(SlingHttpServletRequest request, SlingHttpServletResponse response, ResourceHandle resource) throws ServletException, IOException {
            try {
                AccessControlPolicy[] policies;
                ResourceResolver resolver = request.getResourceResolver();
                Session session = (Session)resolver.adaptTo(Session.class);
                AccessControlManager acManager = session.getAccessControlManager();
                String path = AbstractServiceServlet.getPath((SlingHttpServletRequest)request);
                PolicyScope scope = (PolicyScope)RequestUtil.getParameter((SlingHttpServletRequest)request, (String)SecurityServlet.PARAM_SCOPE, (Enum)RequestUtil.getSelector((SlingHttpServletRequest)request, (Enum)PolicyScope.local));
                switch (scope) {
                    case effective: {
                        policies = acManager.getEffectivePolicies(path);
                        break;
                    }
                    default: {
                        policies = acManager.getPolicies(path);
                    }
                }
                JsonWriter jsonWriter = ResponseUtil.getJsonWriter((SlingHttpServletResponse)response);
                this.writePolicies(jsonWriter, policies);
            }
            catch (RepositoryException ex) {
                LOG.error(ex.getMessage(), (Throwable)ex);
                response.sendError(400, ex.getMessage());
            }
        }

        protected void writePolicies(JsonWriter writer, AccessControlPolicy[] policies) throws IOException, RepositoryException {
            writer.beginArray();
            for (AccessControlPolicy policy : policies) {
                this.writePolicy(writer, policy);
            }
            writer.endArray();
        }

        protected void writePolicies(JsonWriter writer, AccessControlPolicyIterator policies) throws IOException, RepositoryException {
            writer.beginArray();
            while (policies.hasNext()) {
                this.writePolicy(writer, policies.nextAccessControlPolicy());
            }
            writer.endArray();
        }

        protected void writePolicy(JsonWriter writer, AccessControlPolicy policy) throws IOException, RepositoryException {
            if (policy instanceof JackrabbitAccessControlList) {
                JackrabbitAccessControlList acl = (JackrabbitAccessControlList)policy;
                for (AccessControlEntry entry : acl.getAccessControlEntries()) {
                    JackrabbitAccessControlEntry jrEntry = (JackrabbitAccessControlEntry)entry;
                    writer.beginObject();
                    writer.name("principal").value(entry.getPrincipal().getName());
                    writer.name("path").value(acl.getPath());
                    writer.name("allow").value(jrEntry.isAllow());
                    this.writePrivileges(writer, entry);
                    this.writeRestrictions(writer, jrEntry);
                    writer.endObject();
                }
            }
        }

        protected void writePrivileges(JsonWriter writer, AccessControlEntry entry) throws IOException, RepositoryException {
            Privilege[] privileges = entry.getPrivileges();
            writer.name("privileges");
            this.writePrivileges(writer, privileges);
        }

        protected void writePrivileges(JsonWriter writer, Privilege[] privileges) throws IOException, RepositoryException {
            writer.beginArray();
            for (Privilege privilege : privileges) {
                writer.value(privilege.getName());
            }
            writer.endArray();
        }

        protected void writeRestrictions(JsonWriter writer, JackrabbitAccessControlEntry entry) throws IOException, RepositoryException {
            String[] restrictionNames = entry.getRestrictionNames();
            writer.name("restrictions").beginArray();
            for (String name : restrictionNames) {
                writer.value(name + "=" + entry.getRestriction(name).getString());
            }
            writer.endArray();
        }
    }

    public class RemoveAccessPolicy
    implements ServletOperation {
        public void doIt(SlingHttpServletRequest request, SlingHttpServletResponse response, ResourceHandle resource) throws ServletException, IOException {
            try {
                ResourceResolver resolver = request.getResourceResolver();
                Session session = (Session)resolver.adaptTo(Session.class);
                AccessControlManager acManager = session.getAccessControlManager();
                String path = AbstractServiceServlet.getPath((SlingHttpServletRequest)request);
                AccessPolicyEntry[] entries = (AccessPolicyEntry[])AbstractServiceServlet.getJsonObject((SlingHttpServletRequest)request, AccessPolicyEntry[].class);
                JackrabbitAccessControlList policy = AccessControlUtils.getAccessControlList((AccessControlManager)acManager, (String)path);
                for (AccessPolicyEntry entrySendFromClient : entries) {
                    for (AccessControlEntry entry : policy.getAccessControlEntries()) {
                        JackrabbitAccessControlEntry jrEntry = (JackrabbitAccessControlEntry)entry;
                        if (!SecurityServlet.this.sameEntry(jrEntry, entrySendFromClient)) continue;
                        policy.removeAccessControlEntry(entry);
                    }
                }
                acManager.setPolicy(path, (AccessControlPolicy)policy);
                if (policy.isEmpty()) {
                    acManager.removePolicy(path, (AccessControlPolicy)policy);
                }
                session.save();
            }
            catch (RepositoryException ex) {
                LOG.error(ex.getMessage(), (Throwable)ex);
                response.sendError(400, ex.getMessage());
            }
        }
    }

    public class PutAccessPolicy
    implements ServletOperation {
        public void doIt(SlingHttpServletRequest request, SlingHttpServletResponse response, ResourceHandle resource) throws ServletException, IOException {
            try {
                ResourceResolver resolver = request.getResourceResolver();
                JackrabbitSession session = (JackrabbitSession)resolver.adaptTo(Session.class);
                AccessControlManager acManager = session.getAccessControlManager();
                PrincipalManager principalManager = session.getPrincipalManager();
                String path = AbstractServiceServlet.getPath((SlingHttpServletRequest)request);
                AccessPolicyEntry entry = (AccessPolicyEntry)AbstractServiceServlet.getJsonObject((SlingHttpServletRequest)request, AccessPolicyEntry.class);
                JackrabbitAccessControlList policy = AccessControlUtils.getAccessControlList((AccessControlManager)acManager, (String)path);
                Principal principal = principalManager.getPrincipal(entry.principal);
                Privilege[] privileges = AccessControlUtils.privilegesFromNames((AccessControlManager)acManager, (String[])entry.privileges);
                HashMap<String, StringValue> restrictions = new HashMap<String, StringValue>();
                for (String restriction : entry.restrictions) {
                    StringValue v = new StringValue(restriction.substring(restriction.indexOf(61) + 1));
                    restrictions.put(restriction.substring(0, restriction.indexOf(61)), v);
                }
                policy.addEntry(principal, privileges, entry.allow, restrictions);
                acManager.setPolicy(path, (AccessControlPolicy)policy);
                session.save();
            }
            catch (RepositoryException ex) {
                LOG.error(ex.getMessage(), (Throwable)ex);
                response.sendError(400, ex.getMessage());
            }
        }
    }

    public class ReorderOperation
    implements ServletOperation {
        public void doIt(SlingHttpServletRequest request, SlingHttpServletResponse response, ResourceHandle resource) throws IOException, ServletException {
            try {
                ResourceResolver resolver = request.getResourceResolver();
                JackrabbitSession session = (JackrabbitSession)resolver.adaptTo(Session.class);
                AccessControlManager acManager = session.getAccessControlManager();
                String path = AbstractServiceServlet.getPath((SlingHttpServletRequest)request);
                String object = request.getParameter("object");
                String before = request.getParameter("before");
                AccessPolicyEntry entryObject = (AccessPolicyEntry)AbstractServiceServlet.getJsonObject((String)object, AccessPolicyEntry.class);
                AccessPolicyEntry entryBefore = (AccessPolicyEntry)AbstractServiceServlet.getJsonObject((String)before, AccessPolicyEntry.class);
                JackrabbitAccessControlList policy = AccessControlUtils.getAccessControlList((AccessControlManager)acManager, (String)path);
                JackrabbitAccessControlEntry b = null;
                JackrabbitAccessControlEntry o = null;
                for (AccessControlEntry entry : policy.getAccessControlEntries()) {
                    JackrabbitAccessControlEntry jrEntry = (JackrabbitAccessControlEntry)entry;
                    if (SecurityServlet.this.sameEntry(jrEntry, entryBefore)) {
                        b = jrEntry;
                    }
                    if (!SecurityServlet.this.sameEntry(jrEntry, entryObject)) continue;
                    o = jrEntry;
                }
                if (o != null) {
                    policy.orderBefore(o, b);
                    acManager.setPolicy(path, (AccessControlPolicy)policy);
                    session.save();
                }
            }
            catch (RepositoryException ex) {
                LOG.error(ex.getMessage(), (Throwable)ex);
                response.sendError(400, ex.getMessage());
            }
        }
    }

    public class SupportedPrivileges
    implements ServletOperation {
        public void doIt(SlingHttpServletRequest request, SlingHttpServletResponse response, ResourceHandle resource) throws IOException, ServletException {
            try {
                ResourceResolver resolver = request.getResourceResolver();
                JackrabbitSession session = (JackrabbitSession)resolver.adaptTo(Session.class);
                AccessControlManager acManager = session.getAccessControlManager();
                String path = AbstractServiceServlet.getPath((SlingHttpServletRequest)request);
                Privilege[] supportedPrivileges = acManager.getSupportedPrivileges(path);
                ArrayList<String> privilegeNames = new ArrayList<String>(supportedPrivileges.length);
                for (Privilege privilege : supportedPrivileges) {
                    privilegeNames.add(privilege.getName());
                }
                Collections.sort(privilegeNames);
                JsonWriter jsonWriter = ResponseUtil.getJsonWriter((SlingHttpServletResponse)response);
                response.setStatus(200);
                JsonUtil.writeJsonArray((JsonWriter)jsonWriter, privilegeNames.iterator());
            }
            catch (RepositoryException ex) {
                LOG.error(ex.getMessage(), (Throwable)ex);
                response.sendError(400, ex.getMessage());
            }
        }
    }

    public class RestrictionNames
    implements ServletOperation {
        public void doIt(SlingHttpServletRequest request, SlingHttpServletResponse response, ResourceHandle resource) throws IOException, ServletException {
            try {
                ResourceResolver resolver = request.getResourceResolver();
                JackrabbitSession session = (JackrabbitSession)resolver.adaptTo(Session.class);
                AccessControlManager acManager = session.getAccessControlManager();
                String path = AbstractServiceServlet.getPath((SlingHttpServletRequest)request);
                JackrabbitAccessControlList policy = AccessControlUtils.getAccessControlList((AccessControlManager)acManager, (String)path);
                Object[] restrictionNames = policy.getRestrictionNames();
                Arrays.sort(restrictionNames);
                JsonWriter jsonWriter = ResponseUtil.getJsonWriter((SlingHttpServletResponse)response);
                response.setStatus(200);
                JsonUtil.writeJsonArray((JsonWriter)jsonWriter, (String[])restrictionNames);
            }
            catch (RepositoryException ex) {
                LOG.error(ex.getMessage(), (Throwable)ex);
                response.sendError(400, ex.getMessage());
            }
        }
    }

    public class GetPrincipals
    implements ServletOperation {
        public void doIt(SlingHttpServletRequest request, SlingHttpServletResponse response, ResourceHandle resource) throws IOException, ServletException {
            try {
                ResourceResolver resolver = request.getResourceResolver();
                JackrabbitSession session = (JackrabbitSession)resolver.adaptTo(Session.class);
                String path = AbstractServiceServlet.getPath((SlingHttpServletRequest)request);
                final String name = path.startsWith("/") ? path.substring(1) : path;
                Query q = new Query(){

                    public <T> void build(QueryBuilder<T> builder) {
                        builder.setCondition(builder.nameMatches(name + "%"));
                        builder.setSortOrder("@name", QueryBuilder.Direction.ASCENDING);
                        builder.setSelector(Authorizable.class);
                    }
                };
                Iterator principals = session.getUserManager().findAuthorizables(q);
                ArrayList<String> principalNames = new ArrayList<String>();
                while (principals.hasNext()) {
                    Authorizable authorizable = (Authorizable)principals.next();
                    principalNames.add(authorizable.getPrincipal().getName());
                }
                if ("everyone".startsWith(name)) {
                    principalNames.add("everyone");
                }
                Collections.sort(principalNames);
                JsonWriter jsonWriter = ResponseUtil.getJsonWriter((SlingHttpServletResponse)response);
                response.setStatus(200);
                JsonUtil.writeJsonArray((JsonWriter)jsonWriter, principalNames.iterator());
            }
            catch (RepositoryException ex) {
                LOG.error(ex.getMessage(), (Throwable)ex);
                response.sendError(400, ex.getMessage());
            }
        }
    }

    public static class AccessPolicyEntry {
        public String principal;
        public String path;
        public boolean allow;
        public String[] privileges;
        public String[] restrictions;
        public String[] restrictionName;
        public String[] restrictionPattern;
    }

    public static enum Operation {
        accessPolicy,
        accessPolicies,
        allPolicies,
        reorder,
        supportedPrivileges,
        principals,
        restrictionNames;

    }

    public static enum Extension {
        json,
        html;

    }

    public static enum PolicyScope {
        local,
        effective;

    }
}

