/*
 * Decompiled with CFR 0.152.
 */
package com.composum.sling.nodes.servlet;

import com.composum.sling.core.ResourceHandle;
import com.composum.sling.core.filter.StringFilter;
import com.composum.sling.core.mapping.MappingRules;
import com.composum.sling.core.servlet.AbstractServiceServlet;
import com.composum.sling.core.servlet.ServletOperation;
import com.composum.sling.core.servlet.ServletOperationSet;
import com.composum.sling.core.util.JsonUtil;
import com.composum.sling.core.util.MimeTypeUtil;
import com.composum.sling.core.util.PropertyUtil;
import com.composum.sling.core.util.RequestUtil;
import com.composum.sling.core.util.ResponseUtil;
import com.composum.sling.nodes.NodesConfiguration;
import com.google.gson.stream.JsonWriter;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import javax.jcr.Binary;
import javax.jcr.Node;
import javax.jcr.PathNotFoundException;
import javax.jcr.Property;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.Value;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import javax.servlet.ServletInputStream;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.sling.SlingServlet;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.api.request.RequestParameter;
import org.apache.sling.api.request.RequestParameterMap;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceUtil;
import org.apache.sling.api.resource.ValueMap;
import org.apache.tika.mime.MimeType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@SlingServlet(paths={"/bin/cpm/nodes/property"}, methods={"GET", "POST", "PUT"})
public class PropertyServlet
extends AbstractServiceServlet {
    private static final Logger LOG = LoggerFactory.getLogger(PropertyServlet.class);
    public static final StringFilter DEFAULT_PROPS_FILTER = new StringFilter.BlackList(new String[0]);
    public static final StringFilter BINARY_PROPS_FILTER = new StringFilter.BlackList(new String[0]);
    @Reference
    private NodesConfiguration coreConfig;
    protected ServletOperationSet<Extension, Operation> operations = new ServletOperationSet((Enum)Extension.json);

    protected ServletOperationSet getOperations() {
        return this.operations;
    }

    protected boolean isEnabled() {
        return this.coreConfig.isEnabled((Servlet)this);
    }

    public void init() throws ServletException {
        super.init();
        this.operations.setOperation(ServletOperationSet.Method.GET, (Enum)Extension.json, (Enum)Operation.get, (ServletOperation)new GetOperation());
        this.operations.setOperation(ServletOperationSet.Method.GET, (Enum)Extension.json, (Enum)Operation.map, (ServletOperation)new MapGetOperation());
        this.operations.setOperation(ServletOperationSet.Method.GET, (Enum)Extension.bin, (Enum)Operation.get, (ServletOperation)new GetBinaryOperation());
        this.operations.setOperation(ServletOperationSet.Method.POST, (Enum)Extension.bin, (Enum)Operation.put, (ServletOperation)new PostBinaryOperation());
        this.operations.setOperation(ServletOperationSet.Method.PUT, (Enum)Extension.json, (Enum)Operation.put, (ServletOperation)new PutOperation());
        this.operations.setOperation(ServletOperationSet.Method.PUT, (Enum)Extension.json, (Enum)Operation.copy, (ServletOperation)new CopyOperation());
        this.operations.setOperation(ServletOperationSet.Method.PUT, (Enum)Extension.bin, (Enum)Operation.put, (ServletOperation)new PutBinaryOperation());
        this.operations.setOperation(ServletOperationSet.Method.PUT, (Enum)Extension.bin, (Enum)Operation.update, (ServletOperation)new PutUpdateOperation());
        this.operations.setOperation(ServletOperationSet.Method.DELETE, (Enum)Extension.json, (Enum)Operation.remove, (ServletOperation)new RemoveOperation());
    }

    protected void bindCoreConfig(NodesConfiguration nodesConfiguration) {
        this.coreConfig = nodesConfiguration;
    }

    protected void unbindCoreConfig(NodesConfiguration nodesConfiguration) {
        if (this.coreConfig == nodesConfiguration) {
            this.coreConfig = null;
        }
    }

    protected class PutUpdateOperation
    extends PutBinaryOperation {
        protected PutUpdateOperation() {
        }

        @Override
        protected void postChange(Node node) throws RepositoryException {
            Calendar lastModified = PropertyUtil.getProperty((Node)node, (String)"jcr:lastModified", (Calendar)null);
            if (lastModified != null) {
                Session session = node.getSession();
                String userId = session.getUserID();
                GregorianCalendar now = new GregorianCalendar();
                now.setTime(new Date());
                PropertyUtil.setProperty((Node)node, (String)"jcr:lastModified", (Object)now, (int)5);
                if (StringUtils.isNotBlank((CharSequence)userId)) {
                    PropertyUtil.setProperty((Node)node, (String)"jcr:lastModifiedBy", (Object)userId, (int)1);
                }
            }
        }
    }

    protected class PutBinaryOperation
    implements ServletOperation {
        protected PutBinaryOperation() {
        }

        public void doIt(SlingHttpServletRequest request, SlingHttpServletResponse response, ResourceHandle resource) throws ServletException, IOException {
            if (!resource.isValid()) {
                response.setStatus(404);
                return;
            }
            try {
                Node node = (Node)resource.adaptTo(Node.class);
                if (node != null) {
                    Session session = node.getSession();
                    ServletInputStream input = request.getInputStream();
                    PropertyUtil.setProperty((Node)node, (String)"jcr:data", (InputStream)input);
                    this.postChange(node);
                    session.save();
                    response.setContentLength(0);
                    response.setStatus(200);
                } else {
                    response.sendError(400, "can't determine file node '" + resource.getPath() + "'");
                }
            }
            catch (RepositoryException ex) {
                LOG.error(ex.getMessage(), (Throwable)ex);
                response.sendError(400, ex.getMessage());
            }
        }

        protected void postChange(Node node) throws RepositoryException {
        }
    }

    protected class PostBinaryOperation
    implements ServletOperation {
        protected PostBinaryOperation() {
        }

        public void doIt(SlingHttpServletRequest request, SlingHttpServletResponse response, ResourceHandle resource) throws ServletException, IOException {
            if (!resource.isValid()) {
                response.setStatus(404);
                return;
            }
            try {
                Node node = (Node)resource.adaptTo(Node.class);
                if (node != null) {
                    RequestParameterMap parameters = request.getRequestParameterMap();
                    RequestParameter file = parameters.getValue("value");
                    if (file != null) {
                        RequestParameter nameParam = parameters.getValue("name");
                        String name = nameParam != null ? nameParam.getString() : "jcr:data";
                        LOG.info(resource.getPath() + ": update POST for binary property '" + name + "'");
                        Session session = node.getSession();
                        InputStream input = file.getInputStream();
                        PropertyUtil.setProperty((Node)node, (String)name, (InputStream)input);
                        session.save();
                        response.setContentLength(0);
                        response.setStatus(200);
                    } else {
                        LOG.error(resource.getPath() + ": invalid file update POST - no file/binary content");
                        response.sendError(400, "no binary/file content");
                    }
                } else {
                    LOG.error(resource.getPath() + ": invalid file update POST - resource has no content node");
                    response.sendError(400, "can't determine file node '" + resource.getPath() + "'");
                }
            }
            catch (RepositoryException ex) {
                LOG.error(ex.getMessage(), (Throwable)ex);
                response.sendError(400, ex.getMessage());
            }
        }
    }

    protected class GetBinaryOperation
    implements ServletOperation {
        protected GetBinaryOperation() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void doIt(SlingHttpServletRequest request, SlingHttpServletResponse response, ResourceHandle resource) throws ServletException, IOException {
            block14: {
                if (!resource.isValid()) {
                    response.setStatus(404);
                    return;
                }
                try {
                    Node node = (Node)resource.adaptTo(Node.class);
                    if (node != null) {
                        Binary binary;
                        String name = RequestUtil.getParameter((SlingHttpServletRequest)request, (String)"name", (String)"jcr:data");
                        Property property = node.getProperty(name);
                        Binary binary2 = binary = property != null ? property.getBinary() : null;
                        if (binary != null) {
                            try {
                                Calendar lastModified;
                                String filename;
                                MimeType mimeType = MimeTypeUtil.getMimeType((Resource)resource);
                                if (mimeType != null) {
                                    response.setContentType(mimeType.toString());
                                }
                                if (StringUtils.isNotBlank((CharSequence)(filename = MimeTypeUtil.getFilename((Resource)resource, null)))) {
                                    response.setHeader("Content-Disposition", "inline; filename=" + filename);
                                }
                                if ((lastModified = (Calendar)resource.getProperty("jcr:lastModified", Calendar.class)) != null) {
                                    response.setDateHeader("Last-Modified", lastModified.getTimeInMillis());
                                }
                                response.setContentLength((int)binary.getSize());
                                response.setStatus(200);
                                InputStream input = binary.getStream();
                                BufferedInputStream buffered = new BufferedInputStream(input);
                                try {
                                    IOUtils.copy((InputStream)buffered, (OutputStream)response.getOutputStream());
                                    break block14;
                                }
                                finally {
                                    buffered.close();
                                    input.close();
                                }
                            }
                            finally {
                                binary.dispose();
                            }
                        }
                        response.sendError(404, "no binary '" + name + "' property found");
                        break block14;
                    }
                    LOG.error(resource.getPath() + ": invalid binary GET - resource has no content node");
                    response.sendError(400, "can't determine file node '" + resource.getPath() + "'");
                }
                catch (RepositoryException ex) {
                    LOG.error(ex.getMessage(), (Throwable)ex);
                    response.sendError(400, ex.getMessage());
                }
            }
        }
    }

    protected class CopyOperation
    extends BulkOperation {
        protected CopyOperation() {
        }

        @Override
        public void doIt(SlingHttpServletRequest request, SlingHttpServletResponse response, ResourceHandle resource, Node node, BulkParameters parameters, JsonWriter writer) throws RepositoryException, ServletException, IOException {
            if (parameters.path != null) {
                Session session = node.getSession();
                writer.beginObject();
                Node template = session.getNode(parameters.path);
                if (template != null && parameters.names != null) {
                    writer.name("copied").beginArray();
                    for (String name : parameters.names) {
                        try {
                            Property property = template.getProperty(name);
                            if (property == null) continue;
                            this.clearProperty(node, name);
                            if (property.isMultiple()) {
                                node.setProperty(name, property.getValues());
                            } else {
                                node.setProperty(name, property.getValue());
                            }
                            writer.value(name);
                        }
                        catch (PathNotFoundException pathNotFoundException) {}
                    }
                    writer.endArray();
                }
                writer.endObject();
                session.save();
            }
        }
    }

    protected class RemoveOperation
    extends BulkOperation {
        protected RemoveOperation() {
        }

        @Override
        public void doIt(SlingHttpServletRequest request, SlingHttpServletResponse response, ResourceHandle resource, Node node, BulkParameters parameters, JsonWriter writer) throws RepositoryException, ServletException, IOException {
            Session session = node.getSession();
            writer.beginObject();
            if (parameters.names != null) {
                writer.name("removed").beginArray();
                for (String name : parameters.names) {
                    this.clearProperty(node, name);
                    writer.value(name);
                }
                writer.endArray();
            }
            writer.endObject();
            session.save();
        }

        protected class Result {
            public List<String> names;

            protected Result() {
            }
        }
    }

    protected abstract class BulkOperation
    implements ServletOperation {
        protected BulkOperation() {
        }

        public void doIt(SlingHttpServletRequest request, SlingHttpServletResponse response, ResourceHandle resource) throws ServletException, IOException {
            if (!resource.isValid()) {
                response.setStatus(404);
                return;
            }
            Node node = (Node)resource.adaptTo(Node.class);
            if (node != null) {
                try {
                    BulkParameters parameters = (BulkParameters)AbstractServiceServlet.getJsonObject((SlingHttpServletRequest)request, BulkParameters.class);
                    response.setStatus(200);
                    JsonWriter writer = ResponseUtil.getJsonWriter((SlingHttpServletResponse)response);
                    if (parameters != null) {
                        this.doIt(request, response, resource, node, parameters, writer);
                    }
                }
                catch (RepositoryException ex) {
                    LOG.error(ex.getMessage(), (Throwable)ex);
                    response.sendError(400, ex.getMessage());
                }
            } else {
                response.sendError(400, "can't determine node '" + resource.getPath() + "'");
            }
        }

        protected abstract void doIt(SlingHttpServletRequest var1, SlingHttpServletResponse var2, ResourceHandle var3, Node var4, BulkParameters var5, JsonWriter var6) throws RepositoryException, ServletException, IOException;

        protected void clearProperty(Node node, String name) throws RepositoryException {
            try {
                Property property = node.getProperty(name);
                if (property != null) {
                    if (property.isMultiple()) {
                        node.setProperty(name, (Value[])null);
                    } else {
                        node.setProperty(name, (Value)null);
                    }
                }
            }
            catch (PathNotFoundException pathNotFoundException) {
                // empty catch block
            }
        }

        protected class Result {
            public Object result;

            protected Result() {
            }
        }
    }

    protected static class BulkParameters {
        public String path;
        public List<String> names;

        protected BulkParameters() {
        }
    }

    protected class PutOperation
    implements ServletOperation {
        protected PutOperation() {
        }

        public void doIt(SlingHttpServletRequest request, SlingHttpServletResponse response, ResourceHandle resource) throws ServletException, IOException {
            if (!resource.isValid()) {
                response.setStatus(404);
                return;
            }
            try {
                Node node = (Node)resource.adaptTo(Node.class);
                if (node != null) {
                    Session session = node.getSession();
                    JsonUtil.JsonProperty property = (JsonUtil.JsonProperty)AbstractServiceServlet.getJsonObject((SlingHttpServletRequest)request, JsonUtil.JsonProperty.class);
                    boolean available = JsonUtil.setJsonProperty((Node)node, (JsonUtil.JsonProperty)property, (MappingRules)ResponseUtil.getDefaultJsonMapping());
                    session.save();
                    response.setStatus(200);
                    if (available) {
                        response.setContentType(ResponseUtil.JSON_CONTENT_TYPE);
                        ResponseUtil.writeJsonProperty((SlingHttpServletResponse)response, (Node)node, (String)property.name);
                    } else {
                        response.setContentLength(0);
                    }
                } else {
                    response.sendError(400, "can't determine node '" + resource.getPath() + "'");
                }
            }
            catch (RepositoryException ex) {
                LOG.error(ex.getMessage(), (Throwable)ex);
                response.sendError(400, ex.getMessage());
            }
        }
    }

    protected class GetOperation
    implements ServletOperation {
        protected GetOperation() {
        }

        public void doIt(SlingHttpServletRequest request, SlingHttpServletResponse response, ResourceHandle resource) throws ServletException, IOException {
            if (!resource.isValid()) {
                response.setStatus(404);
                return;
            }
            try {
                Node node = (Node)resource.adaptTo(Node.class);
                String name = request.getParameter("name");
                if (StringUtils.isNotBlank((CharSequence)name)) {
                    response.setStatus(200);
                    ResponseUtil.writeJsonProperty((SlingHttpServletResponse)response, (Node)node, (String)name);
                } else {
                    response.sendError(400, "no property name parameter found");
                }
            }
            catch (RepositoryException ex) {
                LOG.error(ex.getMessage(), (Throwable)ex);
                response.sendError(400, ex.getMessage());
            }
        }
    }

    protected class MapGetOperation
    implements ServletOperation {
        protected MapGetOperation() {
        }

        public void doIt(SlingHttpServletRequest request, SlingHttpServletResponse response, ResourceHandle resource) throws ServletException, IOException {
            if (!resource.isValid()) {
                response.setStatus(404);
                return;
            }
            StringFilter filter = resource.isFile() ? BINARY_PROPS_FILTER : DEFAULT_PROPS_FILTER;
            try {
                MappingRules mapping = new MappingRules(MappingRules.getDefaultMappingRules(), null, null, null, new MappingRules.PropertyFormat((MappingRules.PropertyFormat.Scope)RequestUtil.getParameter((SlingHttpServletRequest)request, (String)"format", (Enum)RequestUtil.getSelector((SlingHttpServletRequest)request, (Enum)MappingRules.PropertyFormat.Scope.definition)), (MappingRules.PropertyFormat.Binary)RequestUtil.getParameter((SlingHttpServletRequest)request, (String)"binary", (Enum)RequestUtil.getSelector((SlingHttpServletRequest)request, (Enum)MappingRules.PropertyFormat.Binary.link))), null, null);
                JsonWriter jsonWriter = ResponseUtil.getJsonWriter((SlingHttpServletResponse)response);
                response.setStatus(200);
                Node node = (Node)resource.adaptTo(Node.class);
                if (node != null) {
                    JsonUtil.writeJsonProperties((JsonWriter)jsonWriter, (StringFilter)filter, (Node)node, (MappingRules)mapping);
                } else {
                    ValueMap values = ResourceUtil.getValueMap((Resource)resource);
                    JsonUtil.writeJsonValueMap((JsonWriter)jsonWriter, (StringFilter)filter, (ValueMap)values, (MappingRules)mapping);
                }
            }
            catch (RepositoryException ex) {
                LOG.error(ex.getMessage(), (Throwable)ex);
                response.sendError(400, ex.getMessage());
            }
        }
    }

    public static enum Operation {
        get,
        put,
        update,
        map,
        copy,
        remove;

    }

    public static enum Extension {
        json,
        bin;

    }
}

