/*
 * Decompiled with CFR 0.152.
 */
package com.composum.sling.nodes.servlet;

import com.composum.sling.core.exception.ParameterValidationException;
import com.composum.sling.core.servlet.NodeTreeServlet;
import com.composum.sling.core.util.MimeTypeUtil;
import com.composum.sling.core.util.PropertyUtil;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.jcr.Node;
import javax.jcr.Property;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.request.RequestParameter;
import org.apache.sling.api.request.RequestParameterMap;

public class NodeFactory {
    public static final NodeFactory SINGLETON = new NodeFactory();
    protected TypeStrategy defaultStrategy;
    protected Map<String, TypeStrategy> strategyMap = new HashMap<String, TypeStrategy>();

    public NodeFactory() {
        this.strategyMap.put("oak:QueryIndexDefinition", new OakIndexStrategy());
        this.strategyMap.put("nt:file", new NtFileStrategy());
        this.strategyMap.put("nt:linkedFile", new NtLinkedFileStrategy());
        this.strategyMap.put("nt:resource", new NtResourceStrategy());
        this.defaultStrategy = new DefaultStrategy();
    }

    public Node createNode(SlingHttpServletRequest request, Node parentNode, String name, NodeTreeServlet.NodeParameters parameters) throws RepositoryException, IOException, ParameterValidationException {
        TypeStrategy strategy = this.strategyMap.get(parameters.type);
        if (strategy == null) {
            strategy = this.defaultStrategy;
        }
        Node node = strategy.createNode(request, parentNode, name, parameters);
        return node;
    }

    public static void setMimeTypeByData(String name, Node node, Property property) throws RepositoryException {
        String mimeType;
        if (property != null && StringUtils.isNotBlank((CharSequence)(mimeType = MimeTypeUtil.getMimeType((String)name, (Property)property, null)))) {
            node.setProperty("jcr:mimeType", mimeType);
        }
    }

    public static class NtResourceStrategy
    implements TypeStrategy {
        @Override
        public Node createNode(SlingHttpServletRequest request, Node parentNode, String name, NodeTreeServlet.NodeParameters params) throws RepositoryException, IOException, ParameterValidationException {
            Node node = parentNode.addNode(name, params.type);
            if (StringUtils.isNotBlank((CharSequence)params.mimeType)) {
                node.setProperty("jcr:mimeType", params.mimeType);
            }
            RequestParameterMap parameters = request.getRequestParameterMap();
            Property property = null;
            RequestParameter file = parameters.getValue("file");
            if (file != null) {
                InputStream input = file.getInputStream();
                property = PropertyUtil.setProperty((Node)node, (String)"jcr:data", (InputStream)input);
            }
            if (StringUtils.isBlank((CharSequence)params.mimeType)) {
                NodeFactory.setMimeTypeByData(name, node, property);
            }
            return node;
        }
    }

    public static class NtLinkedFileStrategy
    implements TypeStrategy {
        @Override
        public Node createNode(SlingHttpServletRequest request, Node parentNode, String name, NodeTreeServlet.NodeParameters params) throws RepositoryException, IOException, ParameterValidationException {
            Session session;
            Node linkTarget;
            Node node = null;
            if (StringUtils.isNotBlank((CharSequence)params.jcrContent) && (linkTarget = (session = parentNode.getSession()).getNode(params.jcrContent)) != null && linkTarget.isNodeType("mix:referenceable")) {
                String identifier = linkTarget.getIdentifier();
                node = parentNode.addNode(name, params.type);
                node.setProperty("jcr:content", identifier, 9);
            }
            if (node == null) {
                throw new ParameterValidationException("invalid link target '" + params.jcrContent + "'");
            }
            return node;
        }
    }

    public static class NtFileStrategy
    implements TypeStrategy {
        @Override
        public Node createNode(SlingHttpServletRequest request, Node parentNode, String name, NodeTreeServlet.NodeParameters params) throws RepositoryException, IOException, ParameterValidationException {
            Node node = parentNode.addNode(name, params.type);
            Node contentNode = node.addNode("jcr:content", "nt:resource");
            if (StringUtils.isNotBlank((CharSequence)params.mimeType)) {
                contentNode.setProperty("jcr:mimeType", params.mimeType);
            }
            RequestParameterMap parameters = request.getRequestParameterMap();
            Property property = null;
            RequestParameter file = parameters.getValue("file");
            if (file != null) {
                InputStream input = file.getInputStream();
                property = PropertyUtil.setProperty((Node)contentNode, (String)"jcr:data", (InputStream)input);
            }
            if (StringUtils.isBlank((CharSequence)params.mimeType)) {
                NodeFactory.setMimeTypeByData(name, contentNode, property);
            }
            return node;
        }
    }

    public static class OakIndexStrategy
    implements TypeStrategy {
        @Override
        public Node createNode(SlingHttpServletRequest request, Node parentNode, String name, NodeTreeServlet.NodeParameters params) throws RepositoryException, IOException, ParameterValidationException {
            Node node = parentNode.addNode(name, params.type);
            RequestParameterMap parameters = request.getRequestParameterMap();
            Property property = null;
            RequestParameter idxType = parameters.getValue("indexType");
            if (idxType != null) {
                property = PropertyUtil.setProperty((Node)node, (String)"type", (Object)idxType.getString(), (int)1);
                property = PropertyUtil.setProperty((Node)node, (String)"propertyNames", new ArrayList(), (int)7);
            }
            return node;
        }
    }

    public static class DefaultStrategy
    implements TypeStrategy {
        @Override
        public Node createNode(SlingHttpServletRequest request, Node parentNode, String name, NodeTreeServlet.NodeParameters parameters) throws RepositoryException, ParameterValidationException {
            Node node = parentNode.addNode(name, parameters.type);
            if (StringUtils.isNotBlank((CharSequence)parameters.title)) {
                node.setProperty("jcr:title", parameters.title);
            }
            if (StringUtils.isNotBlank((CharSequence)parameters.resourceType)) {
                node.setProperty("sling:resourceType", parameters.resourceType);
            }
            return node;
        }
    }

    public static interface TypeStrategy {
        public Node createNode(SlingHttpServletRequest var1, Node var2, String var3, NodeTreeServlet.NodeParameters var4) throws RepositoryException, IOException, ParameterValidationException;
    }
}

