/*
 * Decompiled with CFR 0.152.
 */
package com.composum.sling.nodes.query;

import com.composum.sling.core.BeanContext;
import com.composum.sling.core.ResourceHandle;
import com.composum.sling.nodes.console.ConsoleSlingBean;
import com.composum.sling.nodes.query.Template;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Templates
extends ConsoleSlingBean {
    private static final Logger LOG = LoggerFactory.getLogger(Templates.class);
    public static final String DEFAULT_GROUP = "general";
    public static final String TEMPLATE_RESOURCE_TYPE = "composum/nodes/console/query/template";
    public static final String TEMPLATES_RESOURCE_TYPE = "composum/nodes/console/query/templates";
    public static final String CONTENT_QUERY_BASE = "/jcr:root";
    public static final String CONTENT_QUERY_RULE = "/*[@sling:resourceType='composum/nodes/console/query/templates']";
    private transient Map<String, List<Template>> templates;

    public Templates(BeanContext context, Resource resource) {
        super(context, resource);
    }

    public Templates(BeanContext context) {
        super(context);
    }

    public Templates() {
    }

    public Set<Map.Entry<String, List<Template>>> getGroups() {
        return this.getTemplates().entrySet();
    }

    public Map<String, List<Template>> getTemplates() {
        if (this.templates == null) {
            this.templates = new TreeMap<String, List<Template>>();
            ResourceResolver resolver = this.getResolver();
            for (String path : resolver.getSearchPath()) {
                this.findTemplates(this.templates, CONTENT_QUERY_BASE + path + CONTENT_QUERY_RULE);
            }
            for (List list : this.templates.values()) {
                Collections.sort(list);
            }
        }
        return this.templates;
    }

    protected void findTemplates(Map<String, List<Template>> consoles, String query) {
        ResourceResolver resolver = this.getResolver();
        Iterator templateResources = resolver.findResources(query, "xpath");
        if (templateResources != null) {
            while (templateResources.hasNext()) {
                Resource templateContent = (Resource)templateResources.next();
                for (Resource template : templateContent.getChildren()) {
                    if (!template.isResourceType(TEMPLATE_RESOURCE_TYPE)) continue;
                    ResourceHandle handle = ResourceHandle.use((Resource)template);
                    String groupName = (String)handle.getProperty("group", (Object)DEFAULT_GROUP);
                    List<Template> group = this.templates.get(groupName);
                    if (group == null) {
                        group = new ArrayList<Template>();
                        this.templates.put(groupName, group);
                    }
                    group.add(new Template(this.context, (Resource)handle));
                }
            }
        }
    }
}

