/*
 * Decompiled with CFR 0.152.
 */
package com.composum.sling.nodes.console;

import com.composum.sling.core.BeanContext;
import com.composum.sling.core.ResourceHandle;
import com.composum.sling.core.filter.ResourceFilter;
import com.composum.sling.core.util.LinkUtil;
import com.composum.sling.nodes.NodesConfiguration;
import com.composum.sling.nodes.console.ConsolePage;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.jcr.Session;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ValueMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Consoles
extends ConsolePage {
    private static final Logger LOG = LoggerFactory.getLogger(Consoles.class);
    public static final String CATEGORIES = "categories";
    public static final String ORDER = "order";
    public static final int ORDER_DEFAULT = 50;
    public static final String PROP_TARGET = "target";
    public static final String PROP_PRECONDITION = "precondition";
    public static final String PRECONDITION_CLASS_AVAILABILITY = "class";
    public static final Map<String, PreconditionFilter> PRECONDITION_FILTERS = new HashMap<String, PreconditionFilter>();
    public static final String CONTENT_QUERY_BASE = "/jcr:root";
    public static final String CONTENT_QUERY_RULE = "/content[@sling:resourceType='composum/nodes/console/page']";
    private transient List<Console> consoles;

    public Consoles(BeanContext context, Resource resource) {
        super(context, resource);
    }

    public Consoles(BeanContext context) {
        super(context);
    }

    public Consoles() {
    }

    public String getCurrentUser() {
        Session session = this.getSession();
        return session.getUserID();
    }

    public String getWorkspaceName() {
        return this.getSession().getWorkspace().getName();
    }

    public List<Console> getConsoles() {
        if (this.consoles == null) {
            this.consoles = new ArrayList<Console>();
            ResourceResolver resolver = this.getResolver();
            for (String path : resolver.getSearchPath()) {
                this.findConsoles(this.consoles, CONTENT_QUERY_BASE + path + CONTENT_QUERY_RULE);
            }
            Collections.sort(this.consoles);
        }
        return this.consoles;
    }

    protected void findConsoles(List<Console> consoles, String query) {
        ResourceResolver resolver = this.getResolver();
        Iterator consoleContentResources = resolver.findResources(query, "xpath");
        if (consoleContentResources != null) {
            NodesConfiguration configuration = (NodesConfiguration)this.getSling().getService(NodesConfiguration.class);
            String[] categories = configuration.getConsoleCategories();
            ConsoleFilter consoleFilter = new ConsoleFilter(categories);
            while (consoleContentResources.hasNext()) {
                Resource consoleContent = (Resource)consoleContentResources.next();
                for (Resource console : consoleContent.getChildren()) {
                    if (!consoleFilter.accept(console)) continue;
                    consoles.add(new Console(ResourceHandle.use((Resource)console)));
                }
            }
        }
    }

    static {
        PRECONDITION_FILTERS.put(PRECONDITION_CLASS_AVAILABILITY, new ClassAvailabilityFilter());
    }

    public static class ClassAvailabilityFilter
    implements PreconditionFilter {
        @Override
        public boolean accept(BeanContext context, Resource resource, String className) {
            boolean classAvailable = false;
            try {
                context.getType(className);
                classAvailable = true;
            }
            catch (Exception ex) {
                LOG.warn("precondition check failed: " + ex.getMessage());
            }
            return classAvailable;
        }
    }

    public static interface PreconditionFilter {
        public boolean accept(BeanContext var1, Resource var2, String var3);
    }

    public class Console
    implements Comparable<Console> {
        private final ResourceHandle handle;
        private final int order;

        public Console(ResourceHandle handle) {
            this.handle = handle;
            this.order = (Integer)handle.getProperty(Consoles.ORDER, (Object)50);
        }

        public String getLabel() {
            return this.handle.getTitle();
        }

        public String getName() {
            return this.handle.getName();
        }

        public String getPath() {
            return this.handle.getPath();
        }

        public String getUrl() {
            String suffix = Consoles.this.getRequest().getRequestPathInfo().getSuffix();
            return LinkUtil.getUnmappedUrl((SlingHttpServletRequest)Consoles.this.getRequest(), (String)this.getPath()).replaceAll("\\$\\{path}", StringUtils.isNotBlank((CharSequence)suffix) ? suffix : "");
        }

        public String getLinkAttributes() {
            StringBuilder builder = new StringBuilder();
            String value = (String)this.handle.getProperty(Consoles.PROP_TARGET, (Object)"");
            if (StringUtils.isNotBlank((CharSequence)value)) {
                builder.append(" target=\"").append(value).append("\"");
            }
            return builder.toString();
        }

        @Override
        public int compareTo(Console other) {
            return this.order - other.order;
        }
    }

    public class ConsoleFilter
    implements ResourceFilter {
        private final List<String> selectors;

        public ConsoleFilter(String ... selectors) {
            this.selectors = Arrays.asList(selectors);
        }

        public boolean accept(Resource resource) {
            String[] categories;
            ValueMap values = (ValueMap)resource.adaptTo(ValueMap.class);
            for (String category : categories = (String[])values.get(Consoles.CATEGORIES, (Object)new String[0])) {
                String[] rule;
                PreconditionFilter filter;
                if (!this.selectors.contains(category)) continue;
                String precondition = (String)values.get(Consoles.PROP_PRECONDITION, (Object)"");
                if (StringUtils.isNotBlank((CharSequence)precondition) && (filter = PRECONDITION_FILTERS.get((rule = StringUtils.split((String)precondition, (String)":"))[0])) != null) {
                    return filter.accept(Consoles.this.context, resource, rule.length > 1 ? rule[1] : null);
                }
                return true;
            }
            return false;
        }

        public boolean isRestriction() {
            return true;
        }

        public void toString(StringBuilder builder) {
            builder.append("console(").append(StringUtils.join(this.selectors, (char)',')).append(")");
        }
    }
}

