/*
 * Decompiled with CFR 0.152.
 */
package com.composum.sling.nodes.browser;

import com.composum.sling.core.BeanContext;
import com.composum.sling.core.ResourceHandle;
import com.composum.sling.core.filter.StringFilter;
import com.composum.sling.core.util.LinkUtil;
import com.composum.sling.core.util.MimeTypeUtil;
import com.composum.sling.core.util.ResourceUtil;
import com.composum.sling.nodes.console.ConsoleServletBean;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.jcr.Binary;
import javax.jcr.Node;
import javax.jcr.Property;
import javax.jcr.RepositoryException;
import javax.jcr.nodetype.NodeType;
import org.apache.commons.lang3.StringEscapeUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.resource.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Browser
extends ConsoleServletBean {
    private static final Logger LOG = LoggerFactory.getLogger(Browser.class);
    public static final String TYPE_FILE = "nt:file";
    public static final String TYPE_RESOURCE = "nt:resource";
    public static final String TYPE_UNSTRUCTURED = "nt:unstructured";
    public static final String HTML = "html";
    public static final String JSP = "jsp";
    public static final String PROP_DATA = "jcr:data";
    public static final String PROP_MIME_TYPE = "jcr:mimeType";
    public static final String DEFAULT_MIME_TYPE = "text/html";
    public static final Map<String, String> EDITOR_MODES = new HashMap<String, String>();
    private transient String primaryType;
    private transient String resourceType;
    private transient String mimeType;
    private transient String nameExtension;
    private transient String viewType;
    private transient String textType;
    private transient Boolean isFile;
    private transient Boolean isAsset;
    private transient Boolean isImage;
    private transient Boolean isVideo;
    private transient Boolean isText;
    private transient Boolean isRenderable;
    private transient NodeHandle current;
    private transient NodeHandle parent;
    private transient List<NodeHandle> parents;

    public Browser(BeanContext context, Resource resource) {
        super(context, resource);
    }

    public Browser(BeanContext context) {
        super(context);
    }

    public Browser() {
    }

    public String getPrimaryType() {
        if (this.primaryType == null) {
            this.primaryType = "";
            try {
                NodeType type;
                Node node = (Node)this.resource.adaptTo(Node.class);
                this.primaryType = node != null ? ((type = node.getPrimaryNodeType()) != null ? type.getName() : "{untyped}") : "{no node}";
            }
            catch (RepositoryException ex) {
                this.primaryType = String.format("{%s}", ex.getMessage());
                LOG.error(ex.getMessage(), (Throwable)ex);
            }
        }
        return this.primaryType;
    }

    public String getResourceType() {
        if (this.resourceType == null) {
            ResourceHandle handle;
            ResourceHandle contentResource;
            this.resourceType = "";
            String type = this.resource.getResourceType();
            if ((StringUtils.isBlank((CharSequence)type) || this.getPrimaryType().equals(type)) && (contentResource = this.getContentResource()) != null && StringUtils.isNotBlank((CharSequence)(type = contentResource.getResourceType())) && (handle = ResourceHandle.use((Resource)contentResource)).getPrimaryType().equals(type)) {
                type = null;
            }
            if (StringUtils.isNotBlank((CharSequence)type) && !"sling:nonexisting".equals(type)) {
                this.resourceType = type;
            }
        }
        return this.resourceType;
    }

    public boolean isTyped() {
        return StringUtils.isNotBlank((CharSequence)this.getResourceType());
    }

    public boolean isFile() {
        if (this.isFile == null) {
            this.isFile = false;
            ResourceHandle contentResource = this.getContentResource();
            if (contentResource == null) {
                contentResource = this.resource;
            }
            if (contentResource != null) {
                try {
                    NodeType type;
                    String typeName;
                    Node node = (Node)contentResource.adaptTo(Node.class);
                    if (node != null && (TYPE_RESOURCE.equals(typeName = (type = node.getPrimaryNodeType()).getName()) || TYPE_FILE.equals(typeName) || TYPE_UNSTRUCTURED.equals(typeName))) {
                        if (this.getData() != null) {
                            this.isFile = true;
                        } else {
                            this.mimeType = contentResource.getProperty(PROP_MIME_TYPE);
                            if (StringUtils.isNotBlank((CharSequence)this.mimeType)) {
                                this.isFile = true;
                            }
                        }
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        return this.isFile;
    }

    public boolean isAsset() {
        if (this.isAsset == null) {
            this.isAsset = ResourceUtil.isResourceType((Resource)this.resource, (String)"cpa:Asset");
        }
        return this.isAsset;
    }

    public boolean isImage() {
        if (this.isImage == null) {
            this.isImage = this.isFile() && this.getMimeType().startsWith("image/") || this.isAsset();
        }
        return this.isImage;
    }

    public String getImageCSS() {
        String mimeType = this.getMimeType();
        return mimeType.substring(mimeType.indexOf(47) + 1).replaceAll("[+]", " ");
    }

    public boolean isVideo() {
        if (this.isVideo == null) {
            this.isVideo = this.isFile() && this.getMimeType().startsWith("video/");
        }
        return this.isVideo;
    }

    public boolean isText() {
        if (this.isText == null) {
            this.isText = this.isFile() && StringUtils.isNotBlank((CharSequence)this.getTextType());
        }
        return this.isText;
    }

    public boolean isRenderable() {
        if (this.isRenderable == null) {
            String extension = this.getNameExtension();
            this.isRenderable = this.isTyped() || this.isText() && HTML.equals(extension);
        }
        return this.isRenderable;
    }

    public String getNameExtension() {
        if (this.nameExtension == null) {
            this.nameExtension = ResourceUtil.getNameExtension((Resource)this.getResource());
        }
        return this.nameExtension;
    }

    public String getTextType() {
        if (this.textType == null) {
            String mimeType = this.getMimeType();
            String extension = this.getNameExtension();
            this.textType = Browser.getTextType(mimeType, extension);
        }
        return this.textType;
    }

    public static String getTextType(String mimeType, String extension) {
        String textType = null;
        if (StringUtils.isNotBlank((CharSequence)mimeType) && StringUtils.isBlank((CharSequence)(textType = EDITOR_MODES.get(mimeType)))) {
            String[] parts = StringUtils.split((String)mimeType, (char)'/');
            if (parts.length > 1) {
                textType = EDITOR_MODES.get(parts[1]);
            }
            if (StringUtils.isBlank((CharSequence)textType)) {
                if (StringUtils.isNotBlank((CharSequence)extension)) {
                    textType = EDITOR_MODES.get(extension);
                }
                if (StringUtils.isBlank((CharSequence)textType)) {
                    textType = EDITOR_MODES.get(parts[0]);
                }
            }
        }
        if (StringUtils.isBlank(textType) && StringUtils.isNotBlank((CharSequence)extension)) {
            textType = EDITOR_MODES.get(extension);
        }
        if (textType == null) {
            textType = "";
        }
        return textType;
    }

    public Property getData() {
        Node node;
        Property data = null;
        ResourceHandle content = this.getContentResource();
        if (content != null && (node = (Node)content.adaptTo(Node.class)) != null) {
            try {
                data = node.getProperty(PROP_DATA);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return data;
    }

    public Binary getBinary() {
        Binary binary = null;
        Property data = this.getData();
        if (data != null) {
            try {
                binary = data.getBinary();
            }
            catch (RepositoryException e) {
                LOG.error(e.getMessage(), (Throwable)e);
            }
        }
        return binary;
    }

    public String getViewType() {
        if (this.viewType == null) {
            this.viewType = "something";
            if (this.isFile()) {
                this.viewType = this.isVideo() ? "video" : (this.isImage() ? "image" : (this.isText() ? ("groovy".equalsIgnoreCase(this.getTextType()) ? "script" : "text") : "binary"));
            } else if (this.isAsset()) {
                this.viewType = "image";
            } else {
                String resourceType = this.getResourceType();
                if (StringUtils.isNotBlank((CharSequence)resourceType)) {
                    this.viewType = "typed";
                }
            }
        }
        return this.viewType;
    }

    public String getTabType() {
        String selector = this.getRequest().getSelectors((StringFilter)new StringFilter.BlackList("^tab$"));
        return StringUtils.isNotBlank((CharSequence)selector) ? selector.substring(1) : "properties";
    }

    public String getName() {
        return this.getResource().getResourceName();
    }

    public NodeHandle getCurrent() {
        if (this.current == null) {
            this.current = new NodeHandle((Resource)this.resource);
        }
        return this.current;
    }

    public String getCurrentPathUrl() {
        return this.getCurrent().getPathUrl();
    }

    public String getMappedUrl() {
        return this.getCurrent().getMappedUrl();
    }

    public String getCurrentUrl() {
        return this.getCurrent().getUrl();
    }

    public String getEditCodeUrl() {
        return LinkUtil.getUnmappedUrl((SlingHttpServletRequest)this.getRequest(), (String)("/bin/cpm/edit/code.html" + this.getCurrent().getPath()));
    }

    public String getMimeType() {
        return this.getCurrent().getMimeType();
    }

    public NodeHandle getParent() {
        if (this.parent == null) {
            this.parent = new NodeHandle((Resource)this.resource.getParent());
        }
        return this.parent;
    }

    public List<NodeHandle> getParents() {
        if (this.parents == null) {
            String parentPath;
            this.parents = new ArrayList<NodeHandle>();
            ResourceHandle resource = this.getResource();
            while (StringUtils.isNotBlank((CharSequence)(parentPath = resource.getParentPath()))) {
                NodeHandle parent = new NodeHandle(this.getResolver().resolve(parentPath));
                this.parents.add(0, parent);
                resource = parent.getResource();
            }
        }
        return this.parents;
    }

    static {
        EDITOR_MODES.put("json", "json");
        EDITOR_MODES.put("xml", "xml");
        EDITOR_MODES.put(HTML, HTML);
        EDITOR_MODES.put(JSP, JSP);
        EDITOR_MODES.put("esp", JSP);
        EDITOR_MODES.put("css", "css");
        EDITOR_MODES.put("less", "less");
        EDITOR_MODES.put("js", "javascript");
        EDITOR_MODES.put("ecma", "javascript");
        EDITOR_MODES.put("javascript", "javascript");
        EDITOR_MODES.put("dart", "dart");
        EDITOR_MODES.put("groovy", "groovy");
        EDITOR_MODES.put("java", "java");
        EDITOR_MODES.put("scala", "scala");
        EDITOR_MODES.put("markdown", "markdown");
        EDITOR_MODES.put("text", "text");
        EDITOR_MODES.put("txt", "text");
    }

    public class NodeHandle {
        protected ResourceHandle resource;
        protected String name;
        protected String path;
        protected String pathUrl;
        protected String mappedUrl;
        protected String url;
        protected String mimeType;

        public NodeHandle(Resource resource) {
            this.resource = ResourceHandle.use((Resource)resource);
        }

        public ResourceHandle getResource() {
            return this.resource;
        }

        public String getId() {
            return this.resource.getId();
        }

        public String getName() {
            if (this.name == null) {
                this.name = this.resource.getName();
                if (StringUtils.isBlank((CharSequence)this.name)) {
                    this.name = "jcr:root";
                }
            }
            return this.name;
        }

        public String getNameEscaped() {
            return StringEscapeUtils.escapeHtml4((String)this.getName());
        }

        public String getPath() {
            if (this.path == null) {
                this.path = this.resource.getPath();
            }
            return this.path;
        }

        public String getPathEncoded() {
            return LinkUtil.encodePath((String)this.getPath());
        }

        public String getPathUrl() {
            if (this.pathUrl == null) {
                this.pathUrl = this.getPathEncoded();
                this.pathUrl = this.pathUrl + LinkUtil.getExtension((ResourceHandle)this.resource, (String)(Browser.this.isAsset() ? "" : null));
            }
            return this.pathUrl;
        }

        public String getMappedUrl() {
            if (this.mappedUrl == null) {
                this.mappedUrl = LinkUtil.getMappedUrl((SlingHttpServletRequest)Browser.this.getRequest(), (String)this.getPath());
            }
            return this.mappedUrl;
        }

        public String getUrl() {
            if (this.url == null) {
                this.url = LinkUtil.getUrl((SlingHttpServletRequest)Browser.this.getRequest(), (String)this.getPath(), (String)(Browser.this.isAsset() ? "" : null));
            }
            return this.url;
        }

        public String getMimeType() {
            if (this.mimeType == null) {
                this.mimeType = MimeTypeUtil.getMimeType((Resource)this.resource, (String)Browser.DEFAULT_MIME_TYPE);
            }
            return this.mimeType;
        }
    }
}

