/*
 * Decompiled with CFR 0.152.
 */
package com.composum.sling.nodes;

import com.composum.sling.core.filter.ResourceFilter;
import com.composum.sling.core.mapping.jcr.ResourceFilterMapping;
import com.composum.sling.nodes.NodesConfiguration;
import com.composum.sling.nodes.servlet.NodeServlet;
import com.composum.sling.nodes.servlet.PropertyServlet;
import com.composum.sling.nodes.servlet.SecurityServlet;
import com.composum.sling.nodes.servlet.SourceServlet;
import com.composum.sling.nodes.servlet.VersionServlet;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.Servlet;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Modified;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.commons.osgi.PropertiesUtil;
import org.osgi.service.component.ComponentContext;

@Component(label="Composum Nodes (Console) Configuration", description="the configuration service for all servlets in the nodes bundles", immediate=true, metatype=true)
@Service
public class NodesConfigImpl
implements NodesConfiguration {
    @Property(name="console.access.check", label="Check Console Access", description="if 'true' (checked) the access to the console pages is checked on servlet access", boolValue={true})
    private boolean checkConsoleAccess;
    @Property(name="console.categories", label="Console Categories", description="the list of categories to determine the views in the core console", value={"core", "nodes"})
    private String[] consoleCategories;
    @Property(name="query.result.limit", label="Query Result Limit", description="the maximum node count for query results (default: 500)", longValue={500L})
    private long queryResultLimit;
    @Property(name="query.templates", label="Query Templates", description="a list of templates for the initial query history list", value={"/content/test ${text}", "${path}//${name}[jcr:contains(.,'${word}')]"})
    private String[] queryTemplates;
    @Property(name="errorpages.path", label="Errorpages", description="the path to the errorpages; e.g. 'meta/errorpages' for searching errorpages along the requested path", value={"meta/errorpages"})
    private String errorpagesPath;
    @Property(name="node.page.filter", label="Content Page Filter", description="the filter configuration to set the scope to the content pages", value={"or{ResourceType(+'^[a-z]+:.*([Ss]ite|[Pp]age)$'),and{PrimaryType(+'^nt:file$'),MimeType(+'^text/html$')}}"})
    private ResourceFilter pageNodeFilter;
    @Property(name="node.default.filter", label="The default Node Filter", description="the filter configuration to filter out system nodes", value={"and{Name(-'^rep:(repo)?[Pp]olicy$'),Path(-'^/bin(/.*)?$,^/services(/.*)?$,^/servlet(/.*)?$,^/(jcr:)?system(/.*)?$')}"})
    private ResourceFilter defaultNodeFilter;
    @Property(name="tree.intermediate.filter", label="Tree Intermediate (Folder) Filter", description="the filter configuration to determine all intermediate nodes in the tree view", value={"or{Folder(),PrimaryType(+'^dam:Asset(Content)?$')}"})
    private ResourceFilter treeIntermediateFilter;
    @Property(name="node.referenceable.filter", label="Referenceable Nodes Filter", description="the filter configuration to select reference target nodes", value={"Type(mix:referenceable)"})
    private ResourceFilter referenceableNodesFilter;
    @Property(name="node.orderable.filter", label="Orderable Nodes Filter", description="the filter configuration to detect ordered nodes (prevent from sorting in the tree)", value={"or{Type(node:orderable),PrimaryType(+'^.*([Oo]rdered|[Pp]age).*$,^sling:(Mapping)$,^nt:(unstructured|frozenNode)$,^rep:(ACL|Members|system)$')}"})
    private ResourceFilter orderableNodesFilter;
    @Property(name="node.source.filter", label="XML Source Nodes Filter", description="the filter configuration for the source export of the repository content (Source Servlet)", value={"PrimaryType(-'^cpp:(Statistics)$,^rep:(.+)$')"})
    private ResourceFilter sourceNodesFilter;
    @Property(name="package.servlet.enabled", label="Package Servlet", description="the general on/off switch for the services of the Package Servlet", boolValue={true})
    private boolean packageServletEnabled;
    @Property(name="security.servlet.enabled", label="Security Servlet", description="the general on/off switch for the services of the Security Servlet", boolValue={true})
    private boolean securityServletEnabled;
    @Property(name="node.servlet.enabled", label="Node Servlet", description="the general on/off switch for the services of the Node Servlet", boolValue={true})
    private boolean nodeServletEnabled;
    @Property(name="property.servlet.enabled", label="Property Servlet", description="the general on/off switch for the services of the Property Servlet", boolValue={true})
    private boolean propertyServletEnabled;
    @Property(name="version.servlet.enabled", label="Version Servlet", description="the general on/off switch for the services of the Version Servlet", boolValue={true})
    private boolean versionServletEnabled;
    @Property(name="source.servlet.enabled", label="Source Servlet", description="the general on/off switch for the services of the Source Servlet", boolValue={true})
    private boolean sourceServletEnabled;
    @Property(name="usermanagement.servlet.enabled", label="User Management Servlet", description="the general on/off switch for the services of the User Management Servlet", boolValue={true})
    private boolean userManagementServletEnabled;
    private Map<String, Boolean> enabledServlets;
    protected Dictionary properties;

    @Override
    public boolean isEnabled(Servlet servlet) {
        Boolean result = this.enabledServlets.get(servlet.getClass().getSimpleName());
        return result != null ? result : false;
    }

    @Override
    public boolean checkConsoleAccess() {
        return this.checkConsoleAccess;
    }

    @Override
    public String[] getConsoleCategories() {
        return this.consoleCategories;
    }

    @Override
    public long getQueryResultLimit() {
        return this.queryResultLimit;
    }

    @Override
    public String[] getQueryTemplates() {
        return this.queryTemplates;
    }

    @Override
    public ResourceFilter getPageNodeFilter() {
        return this.pageNodeFilter;
    }

    @Override
    public ResourceFilter getDefaultNodeFilter() {
        return this.defaultNodeFilter;
    }

    @Override
    public ResourceFilter getTreeIntermediateFilter() {
        return this.treeIntermediateFilter;
    }

    @Override
    public ResourceFilter getReferenceableNodesFilter() {
        return this.referenceableNodesFilter;
    }

    @Override
    public ResourceFilter getOrderableNodesFilter() {
        return this.orderableNodesFilter;
    }

    @Override
    public ResourceFilter getSourceNodesFilter() {
        return this.sourceNodesFilter;
    }

    @Override
    public Dictionary getProperties() {
        return this.properties;
    }

    @Activate
    @Modified
    protected void activate(ComponentContext context) {
        this.properties = context.getProperties();
        this.checkConsoleAccess = (Boolean)this.properties.get("console.access.check");
        this.consoleCategories = PropertiesUtil.toStringArray(this.properties.get("console.categories"));
        this.queryResultLimit = PropertiesUtil.toLong(this.properties.get("query.result.limit"), (long)500L);
        this.queryTemplates = PropertiesUtil.toStringArray(this.properties.get("query.templates"));
        this.errorpagesPath = (String)this.properties.get("errorpages.path");
        if (this.errorpagesPath.endsWith("/") && this.errorpagesPath.length() > 1) {
            this.errorpagesPath = this.errorpagesPath.substring(this.errorpagesPath.length() - 1);
        }
        this.pageNodeFilter = ResourceFilterMapping.fromString((String)((String)this.properties.get("node.page.filter")));
        this.defaultNodeFilter = ResourceFilterMapping.fromString((String)((String)this.properties.get("node.default.filter")));
        this.treeIntermediateFilter = ResourceFilterMapping.fromString((String)((String)this.properties.get("tree.intermediate.filter")));
        this.referenceableNodesFilter = ResourceFilterMapping.fromString((String)((String)this.properties.get("node.referenceable.filter")));
        this.orderableNodesFilter = ResourceFilterMapping.fromString((String)((String)this.properties.get("node.orderable.filter")));
        this.sourceNodesFilter = ResourceFilterMapping.fromString((String)((String)this.properties.get("node.source.filter")));
        this.enabledServlets = new HashMap<String, Boolean>();
        this.packageServletEnabled = (Boolean)this.properties.get("package.servlet.enabled");
        this.enabledServlets.put("PackageServlet", this.packageServletEnabled);
        this.securityServletEnabled = (Boolean)this.properties.get("security.servlet.enabled");
        this.enabledServlets.put(SecurityServlet.class.getSimpleName(), this.securityServletEnabled);
        this.nodeServletEnabled = (Boolean)this.properties.get("node.servlet.enabled");
        this.enabledServlets.put(NodeServlet.class.getSimpleName(), this.nodeServletEnabled);
        this.propertyServletEnabled = (Boolean)this.properties.get("property.servlet.enabled");
        this.enabledServlets.put(PropertyServlet.class.getSimpleName(), this.propertyServletEnabled);
        this.versionServletEnabled = (Boolean)this.properties.get("version.servlet.enabled");
        this.enabledServlets.put(VersionServlet.class.getSimpleName(), this.versionServletEnabled);
        this.sourceServletEnabled = (Boolean)this.properties.get("source.servlet.enabled");
        this.enabledServlets.put(SourceServlet.class.getSimpleName(), this.sourceServletEnabled);
        this.userManagementServletEnabled = (Boolean)this.properties.get("usermanagement.servlet.enabled");
        this.enabledServlets.put("UserManagementServlet", this.userManagementServletEnabled);
    }

    @Deactivate
    protected void deactivate(ComponentContext context) {
        this.properties = null;
    }
}

