/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.jackrabbit.usermanager.impl.resource;

import java.security.Principal;
import java.util.ArrayList;
import java.util.Iterator;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.apache.jackrabbit.api.security.principal.PrincipalIterator;
import org.apache.jackrabbit.api.security.principal.PrincipalManager;
import org.apache.jackrabbit.api.security.user.Authorizable;
import org.apache.jackrabbit.api.security.user.UserManager;
import org.apache.sling.api.SlingException;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.SyntheticResource;
import org.apache.sling.jackrabbit.usermanager.impl.resource.AuthorizableResource;
import org.apache.sling.jcr.base.util.AccessControlUtil;
import org.apache.sling.spi.resource.provider.ResolveContext;
import org.apache.sling.spi.resource.provider.ResourceContext;
import org.apache.sling.spi.resource.provider.ResourceProvider;
import org.osgi.service.component.annotations.Component;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(service={ResourceProvider.class}, property={"service.description=Resource provider implementation for UserManager resources", "service.vendor=The Apache Software Foundation", "provider.root=/system/userManager"})
public class AuthorizableResourceProvider
extends ResourceProvider<Object> {
    private final Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    public static final String SYSTEM_USER_MANAGER_PATH = "/system/userManager";
    public static final String SYSTEM_USER_MANAGER_USER_PATH = "/system/userManager/user";
    public static final String SYSTEM_USER_MANAGER_GROUP_PATH = "/system/userManager/group";
    public static final String SYSTEM_USER_MANAGER_USER_PREFIX = "/system/userManager/user/";
    public static final String SYSTEM_USER_MANAGER_GROUP_PREFIX = "/system/userManager/group/";

    public Resource getResource(ResolveContext<Object> ctx, String path, ResourceContext resourceContext, Resource parent) {
        if (path.equals(SYSTEM_USER_MANAGER_PATH)) {
            return new SyntheticResource(ctx.getResourceResolver(), path, "sling/userManager");
        }
        if (path.equals(SYSTEM_USER_MANAGER_USER_PATH)) {
            return new SyntheticResource(ctx.getResourceResolver(), path, "sling/users");
        }
        if (path.equals(SYSTEM_USER_MANAGER_GROUP_PATH)) {
            return new SyntheticResource(ctx.getResourceResolver(), path, "sling/groups");
        }
        String pid = null;
        if (path.startsWith(SYSTEM_USER_MANAGER_USER_PREFIX)) {
            pid = path.substring(SYSTEM_USER_MANAGER_USER_PREFIX.length());
        } else if (path.startsWith(SYSTEM_USER_MANAGER_GROUP_PREFIX)) {
            pid = path.substring(SYSTEM_USER_MANAGER_GROUP_PREFIX.length());
        }
        if (pid != null) {
            if (pid.indexOf(47) != -1) {
                return null;
            }
            try {
                Authorizable authorizable;
                UserManager userManager;
                Session session = (Session)ctx.getResourceResolver().adaptTo(Session.class);
                if (session != null && (userManager = AccessControlUtil.getUserManager((Session)session)) != null && (authorizable = userManager.getAuthorizable(pid)) != null) {
                    return new AuthorizableResource(authorizable, ctx.getResourceResolver(), path);
                }
            }
            catch (RepositoryException re) {
                throw new SlingException("Error looking up Authorizable for principal: " + pid, (Throwable)re);
            }
        }
        return null;
    }

    public Iterator<Resource> listChildren(ResolveContext<Object> ctx, Resource parent) {
        try {
            String path = parent.getPath();
            ResourceResolver resourceResolver = parent.getResourceResolver();
            if (SYSTEM_USER_MANAGER_PATH.equals(path)) {
                ArrayList<Resource> resources = new ArrayList<Resource>();
                if (resourceResolver != null) {
                    resources.add(this.getResource(ctx, SYSTEM_USER_MANAGER_USER_PATH, null, null));
                    resources.add(this.getResource(ctx, SYSTEM_USER_MANAGER_GROUP_PATH, null, null));
                }
                return resources.iterator();
            }
            int searchType = -1;
            if (SYSTEM_USER_MANAGER_USER_PATH.equals(path)) {
                searchType = 1;
            } else if (SYSTEM_USER_MANAGER_GROUP_PATH.equals(path)) {
                searchType = 2;
            }
            if (searchType != -1) {
                PrincipalIterator principals = null;
                Session session = (Session)resourceResolver.adaptTo(Session.class);
                if (session != null) {
                    PrincipalManager principalManager = AccessControlUtil.getPrincipalManager((Session)session);
                    principals = principalManager.getPrincipals(searchType);
                }
                if (principals != null) {
                    return new ChildrenIterator(parent, principals);
                }
            }
        }
        catch (RepositoryException re) {
            throw new SlingException("Error listing children of resource: " + parent.getPath(), (Throwable)re);
        }
        return null;
    }

    private final class ChildrenIterator
    implements Iterator<Resource> {
        private PrincipalIterator principals;
        private Resource parent;

        public ChildrenIterator(Resource parent, PrincipalIterator principals) {
            this.parent = parent;
            this.principals = principals;
        }

        @Override
        public boolean hasNext() {
            return this.principals.hasNext();
        }

        @Override
        public Resource next() {
            Principal nextPrincipal = this.principals.nextPrincipal();
            try {
                Authorizable authorizable;
                UserManager userManager;
                Session session;
                ResourceResolver resourceResolver = this.parent.getResourceResolver();
                if (resourceResolver != null && (session = (Session)resourceResolver.adaptTo(Session.class)) != null && (userManager = AccessControlUtil.getUserManager((Session)session)) != null && (authorizable = userManager.getAuthorizable(nextPrincipal.getName())) != null) {
                    String path = authorizable.isGroup() ? AuthorizableResourceProvider.SYSTEM_USER_MANAGER_GROUP_PREFIX + nextPrincipal.getName() : AuthorizableResourceProvider.SYSTEM_USER_MANAGER_USER_PREFIX + nextPrincipal.getName();
                    return new AuthorizableResource(authorizable, resourceResolver, path);
                }
            }
            catch (RepositoryException re) {
                AuthorizableResourceProvider.this.log.error("Exception while looking up authorizable resource.", (Throwable)re);
            }
            return null;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

