/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.jackrabbit.usermanager.impl;

import java.io.UnsupportedEncodingException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.util.Map;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.security.AccessControlManager;
import javax.jcr.security.Privilege;
import org.apache.jackrabbit.api.security.user.Authorizable;
import org.apache.jackrabbit.api.security.user.User;
import org.apache.jackrabbit.api.security.user.UserManager;
import org.apache.jackrabbit.oak.spi.security.user.UserConfiguration;
import org.apache.sling.commons.osgi.OsgiUtil;
import org.apache.sling.jackrabbit.usermanager.AuthorizablePrivilegesInfo;
import org.apache.sling.jackrabbit.usermanager.CreateUser;
import org.apache.sling.jcr.base.util.AccessControlUtil;
import org.osgi.framework.BundleContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(service={AuthorizablePrivilegesInfo.class}, property={"user.admin.group.name=UserAdmin", "group.admin.group.name=GroupAdmin"})
public class AuthorizablePrivilegesInfoImpl
implements AuthorizablePrivilegesInfo {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    static final String DEFAULT_USER_ADMIN_GROUP_NAME = "UserAdmin";
    static final String PAR_USER_ADMIN_GROUP_NAME = "user.admin.group.name";
    static final String DEFAULT_GROUP_ADMIN_GROUP_NAME = "GroupAdmin";
    static final String PAR_GROUP_ADMIN_GROUP_NAME = "group.admin.group.name";
    private String usersPath;
    private String groupsPath;
    private boolean selfRegistrationEnabled;

    @Reference(cardinality=ReferenceCardinality.OPTIONAL, policy=ReferencePolicy.DYNAMIC)
    private void bindUserConfiguration(UserConfiguration userConfig, Map<String, Object> properties) {
        this.usersPath = (String)properties.get("usersPath");
        this.groupsPath = (String)properties.get("groupsPath");
    }

    private void unbindUserConfiguration(UserConfiguration userConfig, Map<String, Object> properties) {
        this.usersPath = null;
        this.groupsPath = null;
    }

    @Reference(cardinality=ReferenceCardinality.OPTIONAL, policy=ReferencePolicy.DYNAMIC)
    private void bindCreateUser(CreateUser createUser, Map<String, Object> properties) {
        this.selfRegistrationEnabled = Boolean.TRUE.equals(properties.get("self.registration.enabled"));
    }

    private void unbindCreateUser(CreateUser createUser, Map<String, Object> properties) {
        this.selfRegistrationEnabled = false;
    }

    @Override
    public boolean canAddGroup(Session jcrSession) {
        try {
            UserManager userManager = AccessControlUtil.getUserManager((Session)jcrSession);
            Authorizable currentUser = userManager.getAuthorizable(jcrSession.getUserID());
            if (currentUser != null && ((User)currentUser).isAdmin()) {
                return true;
            }
            if (this.groupsPath != null) {
                AccessControlManager acm = jcrSession.getAccessControlManager();
                boolean hasRights = acm.hasPrivileges(this.groupsPath, new Privilege[]{acm.privilegeFromName("{http://www.jcp.org/jcr/1.0}read"), acm.privilegeFromName("{http://www.jcp.org/jcr/1.0}readAccessControl"), acm.privilegeFromName("{http://www.jcp.org/jcr/1.0}modifyAccessControl"), acm.privilegeFromName("rep:write"), acm.privilegeFromName("rep:userManagement")});
                return hasRights;
            }
        }
        catch (RepositoryException e) {
            this.log.warn("Failed to determine if {} can add a new group", (Object)jcrSession.getUserID());
        }
        return false;
    }

    @Override
    public boolean canAddUser(Session jcrSession) {
        try {
            if (this.selfRegistrationEnabled) {
                return true;
            }
            UserManager userManager = AccessControlUtil.getUserManager((Session)jcrSession);
            Authorizable currentUser = userManager.getAuthorizable(jcrSession.getUserID());
            if (currentUser != null && ((User)currentUser).isAdmin()) {
                return true;
            }
            if (this.usersPath != null) {
                AccessControlManager acm = jcrSession.getAccessControlManager();
                boolean hasRights = acm.hasPrivileges(this.usersPath, new Privilege[]{acm.privilegeFromName("{http://www.jcp.org/jcr/1.0}read"), acm.privilegeFromName("{http://www.jcp.org/jcr/1.0}readAccessControl"), acm.privilegeFromName("{http://www.jcp.org/jcr/1.0}modifyAccessControl"), acm.privilegeFromName("rep:write"), acm.privilegeFromName("rep:userManagement")});
                return hasRights;
            }
        }
        catch (RepositoryException e) {
            this.log.warn("Failed to determine if {} can add a new user", (Object)jcrSession.getUserID());
        }
        return false;
    }

    @Override
    public boolean canRemove(Session jcrSession, String principalId) {
        try {
            UserManager userManager = AccessControlUtil.getUserManager((Session)jcrSession);
            Authorizable currentUser = userManager.getAuthorizable(jcrSession.getUserID());
            if (((User)currentUser).isAdmin()) {
                return true;
            }
            if (this.usersPath != null) {
                AccessControlManager acm = jcrSession.getAccessControlManager();
                boolean hasRights = acm.hasPrivileges("/home/users", new Privilege[]{acm.privilegeFromName("{http://www.jcp.org/jcr/1.0}read"), acm.privilegeFromName("{http://www.jcp.org/jcr/1.0}readAccessControl"), acm.privilegeFromName("{http://www.jcp.org/jcr/1.0}modifyAccessControl"), acm.privilegeFromName("rep:write"), acm.privilegeFromName("rep:userManagement")});
                return hasRights;
            }
        }
        catch (RepositoryException e) {
            this.log.warn("Failed to determine if {} can remove authorizable {}", (Object)jcrSession.getUserID(), (Object)principalId);
        }
        return false;
    }

    @Override
    public boolean canUpdateGroupMembers(Session jcrSession, String groupId) {
        try {
            UserManager userManager = AccessControlUtil.getUserManager((Session)jcrSession);
            Authorizable currentUser = userManager.getAuthorizable(jcrSession.getUserID());
            if (((User)currentUser).isAdmin()) {
                return true;
            }
            if (this.groupsPath != null) {
                AccessControlManager acm = jcrSession.getAccessControlManager();
                boolean hasRights = acm.hasPrivileges(this.groupsPath, new Privilege[]{acm.privilegeFromName("{http://www.jcp.org/jcr/1.0}read"), acm.privilegeFromName("{http://www.jcp.org/jcr/1.0}readAccessControl"), acm.privilegeFromName("{http://www.jcp.org/jcr/1.0}modifyAccessControl"), acm.privilegeFromName("rep:write"), acm.privilegeFromName("rep:userManagement")});
                return hasRights;
            }
        }
        catch (RepositoryException e) {
            this.log.warn("Failed to determine if {} can remove authorizable {}", (Object)jcrSession.getUserID(), (Object)groupId);
        }
        return false;
    }

    @Override
    public boolean canUpdateProperties(Session jcrSession, String principalId) {
        try {
            String path;
            if (jcrSession.getUserID().equals(principalId)) {
                return true;
            }
            UserManager userManager = AccessControlUtil.getUserManager((Session)jcrSession);
            Authorizable currentUser = userManager.getAuthorizable(jcrSession.getUserID());
            if (((User)currentUser).isAdmin()) {
                return true;
            }
            String string = path = currentUser.isGroup() ? this.groupsPath : this.usersPath;
            if (path != null) {
                AccessControlManager acm = jcrSession.getAccessControlManager();
                boolean hasRights = acm.hasPrivileges(path, new Privilege[]{acm.privilegeFromName("{http://www.jcp.org/jcr/1.0}read"), acm.privilegeFromName("{http://www.jcp.org/jcr/1.0}readAccessControl"), acm.privilegeFromName("{http://www.jcp.org/jcr/1.0}modifyAccessControl"), acm.privilegeFromName("rep:write"), acm.privilegeFromName("rep:userManagement")});
                return hasRights;
            }
        }
        catch (RepositoryException e) {
            this.log.warn("Failed to determine if {} can remove authorizable {}", (Object)jcrSession.getUserID(), (Object)principalId);
        }
        return false;
    }

    @Activate
    protected void activate(BundleContext bundleContext, Map<String, Object> properties) throws InvalidKeyException, NoSuchAlgorithmException, IllegalStateException, UnsupportedEncodingException {
        String groupAdminGroupName;
        String userAdminGroupName = OsgiUtil.toString((Object)properties.get(PAR_USER_ADMIN_GROUP_NAME), null);
        if (userAdminGroupName != null && !DEFAULT_USER_ADMIN_GROUP_NAME.equals(userAdminGroupName)) {
            this.log.warn("Configuration setting for {} is deprecated and will not have any effect", (Object)PAR_USER_ADMIN_GROUP_NAME);
        }
        if ((groupAdminGroupName = OsgiUtil.toString((Object)properties.get(PAR_GROUP_ADMIN_GROUP_NAME), null)) != null && !DEFAULT_GROUP_ADMIN_GROUP_NAME.equals(userAdminGroupName)) {
            this.log.warn("Configuration setting for {} is deprecated and will not have any effect", (Object)PAR_GROUP_ADMIN_GROUP_NAME);
        }
    }
}

