/*
 * Decompiled with CFR 0.152.
 */
package org.apache.johnzon.core;

import java.io.Serializable;
import javax.json.JsonArray;
import javax.json.JsonObject;
import javax.json.JsonStructure;
import javax.json.JsonValue;
import javax.json.JsonWriter;
import javax.json.stream.JsonGenerator;

class JsonWriterImpl
implements JsonWriter,
Serializable {
    private final JsonGenerator generator;
    private boolean closed = false;

    JsonWriterImpl(JsonGenerator generator) {
        this.generator = generator;
    }

    @Override
    public void writeArray(JsonArray array) {
        this.checkClosed();
        try {
            this.generator.write(array);
        }
        finally {
            this.close();
        }
    }

    @Override
    public void writeObject(JsonObject object) {
        this.checkClosed();
        try {
            this.generator.write(object);
        }
        finally {
            this.close();
        }
    }

    @Override
    public void write(JsonValue value) {
        this.checkClosed();
        try {
            this.generator.write(value);
        }
        finally {
            this.close();
        }
    }

    @Override
    public void write(JsonStructure value) {
        this.checkClosed();
        try {
            this.generator.write(value);
        }
        finally {
            this.close();
        }
    }

    @Override
    public void close() {
        if (!this.closed) {
            this.closed = true;
            this.generator.close();
        }
    }

    private void checkClosed() {
        if (this.closed) {
            throw new IllegalStateException("writeArray(), writeObject(), write() or close() method was already called");
        }
    }
}

