/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.jcr.resource.internal.helper.jcr;

import java.util.Collection;
import java.util.Map;
import java.util.Set;
import javax.jcr.Item;
import javax.jcr.Node;
import javax.jcr.Property;
import javax.jcr.RepositoryException;
import javax.jcr.ValueFormatException;
import org.apache.sling.api.resource.ResourceMetadata;
import org.apache.sling.jcr.resource.internal.helper.jcr.JcrItemResource;
import org.apache.sling.jcr.resource.internal.helper.jcr.JcrNodeResource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class JcrNodeResourceMetadata
extends ResourceMetadata {
    private static final long serialVersionUID = 1L;
    private static final Logger LOGGER = LoggerFactory.getLogger(JcrNodeResource.class);
    private final Node node;
    private Node contentNode;
    private boolean nodePromotionChecked = false;
    private long creationTime = -1L;
    private boolean populated = false;

    public JcrNodeResourceMetadata(Node inNode) {
        this.node = inNode;
    }

    private Node promoteNode() {
        try {
            if (!this.nodePromotionChecked && this.node.isNodeType("nt:file")) {
                this.creationTime = this.node.getProperty("jcr:created").getLong();
                if (!this.node.isNew() || this.node.hasNode("jcr:content")) {
                    this.contentNode = this.node.getNode("jcr:content");
                }
                this.nodePromotionChecked = true;
            }
        }
        catch (RepositoryException re) {
            this.report(re);
        }
        return this.contentNode != null ? this.contentNode : this.node;
    }

    private void report(RepositoryException re) {
        String nodePath = "<unknown node path>";
        try {
            nodePath = this.contentNode != null ? this.contentNode.getPath() : this.node.getPath();
        }
        catch (RepositoryException repositoryException) {
            // empty catch block
        }
        LOGGER.info("setMetaData: Problem extracting metadata information for " + nodePath, (Throwable)re);
    }

    public Object get(Object key) {
        Object result = super.get(key);
        if (result != null) {
            return result;
        }
        if ("sling.creationTime".equals(key)) {
            this.promoteNode();
            this.internalPut("sling.creationTime", this.creationTime);
            return this.creationTime;
        }
        if ("sling.contentType".equals(key)) {
            String contentType = null;
            Node targetNode = this.promoteNode();
            try {
                if (targetNode.hasProperty("jcr:mimeType")) {
                    contentType = targetNode.getProperty("jcr:mimeType").getString();
                }
            }
            catch (RepositoryException re) {
                this.report(re);
            }
            this.internalPut("sling.contentType", contentType);
            return contentType;
        }
        if ("sling.characterEncoding".equals(key)) {
            String characterEncoding = null;
            Node targetNode = this.promoteNode();
            try {
                if (targetNode.hasProperty("jcr:encoding")) {
                    characterEncoding = targetNode.getProperty("jcr:encoding").getString();
                }
            }
            catch (RepositoryException re) {
                this.report(re);
            }
            this.internalPut("sling.characterEncoding", characterEncoding);
            return characterEncoding;
        }
        if ("sling.modificationTime".equals(key)) {
            long modificationTime = -1L;
            Node targetNode = this.promoteNode();
            try {
                if (targetNode.hasProperty("jcr:lastModified")) {
                    Property prop = targetNode.getProperty("jcr:lastModified");
                    try {
                        modificationTime = prop.getLong();
                    }
                    catch (ValueFormatException vfe) {
                        LOGGER.debug("Property {} cannot be converted to a long, ignored ({})", (Object)prop.getPath(), (Object)vfe);
                    }
                }
            }
            catch (RepositoryException re) {
                this.report(re);
            }
            this.internalPut("sling.modificationTime", modificationTime);
            return modificationTime;
        }
        if ("sling.contentLength".equals(key)) {
            long contentLength = -1L;
            Node targetNode = this.promoteNode();
            try {
                if (targetNode.hasProperty("jcr:data")) {
                    Property prop = targetNode.getProperty("jcr:data");
                    contentLength = JcrItemResource.getContentLength(prop);
                } else {
                    Item item = this.getPrimaryItem(targetNode);
                    while (item != null && item.isNode()) {
                        item = this.getPrimaryItem((Node)item);
                    }
                    if (item != null) {
                        Property data = (Property)item;
                        contentLength = JcrItemResource.getContentLength(data);
                    }
                }
            }
            catch (RepositoryException re) {
                this.report(re);
            }
            this.internalPut("sling.contentLength", contentLength);
            return contentLength;
        }
        return null;
    }

    private Item getPrimaryItem(Node node) throws RepositoryException {
        String name = node.getPrimaryNodeType().getPrimaryItemName();
        if (name == null) {
            return null;
        }
        if (node.hasProperty(name)) {
            return node.getProperty(name);
        }
        if (node.hasNode(name)) {
            return node.getNode(name);
        }
        return null;
    }

    private void populate() {
        if (this.populated) {
            return;
        }
        this.get("sling.creationTime");
        this.get("sling.contentType");
        this.get("sling.characterEncoding");
        this.get("sling.modificationTime");
        this.get("sling.contentLength");
        this.populated = true;
    }

    public Set<Map.Entry<String, Object>> entrySet() {
        this.populate();
        return super.entrySet();
    }

    public Set<String> keySet() {
        this.populate();
        return super.keySet();
    }

    public Collection<Object> values() {
        this.populate();
        return super.values();
    }

    public int size() {
        this.populate();
        return super.size();
    }

    public boolean isEmpty() {
        return false;
    }

    public boolean containsKey(Object key) {
        if (super.containsKey(key)) {
            return true;
        }
        return "sling.creationTime".equals(key) || "sling.contentType".equals(key) || "sling.characterEncoding".equals(key) || "sling.modificationTime".equals(key) || "sling.contentLength".equals(key);
    }

    public boolean containsValue(Object value) {
        if (super.containsValue(value)) {
            return true;
        }
        if (!this.populated) {
            this.populate();
            return super.containsValue(value);
        }
        return false;
    }
}

