/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.models.jacksonexporter.impl;

import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.databind.module.SimpleSerializers;
import java.util.Map;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.commons.osgi.PropertiesUtil;
import org.apache.sling.models.jacksonexporter.ModuleProvider;
import org.apache.sling.models.jacksonexporter.impl.ModelSkippingSerializers;
import org.apache.sling.models.jacksonexporter.impl.ResourceSerializer;

@Component(metatype=true, label="Apache Sling Models Jackson Exporter - Resource object support", description="Provider of a Jackson Module which enables support for proper serialization of Resource objects")
@Service
@Property(name="service.ranking", intValue={0}, propertyPrivate=true)
public class ResourceModuleProvider
implements ModuleProvider {
    private static final int DEFAULT_MAX_RECURSION_LEVELS = -1;
    @Property(label="Maximum Recursion Levels", description="Maximum number of levels of child resources which will be exported for each resource. Specify -1 for infinite.", intValue={-1})
    private static final String PROP_MAX_RECURSION_LEVELS = "max.recursion.levels";
    private SimpleModule moduleInstance;

    @Activate
    private void activate(Map<String, Object> props) {
        int maxRecursionLevels = PropertiesUtil.toInteger(props.get(PROP_MAX_RECURSION_LEVELS), -1);
        this.moduleInstance = new SimpleModule();
        ModelSkippingSerializers serializers = new ModelSkippingSerializers();
        serializers.addSerializer(Resource.class, new ResourceSerializer(maxRecursionLevels));
        this.moduleInstance.setSerializers((SimpleSerializers)serializers);
    }

    @Override
    public Module getModule() {
        return this.moduleInstance;
    }
}

