/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.document;

import com.google.common.base.Preconditions;
import com.google.common.base.Stopwatch;
import java.lang.management.ManagementFactory;
import java.net.NetworkInterface;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import org.apache.jackrabbit.oak.commons.StringUtils;
import org.apache.jackrabbit.oak.plugins.document.ClusterNodeInfoDocument;
import org.apache.jackrabbit.oak.plugins.document.Collection;
import org.apache.jackrabbit.oak.plugins.document.DocumentNodeStore;
import org.apache.jackrabbit.oak.plugins.document.DocumentStore;
import org.apache.jackrabbit.oak.plugins.document.DocumentStoreException;
import org.apache.jackrabbit.oak.plugins.document.LeaseFailureHandler;
import org.apache.jackrabbit.oak.plugins.document.UpdateOp;
import org.apache.jackrabbit.oak.plugins.document.util.Utils;
import org.apache.jackrabbit.oak.stats.Clock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClusterNodeInfo {
    private static final String LEASE_CHECK_FAILED_MSG = "This oak instance failed to update the lease in time and can therefore no longer access this DocumentNodeStore.";
    private static final Logger LOG = LoggerFactory.getLogger(ClusterNodeInfo.class);
    private static final String RANDOM_PREFIX = "random:";
    private static final String MACHINE_ID_KEY = "machine";
    static final String OAK_VERSION_KEY = "oakVersion";
    private static final String INSTANCE_ID_KEY = "instance";
    public static final String LEASE_END_KEY = "leaseEnd";
    public static final String START_TIME_KEY = "startTime";
    public static final String LAST_WRITTEN_ROOT_REV_KEY = "lastWrittenRootRev";
    public static final String STATE = "state";
    public static final String BROADCAST_ID = "broadcastId";
    public static final String BROADCAST_LISTENER = "broadcastListener";
    public static final String REV_RECOVERY_LOCK = "recoveryLock";
    public static final String REV_RECOVERY_BY = "recoveryBy";
    private static final String INFO_KEY = "info";
    private static final String READ_WRITE_MODE_KEY = "readWriteMode";
    private static final String MACHINE_ID = ClusterNodeInfo.getMachineId();
    private static final long PROCESS_ID = ClusterNodeInfo.getProcessId();
    protected static String WORKING_DIR = System.getProperty("user.dir", "");
    private static Clock clock = Clock.SIMPLE;
    public static final int DEFAULT_LEASE_DURATION_MILLIS;
    public static final int DEFAULT_LEASE_UPDATE_INTERVAL_MILLIS = 10000;
    public static final int DEFAULT_LEASE_FAILURE_MARGIN_MILLIS = 20000;
    public static final boolean DEFAULT_LEASE_CHECK_DISABLED;
    private static final int MAX_RETRY_SLEEPS_BEFORE_LEASE_FAILURE = 5;
    private static final String OAK_VERSION;
    private long leaseTime = DEFAULT_LEASE_DURATION_MILLIS;
    private long leaseUpdateInterval = 10000L;
    private long leaseFailureMargin = 20000L;
    private final int id;
    private final String machineId;
    private final String instanceId;
    private final DocumentStore store;
    private final long startTime;
    private final String uuid = UUID.randomUUID().toString();
    private volatile long leaseEndTime;
    private long previousLeaseEndTime;
    private String readWriteMode;
    private ClusterNodeState state;
    private boolean leaseCheckFailed = false;
    private boolean leaseCheckDisabled;
    private boolean renewed;
    private RecoverLockState revRecoveryLock;
    private boolean newEntry;
    private LeaseFailureHandler leaseFailureHandler;

    private ClusterNodeInfo(int id, DocumentStore store, String machineId, String instanceId, ClusterNodeState state, RecoverLockState revRecoveryLock, Long leaseEnd, boolean newEntry) {
        this.id = id;
        this.startTime = ClusterNodeInfo.getCurrentTime();
        this.leaseEndTime = leaseEnd == null ? this.startTime : leaseEnd;
        this.renewed = false;
        this.store = store;
        this.machineId = machineId;
        this.instanceId = instanceId;
        this.state = state;
        this.revRecoveryLock = revRecoveryLock;
        this.newEntry = newEntry;
        this.leaseCheckDisabled = DEFAULT_LEASE_CHECK_DISABLED;
    }

    public void setLeaseCheckDisabled(boolean leaseCheckDisabled) {
        this.leaseCheckDisabled = leaseCheckDisabled;
    }

    public int getId() {
        return this.id;
    }

    public static ClusterNodeInfo getReadOnlyInstance(DocumentStore store) {
        return new ClusterNodeInfo(0, store, MACHINE_ID, WORKING_DIR, ClusterNodeState.ACTIVE, RecoverLockState.NONE, null, true){

            @Override
            public void dispose() {
            }

            @Override
            public long getLeaseTime() {
                return Long.MAX_VALUE;
            }

            @Override
            public void performLeaseCheck() {
            }

            @Override
            public boolean renewLease() {
                return false;
            }

            @Override
            public void setInfo(Map<String, String> info) {
            }

            @Override
            public void setLeaseFailureHandler(LeaseFailureHandler leaseFailureHandler) {
            }
        };
    }

    public static ClusterNodeInfo getInstance(DocumentStore store, int configuredClusterId) {
        return ClusterNodeInfo.getInstance(store, MACHINE_ID, WORKING_DIR, configuredClusterId, false);
    }

    public static ClusterNodeInfo getInstance(DocumentStore store, String machineId, String instanceId) {
        return ClusterNodeInfo.getInstance(store, machineId, instanceId, 0, true);
    }

    public static ClusterNodeInfo getInstance(DocumentStore store, String machineId, String instanceId, int configuredClusterId, boolean updateLease) {
        if (machineId == null) {
            machineId = MACHINE_ID;
        }
        if (instanceId == null) {
            instanceId = WORKING_DIR;
        }
        int retries = 10;
        for (int i = 0; i < retries; ++i) {
            boolean success;
            ClusterNodeInfo clusterNode = ClusterNodeInfo.createInstance(store, machineId, instanceId, configuredClusterId, i == 0);
            String key = String.valueOf(clusterNode.id);
            UpdateOp update = new UpdateOp(key, true);
            update.set(MACHINE_ID_KEY, clusterNode.machineId);
            update.set(INSTANCE_ID_KEY, clusterNode.instanceId);
            if (updateLease) {
                update.set(LEASE_END_KEY, ClusterNodeInfo.getCurrentTime() + clusterNode.leaseTime);
            } else {
                update.set(LEASE_END_KEY, clusterNode.leaseEndTime);
            }
            update.set(START_TIME_KEY, clusterNode.startTime);
            update.set(INFO_KEY, clusterNode.toString());
            update.set(STATE, clusterNode.state.name());
            update.set(REV_RECOVERY_LOCK, clusterNode.revRecoveryLock.name());
            update.set(OAK_VERSION_KEY, OAK_VERSION);
            if (clusterNode.newEntry) {
                success = store.create(Collection.CLUSTER_NODES, Collections.singletonList(update));
            } else {
                store.createOrUpdate(Collection.CLUSTER_NODES, update);
                success = true;
            }
            if (!success) continue;
            return clusterNode;
        }
        throw new DocumentStoreException("Could not get cluster node info (retried " + retries + " times)");
    }

    private static ClusterNodeInfo createInstance(DocumentStore store, String machineId, String instanceId, int configuredClusterId, boolean waitForLease) {
        long now = ClusterNodeInfo.getCurrentTime();
        int clusterNodeId = 0;
        int maxId = 0;
        ClusterNodeState state = ClusterNodeState.NONE;
        RecoverLockState lockState = RecoverLockState.NONE;
        Long prevLeaseEnd = null;
        boolean newEntry = false;
        ClusterNodeInfoDocument alreadyExistingConfigured = null;
        String reuseFailureReason = "";
        List<ClusterNodeInfoDocument> list = ClusterNodeInfoDocument.all(store);
        for (ClusterNodeInfoDocument doc : list) {
            int id;
            String key = doc.getId();
            try {
                id = doc.getClusterId();
            }
            catch (Exception e) {
                LOG.debug("Skipping cluster node info document {} because ID is invalid", (Object)key);
                continue;
            }
            maxId = Math.max(maxId, id);
            if (configuredClusterId != 0) {
                if (configuredClusterId != id) continue;
                alreadyExistingConfigured = doc;
            }
            Long leaseEnd = (Long)doc.get(LEASE_END_KEY);
            String mId = "" + doc.get(MACHINE_ID_KEY);
            String iId = "" + doc.get(INSTANCE_ID_KEY);
            if (leaseEnd != null && leaseEnd > now) {
                boolean worthRetrying;
                if (waitForLease && leaseEnd - now < (long)(DEFAULT_LEASE_DURATION_MILLIS + 5000) && mId.equals(machineId) && iId.equals(instanceId) && (worthRetrying = ClusterNodeInfo.waitForLeaseExpiry(store, doc, leaseEnd, machineId, instanceId))) {
                    return ClusterNodeInfo.createInstance(store, machineId, instanceId, configuredClusterId, false);
                }
                reuseFailureReason = "leaseEnd " + leaseEnd + " > " + now + " - " + (leaseEnd - now) + "ms in the future";
                continue;
            }
            if (mId.startsWith(RANDOM_PREFIX) && leaseEnd == null) {
                store.remove(Collection.CLUSTER_NODES, key);
                LOG.debug("Cleaned up cluster node info for clusterNodeId {} [machineId: {}, leaseEnd: n/a]", (Object)id, (Object)mId);
                if (alreadyExistingConfigured != doc) continue;
                alreadyExistingConfigured = null;
                continue;
            }
            if (!mId.equals(machineId) || !iId.equals(instanceId)) {
                reuseFailureReason = "machineId/instanceId do not match: " + mId + "/" + iId + " != " + machineId + "/" + instanceId;
                continue;
            }
            if (clusterNodeId != 0 && id >= clusterNodeId) continue;
            clusterNodeId = id;
            state = ClusterNodeState.fromString((String)doc.get(STATE));
            prevLeaseEnd = leaseEnd;
            lockState = RecoverLockState.fromString((String)doc.get(REV_RECOVERY_LOCK));
        }
        if (clusterNodeId == 0) {
            newEntry = true;
            if (configuredClusterId != 0) {
                if (alreadyExistingConfigured != null) {
                    throw new DocumentStoreException("Configured cluster node id " + configuredClusterId + " already in use: " + reuseFailureReason);
                }
                clusterNodeId = configuredClusterId;
            } else {
                clusterNodeId = maxId + 1;
            }
        }
        return new ClusterNodeInfo(clusterNodeId, store, machineId, instanceId, state, lockState, prevLeaseEnd, newEntry);
    }

    private static boolean waitForLeaseExpiry(DocumentStore store, ClusterNodeInfoDocument cdoc, long leaseEnd, String machineId, String instanceId) {
        String key = cdoc.getId();
        LOG.info("Found an existing possibly active cluster node info (" + key + ") for this instance: " + machineId + "/" + instanceId + ", will try use it.");
        long waitUntil = leaseEnd + 2000L;
        while (ClusterNodeInfo.getCurrentTime() < waitUntil) {
            LOG.info("Waiting for cluster node " + key + "'s lease to expire: " + (waitUntil - ClusterNodeInfo.getCurrentTime()) / 1000L + "s left");
            try {
                clock.waitUntil(ClusterNodeInfo.getCurrentTime() + 5000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            try {
                ClusterNodeInfoDocument reread = store.find(Collection.CLUSTER_NODES, key);
                if (reread == null) {
                    LOG.info("Cluster node info " + key + ": gone; continueing.");
                    return true;
                }
                Long newLeaseEnd = (Long)reread.get(LEASE_END_KEY);
                if (newLeaseEnd == null) {
                    LOG.info("Cluster node " + key + ": lease end information missing, aborting.");
                    return false;
                }
                if (newLeaseEnd == leaseEnd) continue;
                LOG.info("Cluster node " + key + " seems to be still active (lease end changed from " + leaseEnd + " to " + newLeaseEnd + ", will not try to use it.");
                return false;
            }
            catch (DocumentStoreException ex) {
                LOG.info("Error reading cluster node info for key " + key, (Throwable)ex);
                return false;
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void performLeaseCheck() throws DocumentStoreException {
        if (this.leaseCheckDisabled || !this.renewed) {
            return;
        }
        if (this.leaseCheckFailed) {
            throw ClusterNodeInfo.leaseExpired(LEASE_CHECK_FAILED_MSG, true);
        }
        long now = ClusterNodeInfo.getCurrentTime();
        if (now < this.leaseEndTime - this.leaseFailureMargin) {
            return;
        }
        ClusterNodeInfo clusterNodeInfo = this;
        synchronized (clusterNodeInfo) {
            if (this.leaseCheckFailed) {
                throw ClusterNodeInfo.leaseExpired(LEASE_CHECK_FAILED_MSG, true);
            }
            for (int i = 0; i < 5; ++i) {
                now = ClusterNodeInfo.getCurrentTime();
                if (now < this.leaseEndTime - this.leaseFailureMargin) {
                    return;
                }
                try {
                    long difference = this.leaseEndTime - now;
                    long waitForMs = 1000L;
                    String detail = difference >= 0L ? String.format("lease within %dms of failing (%dms precisely)", this.leaseFailureMargin, difference) : String.format("already past lease end (%dms precisely)", -1L * difference);
                    String retries = String.format("waiting %dms to retry (up to another %d times...)", waitForMs, 4 - i);
                    LOG.info("performLeaseCheck: " + detail + " - " + retries);
                    this.wait(waitForMs);
                    continue;
                }
                catch (InterruptedException e) {
                    LOG.warn("performLeaseCheck: got interrupted - giving up: " + e, (Throwable)e);
                    break;
                }
            }
            if (this.leaseCheckFailed) {
                throw ClusterNodeInfo.leaseExpired(LEASE_CHECK_FAILED_MSG, true);
            }
            this.leaseCheckFailed = true;
        }
        String errorMsg = "This oak instance failed to update the lease in time and can therefore no longer access this DocumentNodeStore. (leaseEndTime: " + this.leaseEndTime + ", leaseTime: " + this.leaseTime + ", leaseFailureMargin: " + this.leaseFailureMargin + ", lease check end time (leaseEndTime-leaseFailureMargin): " + (this.leaseEndTime - this.leaseFailureMargin) + ", now: " + now + ", remaining: " + (this.leaseEndTime - this.leaseFailureMargin - now) + ") Need to stop oak-store-document/DocumentNodeStoreService.";
        LOG.error(errorMsg);
        this.handleLeaseFailure(errorMsg);
    }

    private void handleLeaseFailure(String errorMsg) {
        if (this.leaseFailureHandler != null) {
            Runnable r = new Runnable(){

                @Override
                public void run() {
                    if (ClusterNodeInfo.this.leaseFailureHandler != null) {
                        ClusterNodeInfo.this.leaseFailureHandler.handleLeaseFailure();
                    }
                }
            };
            Thread th = new Thread(r, "LeaseFailureHandler-Thread");
            th.setDaemon(true);
            th.start();
        }
        throw ClusterNodeInfo.leaseExpired(errorMsg, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public boolean renewLease() throws DocumentStoreException {
        block52: {
            now = ClusterNodeInfo.getCurrentTime();
            if (ClusterNodeInfo.LOG.isTraceEnabled()) {
                ClusterNodeInfo.LOG.trace("renewLease - leaseEndTime: " + this.leaseEndTime + ", leaseTime: " + this.leaseTime + ", leaseUpdateInterval: " + this.leaseUpdateInterval);
            }
            if (now < this.leaseEndTime - this.leaseTime + this.leaseUpdateInterval) {
                return false;
            }
            var5_2 = this;
            synchronized (var5_2) {
                if (this.leaseCheckFailed) {
                    throw ClusterNodeInfo.leaseExpired("This oak instance failed to update the lease in time and can therefore no longer access this DocumentNodeStore.", true);
                }
                now = ClusterNodeInfo.getCurrentTime();
                updatedLeaseEndTime = now + this.leaseTime;
            }
            update = new UpdateOp("" + this.id, false);
            update.set("leaseEnd", updatedLeaseEndTime);
            update.set("state", ClusterNodeState.ACTIVE.name());
            if (this.renewed && !this.leaseCheckDisabled) {
                update.equals("leaseEnd", null, this.previousLeaseEndTime);
                update.equals("state", null, ClusterNodeState.ACTIVE.name());
                update.notEquals("recoveryLock", RecoverLockState.ACQUIRED.name());
            }
            if (ClusterNodeInfo.LOG.isDebugEnabled()) {
                ClusterNodeInfo.LOG.debug("Renewing lease for cluster id " + this.id + " with UpdateOp " + update);
            }
            sw = Stopwatch.createStarted();
            result = null;
            doc = this.store.findAndUpdate(Collection.CLUSTER_NODES, update);
            result = doc;
            if (doc != null) break block52;
            var10_12 = this;
            synchronized (var10_12) {
                if (this.leaseCheckFailed) {
                    throw ClusterNodeInfo.leaseExpired("This oak instance failed to update the lease in time and can therefore no longer access this DocumentNodeStore.", true);
                }
                this.leaseCheckFailed = true;
            }
            errorMsg = "This oak instance failed to update the lease in time and can therefore no longer access this DocumentNodeStore. (Could not update lease anymore, someone else in the cluster must have noticed this instance' slowness already. Going to invoke leaseFailureHandler!)";
            try {
                current = this.store.find(Collection.CLUSTER_NODES, "" + this.id);
                if (current != null) {
                    leaseEnd = current.get("leaseEnd");
                    recoveryLock = current.get("recoveryLock");
                    recoveryBy = current.get("recoveryBy");
                    cnState = current.get("state");
                    errorMsg = errorMsg + " (leaseEnd: " + leaseEnd + " (expected: " + this.leaseEndTime + "), (state: " + cnState + " (expected: " + ClusterNodeState.ACTIVE.name() + "), recoveryLock: " + recoveryLock + ", recoveryBy: " + recoveryBy + ")";
                }
            }
            catch (DocumentStoreException ex) {
                ClusterNodeInfo.LOG.error("trying to read ClusterNodeInfo for cluster id " + this.id, (Throwable)ex);
            }
            ClusterNodeInfo.LOG.error(errorMsg);
            this.handleLeaseFailure(errorMsg);
            ex = false;
            sw.stop();
            msg = "Lease renewal for cluster id {} took {}, resulted in: {}";
            if (sw.elapsed(TimeUnit.SECONDS) > 10L) {
                ClusterNodeInfo.LOG.warn(msg, new Object[]{this.id, sw, result});
            } else if (sw.elapsed(TimeUnit.SECONDS) > 1L) {
                ClusterNodeInfo.LOG.info(msg, new Object[]{this.id, sw, result});
            } else if (ClusterNodeInfo.LOG.isDebugEnabled()) {
                ClusterNodeInfo.LOG.debug(msg, new Object[]{this.id, sw, result});
            }
            return ex;
        }
        try {
            this.previousLeaseEndTime = this.leaseEndTime = updatedLeaseEndTime;
            mode = (String)doc.get("readWriteMode");
            if (mode != null && !mode.equals(this.readWriteMode)) {
                this.readWriteMode = mode;
                this.store.setReadWriteMode(mode);
            }
            this.renewed = true;
            ex = true;
        }
        catch (DocumentStoreException e) {
            try {
                dse = e;
                result = e.toString();
            }
            catch (Throwable var16_28) {
                sw.stop();
                msg = "Lease renewal for cluster id {} took {}, resulted in: {}";
                if (sw.elapsed(TimeUnit.SECONDS) > 10L) {
                    ClusterNodeInfo.LOG.warn(msg, new Object[]{this.id, sw, result});
                } else if (sw.elapsed(TimeUnit.SECONDS) > 1L) {
                    ClusterNodeInfo.LOG.info(msg, new Object[]{this.id, sw, result});
                } else if (ClusterNodeInfo.LOG.isDebugEnabled()) {
                    ClusterNodeInfo.LOG.debug(msg, new Object[]{this.id, sw, result});
                }
                throw var16_28;
            }
            sw.stop();
            msg = "Lease renewal for cluster id {} took {}, resulted in: {}";
            if (sw.elapsed(TimeUnit.SECONDS) > 10L) {
                ClusterNodeInfo.LOG.warn(msg, new Object[]{this.id, sw, result});
            } else if (sw.elapsed(TimeUnit.SECONDS) > 1L) {
                ClusterNodeInfo.LOG.info(msg, new Object[]{this.id, sw, result});
            } else if (ClusterNodeInfo.LOG.isDebugEnabled()) {
                ClusterNodeInfo.LOG.debug(msg, new Object[]{this.id, sw, result});
            } else {
                ** GOTO lbl117
            }
        }
        sw.stop();
        msg = "Lease renewal for cluster id {} took {}, resulted in: {}";
        if (sw.elapsed(TimeUnit.SECONDS) > 10L) {
            ClusterNodeInfo.LOG.warn(msg, new Object[]{this.id, sw, result});
        } else if (sw.elapsed(TimeUnit.SECONDS) > 1L) {
            ClusterNodeInfo.LOG.info(msg, new Object[]{this.id, sw, result});
        } else if (ClusterNodeInfo.LOG.isDebugEnabled()) {
            ClusterNodeInfo.LOG.debug(msg, new Object[]{this.id, sw, result});
        }
        return ex;
        while (ClusterNodeInfo.getCurrentTime() < updatedLeaseEndTime) {
            msg = this;
            synchronized (msg) {
                if (this.leaseCheckFailed) {
                    break;
                }
            }
            t1 = ClusterNodeInfo.clock.getTime();
            try {
                doc = this.store.find(Collection.CLUSTER_NODES, String.valueOf(this.id));
            }
            catch (DocumentStoreException e) {
                ClusterNodeInfo.LOG.warn("Reading ClusterNodeInfoDocument for id " + this.id + " failed", (Throwable)e);
                try {
                    ClusterNodeInfo.clock.waitUntil(t1 + 1000L);
                }
                catch (InterruptedException var13_24) {}
                continue;
            }
            if (doc != null) {
                if (!doc.isActive()) {
                    ClusterNodeInfo.LOG.warn("ClusterNodeInfoDocument for id {} is not active anymore. {}", (Object)this.id, (Object)doc);
                    break;
                }
                if (doc.getLeaseEndTime() != this.previousLeaseEndTime && doc.getLeaseEndTime() != updatedLeaseEndTime) break;
                this.previousLeaseEndTime = doc.getLeaseEndTime();
                this.leaseEndTime = doc.getLeaseEndTime();
                break;
            }
            ClusterNodeInfo.LOG.warn("ClusterNodeInfoDocument for id {} does not exist anymore", (Object)this.id);
            break;
        }
        throw dse;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setInfo(Map<String, String> info) {
        ClusterNodeInfo clusterNodeInfo = this;
        synchronized (clusterNodeInfo) {
            UpdateOp update = new UpdateOp("" + this.id, false);
            for (Map.Entry<String, String> e : info.entrySet()) {
                update.set(e.getKey(), e.getValue());
            }
            this.store.findAndUpdate(Collection.CLUSTER_NODES, update);
        }
    }

    void setLeaseTime(long leaseTime) {
        this.leaseTime = leaseTime;
    }

    void setLeaseUpdateInterval(long leaseUpdateInterval) {
        this.leaseUpdateInterval = leaseUpdateInterval;
    }

    public long getLeaseTime() {
        return this.leaseTime;
    }

    public long getLeaseEndTime() {
        return this.leaseEndTime;
    }

    public void setLeaseFailureHandler(LeaseFailureHandler leaseFailureHandler) {
        this.leaseFailureHandler = leaseFailureHandler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        ClusterNodeInfo clusterNodeInfo = this;
        synchronized (clusterNodeInfo) {
            if (this.leaseCheckFailed) {
                LOG.warn("dispose: lease check failed, thus not marking instance as cleanly shut down.");
                return;
            }
        }
        UpdateOp update = new UpdateOp("" + this.id, true);
        update.set(LEASE_END_KEY, null);
        update.set(STATE, null);
        update.set(REV_RECOVERY_LOCK, RecoverLockState.NONE.name());
        this.store.createOrUpdate(Collection.CLUSTER_NODES, update);
    }

    public String toString() {
        return "id: " + this.id + ",\nstartTime: " + this.startTime + ",\nmachineId: " + this.machineId + ",\ninstanceId: " + this.instanceId + ",\npid: " + PROCESS_ID + ",\nuuid: " + this.uuid + ",\nreadWriteMode: " + this.readWriteMode + ",\nstate: " + (Object)((Object)this.state) + ",\nrevLock: " + (Object)((Object)this.revRecoveryLock) + ",\noakVersion: " + OAK_VERSION + ",\nformatVersion: " + DocumentNodeStore.VERSION;
    }

    static void setClock(Clock c) {
        Preconditions.checkNotNull((Object)c);
        clock = c;
    }

    static void resetClockToDefault() {
        clock = Clock.SIMPLE;
    }

    private static long getProcessId() {
        try {
            String name = ManagementFactory.getRuntimeMXBean().getName();
            return Long.parseLong(name.substring(0, name.indexOf(64)));
        }
        catch (Exception e) {
            LOG.warn("Could not get process id", (Throwable)e);
            return 0L;
        }
    }

    private static String getHWAFromSystemProperty() {
        String pname = ClusterNodeInfo.class.getName() + ".HWADDRESS";
        String hwa = System.getProperty(pname, "");
        if (!"".equals(hwa)) {
            LOG.debug("obtaining hardware address from system variable " + pname + ": " + hwa);
        }
        return hwa;
    }

    private static String getMachineId() {
        Exception exception = null;
        try {
            ArrayList<String> macAddresses = new ArrayList<String>();
            ArrayList<String> likelyVirtualMacAddresses = new ArrayList<String>();
            ArrayList<String> otherAddresses = new ArrayList<String>();
            String hwaFromSysProp = ClusterNodeInfo.getHWAFromSystemProperty();
            if ("".equals(hwaFromSysProp)) {
                Enumeration<NetworkInterface> e = NetworkInterface.getNetworkInterfaces();
                while (e.hasMoreElements()) {
                    NetworkInterface ni = e.nextElement();
                    try {
                        byte[] hwa = ni.getHardwareAddress();
                        if (hwa == null || hwa.length == 0) continue;
                        String str = StringUtils.convertBytesToHex((byte[])hwa);
                        if (hwa.length == 6) {
                            boolean looksVirtual;
                            String displayName = ni.getDisplayName().toLowerCase(Locale.ENGLISH);
                            boolean bl = looksVirtual = displayName.indexOf("virtual") >= 0 || displayName.indexOf("vpn") >= 0;
                            if (!looksVirtual) {
                                macAddresses.add(str);
                                continue;
                            }
                            likelyVirtualMacAddresses.add(str);
                            continue;
                        }
                        otherAddresses.add(str);
                    }
                    catch (Exception e2) {
                        exception = e2;
                    }
                }
            } else if (!"(none)".equals(hwaFromSysProp)) {
                if (hwaFromSysProp.length() == 12) {
                    macAddresses.add(hwaFromSysProp);
                } else {
                    otherAddresses.add(hwaFromSysProp);
                }
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("getMachineId(): discovered addresses: {} {} {}", new Object[]{macAddresses, likelyVirtualMacAddresses, otherAddresses});
            }
            if (macAddresses.size() > 0) {
                Collections.sort(macAddresses);
                return "mac:" + (String)macAddresses.get(0);
            }
            if (likelyVirtualMacAddresses.size() > 0) {
                Collections.sort(likelyVirtualMacAddresses);
                return "mac:" + (String)likelyVirtualMacAddresses.get(0);
            }
            if (otherAddresses.size() > 0) {
                Collections.sort(otherAddresses);
                return "hwa:" + (String)otherAddresses.get(0);
            }
        }
        catch (Exception e) {
            exception = e;
        }
        if (exception != null) {
            LOG.warn("Error getting the machine id; using a UUID", (Throwable)exception);
        }
        return RANDOM_PREFIX + UUID.randomUUID().toString();
    }

    private static long getCurrentTime() {
        return clock.getTime();
    }

    private static DocumentStoreException leaseExpired(String msg, boolean log) {
        if (log) {
            LOG.error(msg);
        }
        return new DocumentStoreException(msg);
    }

    static {
        String leaseDurationProp = "oak.documentMK.leaseDurationSeconds";
        Integer leaseProp = Integer.getInteger(leaseDurationProp);
        if (leaseProp != null) {
            LOG.info("Lease duration set to: " + leaseProp + "s (using system property " + leaseDurationProp + ")");
        }
        DEFAULT_LEASE_DURATION_MILLIS = 1000 * (leaseProp != null ? leaseProp : 120);
        DEFAULT_LEASE_CHECK_DISABLED = Boolean.valueOf(System.getProperty("oak.documentMK.disableLeaseCheck", "false"));
        OAK_VERSION = Utils.getModuleVersion();
    }

    public static enum RecoverLockState {
        NONE,
        ACQUIRED;


        static RecoverLockState fromString(String state) {
            if (state == null) {
                return NONE;
            }
            return RecoverLockState.valueOf(state);
        }
    }

    public static enum ClusterNodeState {
        NONE,
        ACTIVE;


        static ClusterNodeState fromString(String state) {
            if (state == null) {
                return NONE;
            }
            return ClusterNodeState.valueOf(state);
        }
    }
}

