/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.segment.tool;

import com.google.common.base.Preconditions;
import java.io.File;
import java.util.Iterator;
import org.apache.jackrabbit.oak.segment.file.tooling.RevisionHistory;

public class History {
    private final File path;
    private final File journal;
    private final String node;
    private final int depth;

    public static Builder builder() {
        return new Builder();
    }

    private History(Builder builder) {
        this.path = builder.path;
        this.journal = builder.journal;
        this.node = builder.node;
        this.depth = builder.depth;
    }

    public int run() {
        try {
            this.run(new RevisionHistory(this.path).getHistory(this.journal, this.node));
            return 0;
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
            return 1;
        }
    }

    private void run(Iterator<RevisionHistory.HistoryElement> history) {
        while (history.hasNext()) {
            System.out.println(history.next().toString(this.depth));
        }
    }

    public static class Builder {
        private File path;
        private File journal;
        private String node;
        private int depth;

        private Builder() {
        }

        public Builder withPath(File path) {
            this.path = (File)Preconditions.checkNotNull((Object)path);
            return this;
        }

        public Builder withJournal(File journal) {
            this.journal = (File)Preconditions.checkNotNull((Object)journal);
            return this;
        }

        public Builder withNode(String node) {
            this.node = (String)Preconditions.checkNotNull((Object)node);
            return this;
        }

        public Builder withDepth(int depth) {
            Preconditions.checkArgument((depth >= 0 ? 1 : 0) != 0);
            this.depth = depth;
            return this;
        }

        public History build() {
            Preconditions.checkNotNull((Object)this.path);
            Preconditions.checkNotNull((Object)this.journal);
            Preconditions.checkNotNull((Object)this.node);
            return new History(this);
        }
    }
}

