/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.segment.tool;

import com.google.common.base.Preconditions;
import java.io.File;
import java.io.PrintWriter;
import java.util.Set;
import org.apache.jackrabbit.oak.segment.file.tooling.ConsistencyChecker;

public class Check {
    private final File path;
    private final String journal;
    private final long debugInterval;
    private final boolean checkBinaries;
    private final boolean checkHead;
    private final Set<String> checkpoints;
    private final Set<String> filterPaths;
    private final boolean ioStatistics;
    private final PrintWriter outWriter;
    private final PrintWriter errWriter;

    public static Builder builder() {
        return new Builder();
    }

    private Check(Builder builder) {
        this.path = builder.path;
        this.journal = builder.journal;
        this.debugInterval = builder.debugInterval;
        this.checkHead = builder.checkHead;
        this.checkBinaries = builder.checkBinaries;
        this.checkpoints = builder.checkpoints;
        this.filterPaths = builder.filterPaths;
        this.ioStatistics = builder.ioStatistics;
        this.outWriter = builder.outWriter;
        this.errWriter = builder.errWriter;
    }

    public int run() {
        try {
            ConsistencyChecker.checkConsistency(this.path, this.journal, this.debugInterval, this.checkBinaries, this.checkHead, this.checkpoints, this.filterPaths, this.ioStatistics, this.outWriter, this.errWriter);
            return 0;
        }
        catch (Exception e) {
            e.printStackTrace(this.errWriter);
            return 1;
        }
    }

    public static class Builder {
        private File path;
        private String journal;
        private long debugInterval = Long.MAX_VALUE;
        private boolean checkBinaries;
        private boolean checkHead;
        private Set<String> checkpoints;
        private Set<String> filterPaths;
        private boolean ioStatistics;
        private PrintWriter outWriter;
        private PrintWriter errWriter;

        private Builder() {
        }

        public Builder withPath(File path) {
            this.path = (File)Preconditions.checkNotNull((Object)path);
            return this;
        }

        public Builder withJournal(String journal) {
            this.journal = (String)Preconditions.checkNotNull((Object)journal);
            return this;
        }

        public Builder withDebugInterval(long debugInterval) {
            Preconditions.checkArgument((debugInterval >= 0L ? 1 : 0) != 0);
            this.debugInterval = debugInterval;
            return this;
        }

        public Builder withCheckBinaries(boolean checkBinaries) {
            this.checkBinaries = checkBinaries;
            return this;
        }

        public Builder withCheckHead(boolean checkHead) {
            this.checkHead = checkHead;
            return this;
        }

        public Builder withCheckpoints(Set<String> checkpoints) {
            this.checkpoints = checkpoints;
            return this;
        }

        public Builder withFilterPaths(Set<String> filterPaths) {
            this.filterPaths = filterPaths;
            return this;
        }

        public Builder withIOStatistics(boolean ioStatistics) {
            this.ioStatistics = ioStatistics;
            return this;
        }

        public Builder withOutWriter(PrintWriter outWriter) {
            this.outWriter = outWriter;
            return this;
        }

        public Builder withErrWriter(PrintWriter errWriter) {
            this.errWriter = errWriter;
            return this;
        }

        public Check build() {
            Preconditions.checkNotNull((Object)this.path);
            Preconditions.checkNotNull((Object)this.journal);
            return new Check(this);
        }
    }
}

