/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.segment.standby.server;

import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.SocketChannel;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import io.netty.handler.codec.LineBasedFrameDecoder;
import io.netty.handler.codec.compression.SnappyFrameEncoder;
import io.netty.handler.codec.string.StringDecoder;
import io.netty.handler.ssl.SslContext;
import io.netty.handler.ssl.SslContextBuilder;
import io.netty.handler.ssl.util.SelfSignedCertificate;
import io.netty.handler.stream.ChunkedWriteHandler;
import io.netty.util.CharsetUtil;
import java.io.File;
import java.security.cert.CertificateException;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.SSLException;
import org.apache.jackrabbit.core.data.util.NamedThreadFactory;
import org.apache.jackrabbit.oak.segment.file.FileStore;
import org.apache.jackrabbit.oak.segment.standby.codec.GetBlobResponseEncoder;
import org.apache.jackrabbit.oak.segment.standby.codec.GetHeadResponseEncoder;
import org.apache.jackrabbit.oak.segment.standby.codec.GetReferencesResponseEncoder;
import org.apache.jackrabbit.oak.segment.standby.codec.GetSegmentResponseEncoder;
import org.apache.jackrabbit.oak.segment.standby.codec.RequestDecoder;
import org.apache.jackrabbit.oak.segment.standby.server.ClientFilterHandler;
import org.apache.jackrabbit.oak.segment.standby.server.ClientIpFilter;
import org.apache.jackrabbit.oak.segment.standby.server.DefaultStandbyBlobReader;
import org.apache.jackrabbit.oak.segment.standby.server.DefaultStandbyHeadReader;
import org.apache.jackrabbit.oak.segment.standby.server.DefaultStandbyReferencesReader;
import org.apache.jackrabbit.oak.segment.standby.server.DefaultStandbySegmentReader;
import org.apache.jackrabbit.oak.segment.standby.server.ExceptionHandler;
import org.apache.jackrabbit.oak.segment.standby.server.GetBlobRequestHandler;
import org.apache.jackrabbit.oak.segment.standby.server.GetHeadRequestHandler;
import org.apache.jackrabbit.oak.segment.standby.server.GetReferencesRequestHandler;
import org.apache.jackrabbit.oak.segment.standby.server.GetSegmentRequestHandler;
import org.apache.jackrabbit.oak.segment.standby.server.RequestObserverHandler;
import org.apache.jackrabbit.oak.segment.standby.server.ResponseObserverHandler;
import org.apache.jackrabbit.oak.segment.standby.server.StateConsumer;
import org.apache.jackrabbit.oak.segment.standby.server.StateHandler;
import org.apache.jackrabbit.oak.segment.standby.server.StoreProvider;
import org.apache.jackrabbit.oak.segment.standby.store.CommunicationObserver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class StandbyServer
implements AutoCloseable {
    private static final Logger log = LoggerFactory.getLogger(StandbyServer.class);
    static final long READ_HEAD_TIMEOUT = Long.getLong("standby.server.timeout", 10000L);
    private final int port;
    private final EventLoopGroup bossGroup;
    private final EventLoopGroup workerGroup;
    private final ServerBootstrap b;
    private SslContext sslContext;
    private ChannelFuture channelFuture;

    static Builder builder(int port, StoreProvider provider, int blobChunkSize) {
        return new Builder(port, provider, blobChunkSize);
    }

    private StandbyServer(final Builder builder) throws CertificateException, SSLException {
        this.port = builder.port;
        if (builder.secure) {
            SelfSignedCertificate ssc = new SelfSignedCertificate();
            this.sslContext = SslContextBuilder.forServer((File)ssc.certificate(), (File)ssc.privateKey()).build();
        }
        this.bossGroup = new NioEventLoopGroup(1, (ThreadFactory)new NamedThreadFactory("primary-run"));
        this.workerGroup = new NioEventLoopGroup(0, (ThreadFactory)new NamedThreadFactory("primary"));
        this.b = new ServerBootstrap();
        this.b.group(this.bossGroup, this.workerGroup);
        this.b.channel(NioServerSocketChannel.class);
        this.b.option(ChannelOption.SO_REUSEADDR, (Object)true);
        this.b.childOption(ChannelOption.TCP_NODELAY, (Object)true);
        this.b.childOption(ChannelOption.SO_REUSEADDR, (Object)true);
        this.b.childOption(ChannelOption.SO_KEEPALIVE, (Object)true);
        this.b.childHandler((ChannelHandler)new ChannelInitializer<SocketChannel>(){

            public void initChannel(SocketChannel ch) throws Exception {
                ChannelPipeline p = ch.pipeline();
                p.addLast(new ChannelHandler[]{new ClientFilterHandler(new ClientIpFilter(builder.allowedClientIPRanges))});
                if (StandbyServer.this.sslContext != null) {
                    p.addLast("ssl", (ChannelHandler)StandbyServer.this.sslContext.newHandler(ch.alloc()));
                }
                p.addLast(new ChannelHandler[]{new LineBasedFrameDecoder(8192)});
                p.addLast(new ChannelHandler[]{new StringDecoder(CharsetUtil.UTF_8)});
                p.addLast(new ChannelHandler[]{new RequestDecoder()});
                p.addLast(new ChannelHandler[]{new StateHandler(builder.stateConsumer)});
                p.addLast(new ChannelHandler[]{new RequestObserverHandler(builder.observer)});
                p.addLast(new ChannelHandler[]{new SnappyFrameEncoder()});
                p.addLast(new ChannelHandler[]{new ChunkedWriteHandler()});
                p.addLast(new ChannelHandler[]{new GetHeadResponseEncoder()});
                p.addLast(new ChannelHandler[]{new GetSegmentResponseEncoder()});
                p.addLast(new ChannelHandler[]{new GetBlobResponseEncoder(builder.blobChunkSize)});
                p.addLast(new ChannelHandler[]{new GetReferencesResponseEncoder()});
                p.addLast(new ChannelHandler[]{new ResponseObserverHandler(builder.observer)});
                FileStore store = builder.storeProvider.provideStore();
                p.addLast(new ChannelHandler[]{new GetHeadRequestHandler(new DefaultStandbyHeadReader(store, READ_HEAD_TIMEOUT))});
                p.addLast(new ChannelHandler[]{new GetSegmentRequestHandler(new DefaultStandbySegmentReader(store))});
                p.addLast(new ChannelHandler[]{new GetBlobRequestHandler(new DefaultStandbyBlobReader(store.getBlobStore()))});
                p.addLast(new ChannelHandler[]{new GetReferencesRequestHandler(new DefaultStandbyReferencesReader(store))});
                p.addLast(new ChannelHandler[]{new ExceptionHandler()});
            }
        });
    }

    public void start() {
        this.channelFuture = this.b.bind(this.port);
        if (this.channelFuture.awaitUninterruptibly(1L, TimeUnit.SECONDS)) {
            this.onTimelyConnect();
        } else {
            this.onConnectTimeOut();
        }
    }

    public void stop() {
        if (this.channelFuture == null) {
            return;
        }
        if (this.channelFuture.channel().disconnect().awaitUninterruptibly(1L, TimeUnit.SECONDS)) {
            log.debug("Channel disconnected");
        } else {
            log.debug("Channel disconnect timed out");
        }
    }

    @Override
    public void close() {
        this.stop();
        if (StandbyServer.shutDown(this.bossGroup)) {
            log.debug("Boss group shut down");
        } else {
            log.debug("Boss group shutdown timed out");
        }
        if (StandbyServer.shutDown(this.workerGroup)) {
            log.debug("Worker group shut down");
        } else {
            log.debug("Worker group shutdown timed out");
        }
    }

    private static boolean shutDown(EventLoopGroup group) {
        return group.shutdownGracefully(0L, 5L, TimeUnit.SECONDS).awaitUninterruptibly(10L, TimeUnit.SECONDS);
    }

    private void onTimelyConnect() {
        if (this.channelFuture.isSuccess()) {
            log.debug("Binding was successful");
        }
        if (this.channelFuture.cause() != null) {
            throw new RuntimeException(this.channelFuture.cause());
        }
    }

    private void onConnectTimeOut() {
        log.debug("Binding timed out, canceling");
        this.channelFuture.cancel(true);
    }

    static class Builder {
        private final int port;
        private final StoreProvider storeProvider;
        private final int blobChunkSize;
        private boolean secure;
        private String[] allowedClientIPRanges;
        private StateConsumer stateConsumer;
        private CommunicationObserver observer;

        private Builder(int port, StoreProvider storeProvider, int blobChunkSize) {
            this.port = port;
            this.storeProvider = storeProvider;
            this.blobChunkSize = blobChunkSize;
        }

        Builder secure(boolean secure) {
            this.secure = secure;
            return this;
        }

        Builder allowIPRanges(String[] allowedClientIPRanges) {
            this.allowedClientIPRanges = allowedClientIPRanges;
            return this;
        }

        Builder withStateConsumer(StateConsumer stateConsumer) {
            this.stateConsumer = stateConsumer;
            return this;
        }

        Builder withObserver(CommunicationObserver observer) {
            this.observer = observer;
            return this;
        }

        StandbyServer build() throws CertificateException, SSLException {
            return new StandbyServer(this);
        }
    }
}

