/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.segment.standby.client;

import com.google.common.base.Supplier;
import java.io.IOException;
import java.io.InputStream;
import org.apache.jackrabbit.oak.api.Blob;
import org.apache.jackrabbit.oak.api.PropertyState;
import org.apache.jackrabbit.oak.api.Type;
import org.apache.jackrabbit.oak.plugins.memory.EmptyNodeState;
import org.apache.jackrabbit.oak.segment.CancelableDiff;
import org.apache.jackrabbit.oak.segment.SegmentBlob;
import org.apache.jackrabbit.oak.segment.SegmentNodeState;
import org.apache.jackrabbit.oak.segment.file.FileStore;
import org.apache.jackrabbit.oak.segment.standby.client.StandbyClient;
import org.apache.jackrabbit.oak.spi.blob.BlobStore;
import org.apache.jackrabbit.oak.spi.state.NodeBuilder;
import org.apache.jackrabbit.oak.spi.state.NodeState;
import org.apache.jackrabbit.oak.spi.state.NodeStateDiff;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class StandbyDiff
implements NodeStateDiff {
    private static final Logger log = LoggerFactory.getLogger(StandbyDiff.class);
    private final NodeBuilder builder;
    private final FileStore store;
    private final StandbyClient client;
    private final boolean hasDataStore;
    private final String path;
    private final Supplier<Boolean> running;

    StandbyDiff(NodeBuilder builder, FileStore store, StandbyClient client, Supplier<Boolean> running) {
        this(builder, store, client, "/", running);
    }

    private StandbyDiff(NodeBuilder builder, FileStore store, StandbyClient client, String path, Supplier<Boolean> running) {
        this.builder = builder;
        this.store = store;
        this.hasDataStore = store.getBlobStore() != null;
        this.client = client;
        this.path = path;
        this.running = running;
    }

    public boolean propertyAdded(PropertyState after) {
        this.builder.setProperty(after);
        return true;
    }

    public boolean propertyChanged(PropertyState before, PropertyState after) {
        this.builder.setProperty(after);
        return true;
    }

    public boolean propertyDeleted(PropertyState before) {
        this.builder.removeProperty(before.getName());
        return true;
    }

    public boolean childNodeAdded(String name, NodeState after) {
        SegmentNodeState processed = this.process(name, EmptyNodeState.EMPTY_NODE, after, EmptyNodeState.EMPTY_NODE.builder());
        if (processed != null) {
            this.builder.setChildNode(name, (NodeState)processed);
            return true;
        }
        return false;
    }

    public boolean childNodeChanged(String name, NodeState before, NodeState after) {
        SegmentNodeState processed = this.process(name, before, after, this.builder.getChildNode(name));
        if (processed != null) {
            this.builder.setChildNode(name, (NodeState)processed);
            return true;
        }
        return false;
    }

    public boolean childNodeDeleted(String name, NodeState before) {
        this.builder.getChildNode(name).remove();
        return true;
    }

    public SegmentNodeState process(String name, NodeState before, NodeState after, NodeBuilder onto) {
        return new StandbyDiff(onto, this.store, this.client, this.path + name + "/", this.running).diff(name, before, after);
    }

    SegmentNodeState diff(String name, NodeState before, NodeState after) {
        if (after instanceof SegmentNodeState) {
            if ("checkpoints".equals(name)) {
                return (SegmentNodeState)after;
            }
            if (!this.hasDataStore) {
                return (SegmentNodeState)after;
            }
            for (PropertyState propertyState : after.getProperties()) {
                this.fetchBinary(propertyState);
            }
            boolean success = after.compareAgainstBaseState(before, (NodeStateDiff)new CancelableDiff(this, this.newCanceledSupplier()));
            if (success) {
                return (SegmentNodeState)after;
            }
            return null;
        }
        return null;
    }

    private Supplier<Boolean> newCanceledSupplier() {
        return new Supplier<Boolean>(){

            public Boolean get() {
                return (Boolean)StandbyDiff.this.running.get() == false;
            }
        };
    }

    private PropertyState fetchBinary(PropertyState property) {
        Type type = property.getType();
        if (type == Type.BINARY) {
            this.fetchBinary((Blob)property.getValue(Type.BINARY), property.getName());
        } else if (type == Type.BINARIES) {
            for (Blob blob : (Iterable)property.getValue(Type.BINARIES)) {
                this.fetchBinary(blob, property.getName());
            }
        }
        return property;
    }

    private void fetchBinary(Blob b, String pName) {
        if (b instanceof SegmentBlob) {
            this.fetchBinary((SegmentBlob)b, pName);
        } else {
            log.warn("Unknown Blob {} at {}, ignoring", (Object)b.getClass().getName(), (Object)(this.path + "#" + pName));
        }
    }

    private void fetchBinary(SegmentBlob sb, String pName) {
        if (sb.isExternal() && this.hasDataStore && sb.getReference() == null) {
            String blobId = sb.getBlobId();
            if (blobId == null) {
                return;
            }
            try {
                this.fetchAndStoreBlob(blobId, pName);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
    }

    private void fetchAndStoreBlob(String blobId, String pName) throws InterruptedException {
        InputStream in = this.client.getBlob(blobId);
        if (in == null) {
            throw new IllegalStateException("Unable to load remote blob " + blobId + " at " + this.path + "#" + pName + " in " + this.client.getReadTimeoutMs() + "ms. Please increase the timeout and try again.");
        }
        try {
            BlobStore blobStore = this.store.getBlobStore();
            assert (blobStore != null) : "Blob store must not be null";
            blobStore.writeBlob(in);
            in.close();
        }
        catch (IOException f) {
            throw new IllegalStateException("Unable to persist blob " + blobId + " at " + this.path + "#" + pName, f);
        }
    }
}

