/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.segment.scheduler;

import com.codahale.metrics.Histogram;
import com.codahale.metrics.Reservoir;
import com.codahale.metrics.UniformReservoir;
import com.google.common.base.Preconditions;
import java.io.Closeable;
import java.text.MessageFormat;
import java.util.Map;
import java.util.Random;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.Nonnull;
import org.apache.jackrabbit.oak.api.CommitFailedException;
import org.apache.jackrabbit.oak.api.PropertyState;
import org.apache.jackrabbit.oak.api.Type;
import org.apache.jackrabbit.oak.segment.Revisions;
import org.apache.jackrabbit.oak.segment.SegmentNodeBuilder;
import org.apache.jackrabbit.oak.segment.SegmentNodeState;
import org.apache.jackrabbit.oak.segment.SegmentNodeStoreStats;
import org.apache.jackrabbit.oak.segment.SegmentOverflowException;
import org.apache.jackrabbit.oak.segment.SegmentReader;
import org.apache.jackrabbit.oak.segment.scheduler.Commit;
import org.apache.jackrabbit.oak.segment.scheduler.Scheduler;
import org.apache.jackrabbit.oak.spi.commit.ChangeDispatcher;
import org.apache.jackrabbit.oak.spi.commit.CommitInfo;
import org.apache.jackrabbit.oak.spi.commit.Observable;
import org.apache.jackrabbit.oak.spi.commit.Observer;
import org.apache.jackrabbit.oak.spi.state.NodeBuilder;
import org.apache.jackrabbit.oak.spi.state.NodeState;
import org.apache.jackrabbit.oak.stats.StatisticsProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LockBasedScheduler
implements Scheduler {
    private static final Logger log = LoggerFactory.getLogger(LockBasedScheduler.class);
    private static final boolean COMMIT_FAIR_LOCK = Boolean.parseBoolean(System.getProperty("oak.segmentNodeStore.commitFairLock", "true"));
    private static final double SCHEDULER_FETCH_COMMIT_DELAY_QUANTILE = Double.parseDouble(System.getProperty("oak.scheduler.fetch.commitDelayQuantile", "0.5"));
    private static final long MAXIMUM_BACKOFF = TimeUnit.MILLISECONDS.convert(10L, TimeUnit.SECONDS);
    private final int checkpointsLockWaitTime = Integer.getInteger("oak.checkpoints.lockWaitTime", 10);
    static final String ROOT = "root";
    private final Semaphore commitSemaphore = new Semaphore(1, COMMIT_FAIR_LOCK);
    @Nonnull
    private final SegmentReader reader;
    @Nonnull
    private final Revisions revisions;
    protected final AtomicReference<SegmentNodeState> head;
    private final SegmentNodeStoreStats stats;
    private final Histogram commitTimeHistogram = new Histogram((Reservoir)new UniformReservoir());
    private final Random random = new Random();

    public static LockBasedSchedulerBuilder builder(@Nonnull Revisions revisions, @Nonnull SegmentReader reader) {
        return new LockBasedSchedulerBuilder((Revisions)Preconditions.checkNotNull((Object)revisions), (SegmentReader)Preconditions.checkNotNull((Object)reader));
    }

    public LockBasedScheduler(LockBasedSchedulerBuilder builder) {
        if (COMMIT_FAIR_LOCK) {
            log.info("Initializing SegmentNodeStore with the commitFairLock option enabled.");
        }
        this.reader = builder.reader;
        this.revisions = builder.revisions;
        this.head = new AtomicReference<SegmentNodeState>(this.reader.readHeadState(this.revisions));
        this.stats = new SegmentNodeStoreStats(builder.statsProvider);
    }

    @Override
    public NodeState getHeadNodeState() {
        block5: {
            long delay = (long)this.commitTimeHistogram.getSnapshot().getValue(SCHEDULER_FETCH_COMMIT_DELAY_QUANTILE);
            try {
                if (!this.commitSemaphore.tryAcquire(delay, TimeUnit.NANOSECONDS)) break block5;
                try {
                    this.refreshHead(true);
                }
                finally {
                    this.commitSemaphore.release();
                }
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
        return this.head.get();
    }

    private void refreshHead(boolean dispatchChanges) {
        SegmentNodeState state = this.reader.readHeadState(this.revisions);
        if (!state.getRecordId().equals(this.head.get().getRecordId())) {
            this.head.set(state);
            if (dispatchChanges) {
                this.contentChanged(state.getChildNode(ROOT), CommitInfo.EMPTY_EXTERNAL);
            }
        }
    }

    protected void contentChanged(NodeState root, CommitInfo info) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public NodeState schedule(@Nonnull Commit commit, Scheduler.SchedulerOption ... schedulingOptions) throws CommitFailedException {
        boolean queued = false;
        long queuedTime = -1L;
        if (this.commitSemaphore.availablePermits() < 1) {
            queuedTime = System.nanoTime();
            this.stats.onCommitQueued();
            queued = true;
        }
        this.commitSemaphore.acquire();
        try {
            if (queued) {
                long dequeuedTime = System.nanoTime();
                this.stats.dequeuedAfter(dequeuedTime - queuedTime);
                this.stats.onCommitDequeued();
            }
            long beforeCommitTime = System.nanoTime();
            SegmentNodeState merged = (SegmentNodeState)this.execute(commit);
            commit.applied(merged);
            long afterCommitTime = System.nanoTime();
            this.stats.committedAfter(afterCommitTime - beforeCommitTime);
            this.commitTimeHistogram.update(afterCommitTime - beforeCommitTime);
            this.stats.onCommit();
            SegmentNodeState segmentNodeState = merged;
            this.commitSemaphore.release();
            return segmentNodeState;
        }
        catch (Throwable throwable) {
            try {
                this.commitSemaphore.release();
                throw throwable;
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new CommitFailedException("Segment", 2, "Merge interrupted", (Throwable)e);
            }
            catch (SegmentOverflowException e) {
                throw new CommitFailedException("Segment", 3, "Merge failed", (Throwable)e);
            }
        }
    }

    private NodeState execute(Commit commit) throws CommitFailedException, InterruptedException {
        if (commit.hasChanges()) {
            long start = System.nanoTime();
            int count = 0;
            for (long backoff = 1L; backoff < MAXIMUM_BACKOFF; backoff *= 2L) {
                this.refreshHead(true);
                SegmentNodeState before = this.head.get();
                SegmentNodeState after = commit.apply(before);
                if (this.revisions.setHead(before.getRecordId(), after.getRecordId(), new Revisions.Option[0])) {
                    this.head.set(after);
                    this.contentChanged(after.getChildNode(ROOT), commit.info());
                    return this.head.get().getChildNode(ROOT);
                }
                ++count;
                int randNs = this.random.nextInt(1000000);
                log.info("Scheduler detected concurrent commits. Retrying after {} ms and {} ns", (Object)backoff, (Object)randNs);
                Thread.sleep(backoff, randNs);
            }
            long finish = System.nanoTime();
            String message = MessageFormat.format("The commit could not be executed after {} attempts. Total wait time: {} ms", count, TimeUnit.NANOSECONDS.toMillis(finish - start));
            throw new CommitFailedException("Segment", 3, message);
        }
        return this.head.get().getChildNode(ROOT);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public String checkpoint(long lifetime, @Nonnull Map<String, String> properties) {
        Preconditions.checkArgument((lifetime > 0L ? 1 : 0) != 0);
        Preconditions.checkNotNull(properties);
        String name = UUID.randomUUID().toString();
        try {
            CPCreator cpc = new CPCreator(name, lifetime, properties);
            if (this.commitSemaphore.tryAcquire(this.checkpointsLockWaitTime, TimeUnit.SECONDS)) {
                try {
                    if (cpc.call().booleanValue()) {
                        String string = name;
                        return string;
                    }
                }
                finally {
                    this.refreshHead(true);
                    this.commitSemaphore.release();
                }
            }
            log.warn("Failed to create checkpoint {} in {} seconds.", (Object)name, (Object)this.checkpointsLockWaitTime);
            return name;
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            log.error("Failed to create checkpoint {}.", (Object)name, (Object)e);
            return name;
        }
        catch (Exception e) {
            log.error("Failed to create checkpoint {}.", (Object)name, (Object)e);
        }
        return name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean removeCheckpoint(String name) {
        Preconditions.checkNotNull((Object)name);
        for (int i = 0; i < 5; ++i) {
            if (!this.commitSemaphore.tryAcquire()) continue;
            try {
                this.refreshHead(true);
                SegmentNodeState state = this.head.get();
                SegmentNodeBuilder builder = state.builder();
                NodeBuilder cp = builder.child("checkpoints").child(name);
                if (!cp.exists()) continue;
                cp.remove();
                SegmentNodeState newState = builder.getNodeState();
                if (!this.revisions.setHead(state.getRecordId(), newState.getRecordId(), new Revisions.Option[0])) continue;
                this.refreshHead(false);
                boolean bl = true;
                return bl;
            }
            finally {
                this.commitSemaphore.release();
            }
        }
        return false;
    }

    private final class CPCreator
    implements Callable<Boolean> {
        private final String name;
        private final long lifetime;
        private final Map<String, String> properties;

        CPCreator(String name, long lifetime, Map<String, String> properties) {
            this.name = name;
            this.lifetime = lifetime;
            this.properties = properties;
        }

        @Override
        public Boolean call() {
            long now = System.currentTimeMillis();
            LockBasedScheduler.this.refreshHead(true);
            SegmentNodeState state = LockBasedScheduler.this.head.get();
            SegmentNodeBuilder builder = state.builder();
            NodeBuilder checkpoints = builder.child("checkpoints");
            for (String n : checkpoints.getChildNodeNames()) {
                NodeBuilder cp = checkpoints.getChildNode(n);
                PropertyState propertyState = cp.getProperty("timestamp");
                if (propertyState != null && propertyState.getType() == Type.LONG && now <= (Long)propertyState.getValue(Type.LONG)) continue;
                cp.remove();
            }
            NodeBuilder cp = checkpoints.child(this.name);
            if (Long.MAX_VALUE - now > this.lifetime) {
                cp.setProperty("timestamp", (Object)(now + this.lifetime));
            } else {
                cp.setProperty("timestamp", (Object)Long.MAX_VALUE);
            }
            cp.setProperty("created", (Object)now);
            NodeBuilder props = cp.setChildNode("properties");
            for (Map.Entry entry : this.properties.entrySet()) {
                props.setProperty((String)entry.getKey(), entry.getValue());
            }
            cp.setChildNode(LockBasedScheduler.ROOT, state.getChildNode(LockBasedScheduler.ROOT));
            SegmentNodeState newState = builder.getNodeState();
            if (LockBasedScheduler.this.revisions.setHead(state.getRecordId(), newState.getRecordId(), new Revisions.Option[0])) {
                LockBasedScheduler.this.refreshHead(false);
                return true;
            }
            return false;
        }
    }

    private static class ObservableLockBasedScheduler
    extends LockBasedScheduler
    implements Observable {
        private final ChangeDispatcher changeDispatcher;

        public ObservableLockBasedScheduler(LockBasedSchedulerBuilder builder) {
            super(builder);
            this.changeDispatcher = new ChangeDispatcher(((SegmentNodeState)this.head.get()).getChildNode(LockBasedScheduler.ROOT));
        }

        @Override
        protected void contentChanged(NodeState root, CommitInfo info) {
            this.changeDispatcher.contentChanged(root, info);
        }

        public Closeable addObserver(Observer observer) {
            return this.changeDispatcher.addObserver(observer);
        }
    }

    public static class LockBasedSchedulerBuilder {
        @Nonnull
        private final SegmentReader reader;
        @Nonnull
        private final Revisions revisions;
        @Nonnull
        private StatisticsProvider statsProvider = StatisticsProvider.NOOP;
        private boolean dispatchChanges = true;

        private LockBasedSchedulerBuilder(@Nonnull Revisions revisions, @Nonnull SegmentReader reader) {
            this.revisions = revisions;
            this.reader = reader;
        }

        @Nonnull
        public LockBasedSchedulerBuilder withStatisticsProvider(@Nonnull StatisticsProvider statisticsProvider) {
            this.statsProvider = (StatisticsProvider)Preconditions.checkNotNull((Object)statisticsProvider);
            return this;
        }

        @Nonnull
        public LockBasedSchedulerBuilder dispatchChanges(boolean dispatchChanges) {
            this.dispatchChanges = dispatchChanges;
            return this;
        }

        @Nonnull
        public LockBasedScheduler build() {
            if (this.dispatchChanges) {
                return new ObservableLockBasedScheduler(this);
            }
            return new LockBasedScheduler(this);
        }
    }
}

