/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.segment.scheduler;

import com.google.common.base.Preconditions;
import javax.annotation.Nonnull;
import org.apache.jackrabbit.oak.api.CommitFailedException;
import org.apache.jackrabbit.oak.segment.SegmentNodeBuilder;
import org.apache.jackrabbit.oak.segment.SegmentNodeState;
import org.apache.jackrabbit.oak.spi.commit.CommitHook;
import org.apache.jackrabbit.oak.spi.commit.CommitInfo;
import org.apache.jackrabbit.oak.spi.state.ConflictAnnotatingRebaseDiff;
import org.apache.jackrabbit.oak.spi.state.NodeBuilder;
import org.apache.jackrabbit.oak.spi.state.NodeState;
import org.apache.jackrabbit.oak.spi.state.NodeStateDiff;

public class Commit {
    static final String ROOT = "root";
    private final SegmentNodeBuilder changes;
    private final CommitHook hook;
    private final CommitInfo info;

    public Commit(@Nonnull NodeBuilder changes, @Nonnull CommitHook hook, @Nonnull CommitInfo info) {
        Preconditions.checkNotNull((Object)changes);
        Preconditions.checkArgument((boolean)(changes instanceof SegmentNodeBuilder));
        this.changes = (SegmentNodeBuilder)changes;
        this.hook = (CommitHook)Preconditions.checkNotNull((Object)hook);
        this.info = (CommitInfo)Preconditions.checkNotNull((Object)info);
    }

    public SegmentNodeState apply(SegmentNodeState base) throws CommitFailedException {
        SegmentNodeBuilder builder = base.builder();
        if (SegmentNodeState.fastEquals(this.changes.getBaseState(), base.getChildNode(ROOT))) {
            NodeState before = this.changes.getBaseState();
            SegmentNodeState after = this.changes.getNodeState();
            builder.setChildNode(ROOT, this.hook.processCommit(before, (NodeState)after, this.info));
        } else {
            ConflictAnnotatingRebaseDiff diff = new ConflictAnnotatingRebaseDiff(builder.child(ROOT));
            this.changes.getNodeState().compareAgainstBaseState(this.changes.getBaseState(), (NodeStateDiff)diff);
            builder.setChildNode(ROOT, this.hook.processCommit(builder.getBaseState().getChildNode(ROOT), builder.getNodeState().getChildNode(ROOT), this.info));
        }
        return builder.getNodeState();
    }

    public void applied(SegmentNodeState merged) {
        this.changes.reset(merged);
    }

    public boolean hasChanges() {
        return !SegmentNodeState.fastEquals(this.changes.getBaseState(), this.changes.getNodeState());
    }

    public CommitInfo info() {
        return this.info;
    }
}

