/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.segment.memory;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import java.io.IOException;
import javax.annotation.Nonnull;
import org.apache.jackrabbit.oak.plugins.memory.EmptyNodeState;
import org.apache.jackrabbit.oak.segment.RecordId;
import org.apache.jackrabbit.oak.segment.Revisions;
import org.apache.jackrabbit.oak.segment.memory.MemoryStore;
import org.apache.jackrabbit.oak.spi.state.NodeBuilder;

public class MemoryStoreRevisions
implements Revisions {
    private RecordId head;

    public void bind(MemoryStore store) throws IOException {
        if (this.head == null) {
            NodeBuilder builder = EmptyNodeState.EMPTY_NODE.builder();
            builder.setChildNode("root", EmptyNodeState.EMPTY_NODE);
            this.head = store.getWriter().writeNode(builder.getNodeState());
            store.getWriter().flush();
        }
    }

    private void checkBound() {
        Preconditions.checkState((this.head != null ? 1 : 0) != 0, (Object)"Revisions not bound to a store");
    }

    @Override
    @Nonnull
    public synchronized RecordId getHead() {
        this.checkBound();
        return this.head;
    }

    @Override
    @Nonnull
    public RecordId getPersistedHead() {
        return this.getHead();
    }

    @Override
    public synchronized boolean setHead(@Nonnull RecordId expected, @Nonnull RecordId head, Revisions.Option ... options) {
        this.checkBound();
        if (this.head.equals(expected)) {
            this.head = head;
            return true;
        }
        return false;
    }

    @Override
    public RecordId setHead(@Nonnull Function<RecordId, RecordId> newHead, Revisions.Option ... options) throws InterruptedException {
        throw new UnsupportedOperationException();
    }
}

