/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.segment.file.tooling;

import com.google.common.collect.Sets;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.text.DateFormat;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Collectors;
import org.apache.jackrabbit.oak.api.Blob;
import org.apache.jackrabbit.oak.api.PropertyState;
import org.apache.jackrabbit.oak.api.Type;
import org.apache.jackrabbit.oak.commons.IOUtils;
import org.apache.jackrabbit.oak.commons.PathUtils;
import org.apache.jackrabbit.oak.segment.SegmentBlob;
import org.apache.jackrabbit.oak.segment.SegmentNodeStore;
import org.apache.jackrabbit.oak.segment.SegmentNodeStoreBuilders;
import org.apache.jackrabbit.oak.segment.file.FileStoreBuilder;
import org.apache.jackrabbit.oak.segment.file.InvalidFileStoreVersionException;
import org.apache.jackrabbit.oak.segment.file.JournalEntry;
import org.apache.jackrabbit.oak.segment.file.JournalReader;
import org.apache.jackrabbit.oak.segment.file.ReadOnlyFileStore;
import org.apache.jackrabbit.oak.segment.file.tar.IOMonitorAdapter;
import org.apache.jackrabbit.oak.spi.state.ChildNodeEntry;
import org.apache.jackrabbit.oak.spi.state.NodeState;
import org.apache.jackrabbit.oak.spi.state.NodeStateUtils;

public class ConsistencyChecker
implements Closeable {
    private static final String CHECKPOINT_INDENT = "  ";
    private static final String NO_INDENT = "";
    private final StatisticsIOMonitor statisticsIOMonitor = new StatisticsIOMonitor();
    private final ReadOnlyFileStore store;
    private final long debugInterval;
    private final PrintWriter outWriter;
    private final PrintWriter errWriter;
    private int nodeCount;
    private int propertyCount;
    private int checkCount;
    private long ts;

    public static void checkConsistency(File directory, String journalFileName, long debugInterval, boolean checkBinaries, boolean checkHead, Set<String> checkpoints, Set<String> filterPaths, boolean ioStatistics, PrintWriter outWriter, PrintWriter errWriter) throws IOException, InvalidFileStoreVersionException {
        try (JournalReader journal = new JournalReader(new File(directory, journalFileName));
             ConsistencyChecker checker = new ConsistencyChecker(directory, debugInterval, ioStatistics, outWriter, errWriter);){
            LinkedHashSet checkpointsSet = Sets.newLinkedHashSet();
            ArrayList<PathToCheck> headPaths = new ArrayList<PathToCheck>();
            HashMap<String, ArrayList<PathToCheck>> checkpointPaths = new HashMap<String, ArrayList<PathToCheck>>();
            int revisionCount = 0;
            if (!checkpoints.isEmpty()) {
                checkpointsSet.addAll(checkpoints);
                if (checkpointsSet.remove("all")) {
                    checkpointsSet = Sets.newLinkedHashSet(SegmentNodeStoreBuilders.builder(checker.store).build().checkpoints());
                }
            }
            for (String path : filterPaths) {
                if (checkHead) {
                    headPaths.add(new PathToCheck(path, null));
                    ++checker.checkCount;
                }
                for (String checkpoint : checkpointsSet) {
                    ArrayList<PathToCheck> pathList = (ArrayList<PathToCheck>)checkpointPaths.get(checkpoint);
                    if (pathList == null) {
                        pathList = new ArrayList<PathToCheck>();
                        checkpointPaths.put(checkpoint, pathList);
                    }
                    pathList.add(new PathToCheck(path, checkpoint));
                    ++checker.checkCount;
                }
            }
            int initialCount = checker.checkCount;
            JournalEntry lastValidJournalEntry = null;
            while (journal.hasNext() && checker.checkCount > 0) {
                JournalEntry journalEntry = (JournalEntry)journal.next();
                String revision = journalEntry.getRevision();
                try {
                    Map<String, Boolean> checkpointsToCheck;
                    boolean mustCheck;
                    boolean mustCheck2;
                    ++revisionCount;
                    checker.store.setRevision(revision);
                    boolean overallValid = true;
                    SegmentNodeStore sns = SegmentNodeStoreBuilders.builder(checker.store).build();
                    checker.print("\nChecking revision {0}", revision);
                    if (checkHead && (mustCheck2 = headPaths.stream().anyMatch(p -> p.journalEntry == null))) {
                        checker.print("\nChecking head\n");
                        NodeState root = sns.getRoot();
                        boolean bl = overallValid = overallValid && checker.checkPathsAtRoot(headPaths, root, journalEntry, checkBinaries);
                    }
                    if (!checkpointsSet.isEmpty() && (mustCheck = (checkpointsToCheck = checkpointPaths.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> ((List)e.getValue()).stream().anyMatch(p -> p.journalEntry == null)))).values().stream().anyMatch(v -> v == true))) {
                        checker.print("\nChecking checkpoints");
                        for (String checkpoint : checkpointsSet) {
                            if (!checkpointsToCheck.get(checkpoint).booleanValue()) continue;
                            checker.print("\nChecking checkpoint {0}", checkpoint);
                            List pathList = (List)checkpointPaths.get(checkpoint);
                            NodeState root = sns.retrieve(checkpoint);
                            if (root == null) {
                                checker.printError("Checkpoint {0} not found in this revision!", checkpoint);
                                overallValid = false;
                                continue;
                            }
                            overallValid = overallValid && checker.checkPathsAtRoot(pathList, root, journalEntry, checkBinaries);
                        }
                    }
                    if (!overallValid) continue;
                    lastValidJournalEntry = journalEntry;
                }
                catch (IllegalArgumentException e2) {
                    checker.printError("Skipping invalid record id {0}", revision);
                }
            }
            checker.print("\nSearched through {0} revisions and {1} checkpoints", revisionCount, checkpointsSet.size());
            if (initialCount == checker.checkCount) {
                checker.print("No good revision found");
            } else {
                if (checkHead) {
                    checker.print("\nHead");
                    checker.printResults(headPaths, NO_INDENT);
                }
                if (!checkpointsSet.isEmpty()) {
                    checker.print("\nCheckpoints");
                    for (String checkpoint : checkpointsSet) {
                        List pathList = (List)checkpointPaths.get(checkpoint);
                        checker.print("- {0}", checkpoint);
                        checker.printResults(pathList, CHECKPOINT_INDENT);
                    }
                }
                checker.print("\nOverall");
                checker.printOverallResults(lastValidJournalEntry);
            }
            if (ioStatistics) {
                checker.print("[I/O] Segment read: Number of operations: {0}", checker.statisticsIOMonitor.ioOperations);
                checker.print("[I/O] Segment read: Total size: {0} ({1} bytes)", IOUtils.humanReadableByteCount((long)checker.statisticsIOMonitor.readBytes.get()), checker.statisticsIOMonitor.readBytes);
                checker.print("[I/O] Segment read: Total time: {0} ns", checker.statisticsIOMonitor.readTime);
            }
        }
    }

    private void printResults(List<PathToCheck> pathList, String indent) {
        for (PathToCheck ptc : pathList) {
            String revision = ptc.journalEntry != null ? ptc.journalEntry.getRevision() : null;
            long timestamp = ptc.journalEntry != null ? ptc.journalEntry.getTimestamp() : -1L;
            this.print("{0}Latest good revision for path {1} is {2} from {3}", indent, ptc.path, ConsistencyChecker.toString(revision), ConsistencyChecker.toString(timestamp));
        }
    }

    private void printOverallResults(JournalEntry journalEntry) {
        String revision = journalEntry != null ? journalEntry.getRevision() : null;
        long timestamp = journalEntry != null ? journalEntry.getTimestamp() : -1L;
        this.print("Latest good revision for paths and checkpoints checked is {0} from {1}", ConsistencyChecker.toString(revision), ConsistencyChecker.toString(timestamp));
    }

    private static String toString(String revision) {
        if (revision != null) {
            return revision;
        }
        return "none";
    }

    private static String toString(long timestamp) {
        if (timestamp != -1L) {
            return DateFormat.getDateTimeInstance().format(new Date(timestamp));
        }
        return "unknown date";
    }

    public ConsistencyChecker(File directory, long debugInterval, boolean ioStatistics, PrintWriter outWriter, PrintWriter errWriter) throws IOException, InvalidFileStoreVersionException {
        FileStoreBuilder builder = FileStoreBuilder.fileStoreBuilder(directory);
        if (ioStatistics) {
            builder.withIOMonitor(this.statisticsIOMonitor);
        }
        this.store = builder.buildReadOnly();
        this.debugInterval = debugInterval;
        this.outWriter = outWriter;
        this.errWriter = errWriter;
    }

    private boolean checkPathsAtRoot(List<PathToCheck> paths, NodeState root, JournalEntry journalEntry, boolean checkBinaries) {
        boolean result = true;
        for (PathToCheck ptc : paths) {
            if (ptc.journalEntry != null) continue;
            String corruptPath = this.checkPathAtRoot(ptc, root, checkBinaries);
            if (corruptPath == null) {
                this.print("Path {0} is consistent", ptc.path);
                ptc.journalEntry = journalEntry;
                --this.checkCount;
                continue;
            }
            result = false;
            ptc.corruptPaths.add(corruptPath);
        }
        return result;
    }

    private String checkPathAtRoot(PathToCheck ptc, NodeState root, boolean checkBinaries) {
        String result = null;
        for (String corruptPath : ptc.corruptPaths) {
            try {
                NodeWrapper wrapper = NodeWrapper.deriveTraversableNodeOnPath(root, corruptPath);
                result = this.checkNode(wrapper.node, wrapper.path, checkBinaries);
                if (result == null) continue;
                return result;
            }
            catch (IllegalArgumentException e) {
                this.debug("Path {0} not found", corruptPath);
            }
        }
        this.nodeCount = 0;
        this.propertyCount = 0;
        this.print("Checking {0}", ptc.path);
        try {
            NodeWrapper wrapper = NodeWrapper.deriveTraversableNodeOnPath(root, ptc.path);
            result = this.checkNodeAndDescendants(wrapper.node, wrapper.path, checkBinaries);
            this.print("Checked {0} nodes and {1} properties", this.nodeCount, this.propertyCount);
            return result;
        }
        catch (IllegalArgumentException e) {
            this.printError("Path {0} not found", ptc.path);
            return ptc.path;
        }
    }

    private String checkNode(NodeState node, String path, boolean checkBinaries) {
        try {
            this.debug("Traversing {0}", path);
            ++this.nodeCount;
            for (PropertyState propertyState : node.getProperties()) {
                Type type = propertyState.getType();
                boolean checked = false;
                if (type == Type.BINARY) {
                    checked = this.traverse((Blob)propertyState.getValue(Type.BINARY), checkBinaries);
                } else if (type == Type.BINARIES) {
                    for (Blob blob : (Iterable)propertyState.getValue(Type.BINARIES)) {
                        checked |= this.traverse(blob, checkBinaries);
                    }
                } else {
                    propertyState.getValue(type);
                    ++this.propertyCount;
                    checked = true;
                }
                if (!checked) continue;
                this.debug("Checked {0}/{1}", path, propertyState);
            }
            return null;
        }
        catch (IOException | RuntimeException e) {
            this.printError("Error while traversing {0}: {1}", path, e);
            return path;
        }
    }

    private String checkNodeAndDescendants(NodeState node, String path, boolean checkBinaries) {
        String result = this.checkNode(node, path, checkBinaries);
        if (result != null) {
            return result;
        }
        try {
            for (ChildNodeEntry cne : node.getChildNodeEntries()) {
                String childName = cne.getName();
                NodeState child = cne.getNodeState();
                result = this.checkNodeAndDescendants(child, PathUtils.concat((String)path, (String)childName), checkBinaries);
                if (result == null) continue;
                return result;
            }
            return null;
        }
        catch (RuntimeException e) {
            this.printError("Error while traversing {0}: {1}", path, e.getMessage());
            return path;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean traverse(Blob blob, boolean checkBinaries) throws IOException {
        if (checkBinaries && !ConsistencyChecker.isExternal(blob)) {
            try (InputStream s = blob.getNewStream();){
                byte[] buffer = new byte[8192];
                int l = s.read(buffer, 0, buffer.length);
                while (l >= 0) {
                    l = s.read(buffer, 0, buffer.length);
                }
            }
            ++this.propertyCount;
            return true;
        }
        return false;
    }

    private static boolean isExternal(Blob b) {
        if (b instanceof SegmentBlob) {
            return ((SegmentBlob)b).isExternal();
        }
        return false;
    }

    @Override
    public void close() {
        this.store.close();
    }

    private void print(String format) {
        this.outWriter.println(format);
    }

    private void print(String format, Object arg) {
        this.outWriter.println(MessageFormat.format(format, arg));
    }

    private void print(String format, Object arg1, Object arg2) {
        this.outWriter.println(MessageFormat.format(format, arg1, arg2));
    }

    private void print(String format, Object arg1, Object arg2, Object arg3, Object arg4) {
        this.outWriter.println(MessageFormat.format(format, arg1, arg2, arg3, arg4));
    }

    private void printError(String format, Object arg) {
        this.errWriter.println(MessageFormat.format(format, arg));
    }

    private void printError(String format, Object arg1, Object arg2) {
        this.errWriter.println(MessageFormat.format(format, arg1, arg2));
    }

    private void debug(String format, Object arg) {
        if (this.debug()) {
            this.print(format, arg);
        }
    }

    private void debug(String format, Object arg1, Object arg2) {
        if (this.debug()) {
            this.print(format, arg1, arg2);
        }
    }

    private boolean debug() {
        if (this.debugInterval == Long.MAX_VALUE) {
            return false;
        }
        if (this.debugInterval == 0L) {
            return true;
        }
        long ts = System.currentTimeMillis();
        if ((ts - this.ts) / 1000L > this.debugInterval) {
            this.ts = ts;
            return true;
        }
        return false;
    }

    static class PathToCheck {
        final String path;
        final String checkpoint;
        JournalEntry journalEntry;
        Set<String> corruptPaths = new LinkedHashSet<String>();

        PathToCheck(String path, String checkpoint) {
            this.path = path;
            this.checkpoint = checkpoint;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.checkpoint == null ? 0 : this.checkpoint.hashCode());
            result = 31 * result + (this.path == null ? 0 : this.path.hashCode());
            return result;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object instanceof PathToCheck) {
                PathToCheck that = (PathToCheck)object;
                return this.path.equals(that.path) && this.checkpoint.equals(that.checkpoint);
            }
            return false;
        }
    }

    static class NodeWrapper {
        final NodeState node;
        final String path;

        NodeWrapper(NodeState node, String path) {
            this.node = node;
            this.path = path;
        }

        static NodeWrapper deriveTraversableNodeOnPath(NodeState root, String path) {
            String parentPath = PathUtils.getParentPath((String)path);
            String name = PathUtils.getName((String)path);
            NodeState parent = NodeStateUtils.getNode((NodeState)root, (String)parentPath);
            if (!PathUtils.denotesRoot((String)path)) {
                if (!parent.hasChildNode(name)) {
                    throw new IllegalArgumentException("Invalid path: " + path);
                }
                return new NodeWrapper(parent.getChildNode(name), path);
            }
            return new NodeWrapper(parent, parentPath);
        }
    }

    private static class StatisticsIOMonitor
    extends IOMonitorAdapter {
        private final AtomicLong ioOperations = new AtomicLong(0L);
        private final AtomicLong readBytes = new AtomicLong(0L);
        private final AtomicLong readTime = new AtomicLong(0L);

        private StatisticsIOMonitor() {
        }

        @Override
        public void afterSegmentRead(File file, long msb, long lsb, int length, long elapsed) {
            this.ioOperations.incrementAndGet();
            this.readBytes.addAndGet(length);
            this.readTime.addAndGet(elapsed);
        }
    }
}

