/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.segment.file.tar.index;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.zip.CRC32;
import org.apache.jackrabbit.oak.segment.file.tar.index.IndexV2;
import org.apache.jackrabbit.oak.segment.file.tar.index.InvalidIndexException;
import org.apache.jackrabbit.oak.segment.util.ReaderAtEnd;

class IndexLoaderV2 {
    static final int MAGIC = 171002634;
    private final int blockSize;

    IndexLoaderV2(int blockSize) {
        this.blockSize = blockSize;
    }

    IndexV2 loadIndex(ReaderAtEnd reader) throws InvalidIndexException, IOException {
        ByteBuffer meta = reader.readAtEnd(16, 16);
        int crc32 = meta.getInt();
        int count = meta.getInt();
        int bytes = meta.getInt();
        int magic = meta.getInt();
        if (magic != 171002634) {
            throw new InvalidIndexException("Magic number mismatch");
        }
        if (count < 1) {
            throw new InvalidIndexException("Invalid entry count");
        }
        if (bytes < count * 28 + 16) {
            throw new InvalidIndexException("Invalid size");
        }
        if (bytes % this.blockSize != 0) {
            throw new InvalidIndexException("Invalid size alignment");
        }
        ByteBuffer entries = reader.readAtEnd(16 + count * 33, count * 33);
        CRC32 checksum = new CRC32();
        entries.mark();
        checksum.update(entries);
        entries.reset();
        if (crc32 != (int)checksum.getValue()) {
            throw new InvalidIndexException("Invalid checksum");
        }
        long lastMsb = Long.MIN_VALUE;
        long lastLsb = Long.MIN_VALUE;
        byte[] entry = new byte[33];
        entries.mark();
        for (int i = 0; i < count; ++i) {
            entries.get(entry);
            ByteBuffer buffer = ByteBuffer.wrap(entry);
            long msb = buffer.getLong();
            long lsb = buffer.getLong();
            int offset = buffer.getInt();
            int size = buffer.getInt();
            if (lastMsb > msb || lastMsb == msb && lastLsb > lsb) {
                throw new InvalidIndexException("Incorrect entry ordering");
            }
            if (lastMsb == msb && lastLsb == lsb && i > 0) {
                throw new InvalidIndexException("Duplicate entry");
            }
            if (offset < 0) {
                throw new InvalidIndexException("Invalid entry offset");
            }
            if (offset % this.blockSize != 0) {
                throw new InvalidIndexException("Invalid entry offset alignment");
            }
            if (size < 1) {
                throw new InvalidIndexException("Invalid entry size");
            }
            lastMsb = msb;
            lastLsb = lsb;
        }
        entries.reset();
        return new IndexV2(entries);
    }
}

