/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.segment.file.tar.index;

import java.nio.ByteBuffer;
import org.apache.jackrabbit.oak.segment.file.tar.index.IndexEntry;

class IndexEntryV2
implements IndexEntry {
    static final int SIZE = 33;
    private final ByteBuffer index;
    private final int position;

    IndexEntryV2(ByteBuffer index, int position) {
        this.index = index;
        this.position = position;
    }

    @Override
    public long getMsb() {
        return this.index.getLong(this.position);
    }

    @Override
    public long getLsb() {
        return this.index.getLong(this.position + 8);
    }

    @Override
    public int getPosition() {
        return this.index.getInt(this.position + 16);
    }

    @Override
    public int getLength() {
        return this.index.getInt(this.position + 20);
    }

    @Override
    public int getGeneration() {
        return this.index.getInt(this.position + 24);
    }

    @Override
    public int getFullGeneration() {
        return this.index.getInt(this.position + 28);
    }

    @Override
    public boolean isCompacted() {
        return this.index.get(this.position + 32) != 0;
    }
}

