/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.segment.file.tar.binaries;

import com.google.common.base.Charsets;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.zip.CRC32;
import org.apache.jackrabbit.oak.segment.file.tar.binaries.Generation;

public class BinaryReferencesIndexWriter {
    private final Map<Generation, Map<UUID, Set<String>>> entries = new HashMap<Generation, Map<UUID, Set<String>>>();

    public static BinaryReferencesIndexWriter newBinaryReferencesIndexWriter() {
        return new BinaryReferencesIndexWriter();
    }

    private BinaryReferencesIndexWriter() {
    }

    public void addEntry(int generation, int full, boolean compacted, UUID segment, String reference) {
        this.entries.computeIfAbsent(new Generation(generation, full, compacted), k -> new HashMap()).computeIfAbsent(segment, k -> new HashSet()).add(reference);
    }

    public byte[] write() {
        int binaryReferenceSize = 0;
        binaryReferenceSize += 4;
        binaryReferenceSize += 4;
        binaryReferenceSize += 4;
        binaryReferenceSize += 4;
        for (Map<UUID, Set<String>> map : this.entries.values()) {
            binaryReferenceSize += 4;
            binaryReferenceSize += 4;
            ++binaryReferenceSize;
            binaryReferenceSize += 4;
            for (Set<String> references : map.values()) {
                binaryReferenceSize += 16;
                binaryReferenceSize += 4;
                for (String reference : references) {
                    binaryReferenceSize += 4;
                    binaryReferenceSize += reference.getBytes(Charsets.UTF_8).length;
                }
            }
        }
        ByteBuffer buffer = ByteBuffer.allocate(binaryReferenceSize);
        for (Map.Entry<Generation, Map<UUID, Set<String>>> entry : this.entries.entrySet()) {
            Generation generation = entry.getKey();
            Map<UUID, Set<String>> segmentToReferences = entry.getValue();
            buffer.putInt(generation.generation);
            buffer.putInt(generation.full);
            buffer.put((byte)(generation.compacted ? 1 : 0));
            buffer.putInt(segmentToReferences.size());
            for (Map.Entry<UUID, Set<String>> se : segmentToReferences.entrySet()) {
                UUID segmentId = se.getKey();
                Set<String> references = se.getValue();
                buffer.putLong(segmentId.getMostSignificantBits());
                buffer.putLong(segmentId.getLeastSignificantBits());
                buffer.putInt(references.size());
                for (String reference : references) {
                    byte[] bytes = reference.getBytes(Charsets.UTF_8);
                    buffer.putInt(bytes.length);
                    buffer.put(bytes);
                }
            }
        }
        CRC32 cRC32 = new CRC32();
        cRC32.update(buffer.array(), 0, buffer.position());
        buffer.putInt((int)cRC32.getValue());
        buffer.putInt(this.entries.size());
        buffer.putInt(binaryReferenceSize);
        buffer.putInt(171000330);
        return buffer.array();
    }
}

