/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.segment.file.tar.binaries;

import com.google.common.base.Charsets;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.zip.CRC32;
import org.apache.jackrabbit.oak.segment.file.tar.binaries.BinaryReferencesIndex;
import org.apache.jackrabbit.oak.segment.file.tar.binaries.Generation;
import org.apache.jackrabbit.oak.segment.file.tar.binaries.InvalidBinaryReferencesIndexException;
import org.apache.jackrabbit.oak.segment.util.ReaderAtEnd;

class BinaryReferencesIndexLoaderV1 {
    static final int MAGIC = 170934794;
    static final int FOOTER_SIZE = 16;

    BinaryReferencesIndexLoaderV1() {
    }

    static BinaryReferencesIndex loadBinaryReferencesIndex(ReaderAtEnd reader) throws IOException, InvalidBinaryReferencesIndexException {
        ByteBuffer meta = reader.readAtEnd(16, 16);
        int crc32 = meta.getInt();
        int count = meta.getInt();
        int size = meta.getInt();
        int magic = meta.getInt();
        if (magic != 170934794) {
            throw new InvalidBinaryReferencesIndexException("Invalid magic number");
        }
        if (count < 0) {
            throw new InvalidBinaryReferencesIndexException("Invalid count");
        }
        if (size < count * 22 + 16) {
            throw new InvalidBinaryReferencesIndexException("Invalid size");
        }
        ByteBuffer buffer = reader.readAtEnd(size, size - 16);
        CRC32 checksum = new CRC32();
        buffer.mark();
        checksum.update(buffer);
        buffer.reset();
        if ((int)checksum.getValue() != crc32) {
            throw new InvalidBinaryReferencesIndexException("Invalid checksum");
        }
        return new BinaryReferencesIndex(BinaryReferencesIndexLoaderV1.parseBinaryReferencesIndex(count, buffer));
    }

    private static Map<Generation, Map<UUID, Set<String>>> parseBinaryReferencesIndex(int count, ByteBuffer buffer) {
        HashMap<Generation, Map<UUID, Set<String>>> result = new HashMap<Generation, Map<UUID, Set<String>>>(count);
        for (int i = 0; i < count; ++i) {
            Generation k = BinaryReferencesIndexLoaderV1.parseGeneration(buffer);
            Map<UUID, Set<String>> v = BinaryReferencesIndexLoaderV1.parseEntriesBySegment(buffer);
            result.put(k, v);
        }
        return result;
    }

    private static Generation parseGeneration(ByteBuffer buffer) {
        int generation = buffer.getInt();
        return new Generation(generation, generation, true);
    }

    private static Map<UUID, Set<String>> parseEntriesBySegment(ByteBuffer buffer) {
        return BinaryReferencesIndexLoaderV1.parseEntriesBySegment(buffer.getInt(), buffer);
    }

    private static Map<UUID, Set<String>> parseEntriesBySegment(int count, ByteBuffer buffer) {
        HashMap<UUID, Set<String>> result = new HashMap<UUID, Set<String>>(count);
        for (int i = 0; i < count; ++i) {
            UUID k = BinaryReferencesIndexLoaderV1.parseUUID(buffer);
            Set<String> v = BinaryReferencesIndexLoaderV1.parseEntries(buffer);
            result.put(k, v);
        }
        return result;
    }

    private static UUID parseUUID(ByteBuffer buffer) {
        long msb = buffer.getLong();
        long lsb = buffer.getLong();
        return new UUID(msb, lsb);
    }

    private static Set<String> parseEntries(ByteBuffer buffer) {
        return BinaryReferencesIndexLoaderV1.parseEntries(buffer.getInt(), buffer);
    }

    private static Set<String> parseEntries(int count, ByteBuffer buffer) {
        HashSet<String> entries = new HashSet<String>(count);
        for (int i = 0; i < count; ++i) {
            entries.add(BinaryReferencesIndexLoaderV1.parseString(buffer));
        }
        return entries;
    }

    private static String parseString(ByteBuffer buffer) {
        return BinaryReferencesIndexLoaderV1.parseString(buffer.getInt(), buffer);
    }

    private static String parseString(int length, ByteBuffer buffer) {
        byte[] data = new byte[length];
        buffer.get(data);
        return new String(data, Charsets.UTF_8);
    }
}

