/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.segment.file.tar;

import com.google.common.base.Charsets;
import com.google.common.base.Predicate;
import com.google.common.base.Stopwatch;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.CRC32;
import javax.annotation.Nonnull;
import org.apache.commons.io.FileUtils;
import org.apache.jackrabbit.oak.segment.file.tar.CleanupContext;
import org.apache.jackrabbit.oak.segment.file.tar.EntryRecovery;
import org.apache.jackrabbit.oak.segment.file.tar.FileAccess;
import org.apache.jackrabbit.oak.segment.file.tar.GCGeneration;
import org.apache.jackrabbit.oak.segment.file.tar.IOMonitor;
import org.apache.jackrabbit.oak.segment.file.tar.TarEntry;
import org.apache.jackrabbit.oak.segment.file.tar.TarRecovery;
import org.apache.jackrabbit.oak.segment.file.tar.TarWriter;
import org.apache.jackrabbit.oak.segment.file.tar.binaries.BinaryReferencesIndex;
import org.apache.jackrabbit.oak.segment.file.tar.binaries.BinaryReferencesIndexLoader;
import org.apache.jackrabbit.oak.segment.file.tar.binaries.InvalidBinaryReferencesIndexException;
import org.apache.jackrabbit.oak.segment.file.tar.index.Index;
import org.apache.jackrabbit.oak.segment.file.tar.index.IndexEntry;
import org.apache.jackrabbit.oak.segment.file.tar.index.IndexLoader;
import org.apache.jackrabbit.oak.segment.file.tar.index.InvalidIndexException;
import org.apache.jackrabbit.oak.segment.util.ReaderAtEnd;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class TarReader
implements Closeable {
    private static final Logger log = LoggerFactory.getLogger(TarReader.class);
    private static final IndexLoader indexLoader = IndexLoader.newIndexLoader(512);
    private static final Pattern NAME_PATTERN = Pattern.compile("([0-9a-f]{8}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{12})(\\.([0-9a-f]{8}))?(\\..*)?");
    private final File file;
    private final FileAccess access;
    private final Index index;
    private volatile boolean hasGraph;
    private final IOMonitor ioMonitor;

    private static int getEntrySize(int size) {
        return 512 + size + TarWriter.getPaddingSize(size);
    }

    static TarReader open(File file, boolean memoryMapping, IOMonitor ioMonitor) throws IOException {
        TarReader reader = TarReader.openFirstFileWithValidIndex(Collections.singletonList(file), memoryMapping, ioMonitor);
        if (reader != null) {
            return reader;
        }
        throw new IOException("Failed to open tar file " + file);
    }

    static TarReader open(Map<Character, File> files, boolean memoryMapping, TarRecovery recovery, IOMonitor ioMonitor) throws IOException {
        TreeMap sorted = Maps.newTreeMap();
        sorted.putAll(files);
        ArrayList list = Lists.newArrayList(sorted.values());
        Collections.reverse(list);
        TarReader reader = TarReader.openFirstFileWithValidIndex(list, memoryMapping, ioMonitor);
        if (reader != null) {
            return reader;
        }
        log.warn("Could not find a valid tar index in {}, recovering...", (Object)list);
        LinkedHashMap entries = Maps.newLinkedHashMap();
        for (File file : sorted.values()) {
            TarReader.collectFileEntries(file, entries, true);
        }
        File file = (File)sorted.values().iterator().next();
        TarReader.generateTarFile(entries, file, recovery, ioMonitor);
        reader = TarReader.openFirstFileWithValidIndex(Collections.singletonList(file), memoryMapping, ioMonitor);
        if (reader != null) {
            return reader;
        }
        throw new IOException("Failed to open recovered tar file " + file);
    }

    static TarReader openRO(Map<Character, File> files, boolean memoryMapping, TarRecovery recovery, IOMonitor ioMonitor) throws IOException {
        File file = files.get(Collections.max(files.keySet()));
        TarReader reader = TarReader.openFirstFileWithValidIndex(Collections.singletonList(file), memoryMapping, ioMonitor);
        if (reader != null) {
            return reader;
        }
        log.warn("Could not find a valid tar index in {}, recovering read-only", (Object)file);
        LinkedHashMap entries = Maps.newLinkedHashMap();
        TarReader.collectFileEntries(file, entries, false);
        file = TarReader.findAvailGen(file, ".ro.bak");
        TarReader.generateTarFile(entries, file, recovery, ioMonitor);
        reader = TarReader.openFirstFileWithValidIndex(Collections.singletonList(file), memoryMapping, ioMonitor);
        if (reader != null) {
            return reader;
        }
        throw new IOException("Failed to open tar file " + file);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void collectFileEntries(File file, LinkedHashMap<UUID, byte[]> entries, boolean backup) throws IOException {
        log.info("Recovering segments from tar file {}", (Object)file);
        try (RandomAccessFile access = new RandomAccessFile(file, "r");){
            TarReader.recoverEntries(file, access, entries);
        }
        catch (IOException e) {
            log.warn("Could not read tar file {}, skipping...", (Object)file, (Object)e);
        }
        if (backup) {
            TarReader.backupSafely(file);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void generateTarFile(LinkedHashMap<UUID, byte[]> entries, File file, TarRecovery recovery, IOMonitor ioMonitor) throws IOException {
        log.info("Regenerating tar file {}", (Object)file);
        try (final TarWriter writer = new TarWriter(file, ioMonitor);){
            for (Map.Entry<UUID, byte[]> entry : entries.entrySet()) {
                try {
                    recovery.recoverEntry(entry.getKey(), entry.getValue(), new EntryRecovery(){

                        @Override
                        public void recoverEntry(long msb, long lsb, byte[] data, int offset, int size, GCGeneration generation) throws IOException {
                            writer.writeEntry(msb, lsb, data, offset, size, generation);
                        }

                        @Override
                        public void recoverGraphEdge(UUID from, UUID to) {
                            writer.addGraphEdge(from, to);
                        }

                        @Override
                        public void recoverBinaryReference(GCGeneration generation, UUID segmentId, String reference) {
                            writer.addBinaryReference(generation, segmentId, reference);
                        }
                    });
                }
                catch (IOException e) {
                    throw new IOException(String.format("Unable to recover entry %s for file %s", entry.getKey(), file), e);
                    return;
                }
            }
        }
    }

    private static void backupSafely(File file) throws IOException {
        File backup = TarReader.findAvailGen(file, ".bak");
        log.info("Backing up {} to {}", (Object)file, (Object)backup.getName());
        if (!file.renameTo(backup)) {
            log.warn("Renaming failed, so using copy to backup {}", (Object)file);
            FileUtils.copyFile((File)file, (File)backup);
            if (!file.delete()) {
                throw new IOException("Could not remove broken tar file " + file);
            }
        }
    }

    private static File findAvailGen(File file, String ext) {
        File parent = file.getParentFile();
        String name = file.getName();
        File backup = new File(parent, name + ext);
        int i = 2;
        while (backup.exists()) {
            backup = new File(parent, name + "." + i + ext);
            ++i;
        }
        return backup;
    }

    /*
     * Exception decompiling
     */
    private static TarReader openFirstFileWithValidIndex(List<File> files, boolean memoryMapping, IOMonitor ioMonitor) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [6[CATCHBLOCK], 0[TRYBLOCK], 1[TRYBLOCK]], but top level block is 3[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static Index loadAndValidateIndex(RandomAccessFile file, String name) throws IOException {
        long length = file.length();
        if (length % 512L != 0L) {
            log.warn("Unable to load index of file {}: Invalid alignment", (Object)name);
            return null;
        }
        if (length < 3072L) {
            log.warn("Unable to load index of file {}: File too short", (Object)name);
            return null;
        }
        if (length > Integer.MAX_VALUE) {
            log.warn("Unable to load index of file {}: File too long", (Object)name);
            return null;
        }
        ReaderAtEnd r = (whence, size) -> {
            ByteBuffer buffer = ByteBuffer.allocate(size);
            file.seek(length - 1024L - (long)whence);
            file.readFully(buffer.array());
            return buffer;
        };
        try {
            return indexLoader.loadIndex(r);
        }
        catch (InvalidIndexException e) {
            log.warn("Unable to load index of file {}: {}", (Object)name, (Object)e.getMessage());
            return null;
        }
    }

    private static void recoverEntries(File file, RandomAccessFile access, LinkedHashMap<UUID, byte[]> entries) throws IOException {
        byte[] header = new byte[512];
        while (access.getFilePointer() + 512L <= access.length()) {
            int i;
            access.readFully(header);
            int sum = 0;
            for (i = 0; i < 512; ++i) {
                sum += header[i] & 0xFF;
            }
            if (sum == 0 && access.getFilePointer() + 1024L == access.length()) {
                return;
            }
            for (i = 148; i < 156; ++i) {
                sum -= header[i] & 0xFF;
                sum += 32;
            }
            byte[] checkbytes = String.format("%06o\u0000 ", sum).getBytes(Charsets.UTF_8);
            for (int i2 = 0; i2 < checkbytes.length; ++i2) {
                if (checkbytes[i2] == header[148 + i2]) continue;
                log.warn("Invalid entry checksum at offset {} in tar file {}, skipping...", (Object)(access.getFilePointer() - 512L), (Object)file);
            }
            ByteBuffer buffer = ByteBuffer.wrap(header);
            String name = TarReader.readString(buffer, 100);
            buffer.position(124);
            int size = TarReader.readNumber(buffer, 12);
            if (access.getFilePointer() + (long)size > access.length()) {
                log.warn("Partial entry {} in tar file {}, ignoring...", (Object)name, (Object)file);
                return;
            }
            Matcher matcher = NAME_PATTERN.matcher(name);
            if (matcher.matches()) {
                UUID id = UUID.fromString(matcher.group(1));
                String checksum = matcher.group(3);
                if (checksum == null && entries.containsKey(id)) continue;
                byte[] data = new byte[size];
                access.readFully(data);
                long position = access.getFilePointer();
                long remainder = position % 512L;
                if (remainder != 0L) {
                    access.seek(position + (512L - remainder));
                }
                if (checksum != null) {
                    CRC32 crc = new CRC32();
                    crc.update(data);
                    if (crc.getValue() != Long.parseLong(checksum, 16)) {
                        log.warn("Checksum mismatch in entry {} of tar file {}, skipping...", (Object)name, (Object)file);
                        continue;
                    }
                }
                entries.put(id, data);
                continue;
            }
            if (name.equals(file.getName() + ".idx")) continue;
            log.warn("Unexpected entry {} in tar file {}, skipping...", (Object)name, (Object)file);
            long position = access.getFilePointer() + (long)size;
            long remainder = position % 512L;
            if (remainder != 0L) {
                position += 512L - remainder;
            }
            access.seek(position);
        }
    }

    private TarReader(File file, FileAccess access, Index index, IOMonitor ioMonitor) {
        this.file = file;
        this.access = access;
        this.index = index;
        this.ioMonitor = ioMonitor;
    }

    long size() {
        return this.file.length();
    }

    Set<UUID> getUUIDs() {
        return this.index.getUUIDs();
    }

    boolean containsEntry(long msb, long lsb) {
        return this.findEntry(msb, lsb) != -1;
    }

    ByteBuffer readEntry(long msb, long lsb) throws IOException {
        int idx = this.findEntry(msb, lsb);
        if (idx == -1) {
            return null;
        }
        return this.readEntry(msb, lsb, this.index.entry(idx));
    }

    private ByteBuffer readEntry(long msb, long lsb, IndexEntry entry) throws IOException {
        return this.readSegment(msb, lsb, entry.getPosition(), entry.getLength());
    }

    private int findEntry(long msb, long lsb) {
        return this.index.findEntry(msb, lsb);
    }

    @Nonnull
    TarEntry[] getEntries() {
        TarEntry[] entries = new TarEntry[this.index.count()];
        for (int i = 0; i < entries.length; ++i) {
            IndexEntry e = this.index.entry(i);
            entries[i] = new TarEntry(e.getMsb(), e.getLsb(), e.getPosition(), e.getLength(), GCGeneration.newGCGeneration(e.getGeneration(), e.getFullGeneration(), e.isCompacted()));
        }
        Arrays.sort(entries, TarEntry.OFFSET_ORDER);
        return entries;
    }

    @Nonnull
    private static List<UUID> getReferences(UUID id, Map<UUID, List<UUID>> graph) {
        List<UUID> references = graph.get(id);
        if (references == null) {
            return Collections.emptyList();
        }
        return references;
    }

    void collectBlobReferences(@Nonnull Consumer<String> collector, Predicate<GCGeneration> skipGeneration) {
        BinaryReferencesIndex references = this.getBinaryReferences();
        if (references == null) {
            return;
        }
        references.forEach((generation, full, compacted, segment, reference) -> {
            if (skipGeneration.apply((Object)GCGeneration.newGCGeneration(generation, full, compacted))) {
                return;
            }
            collector.accept(reference);
        });
    }

    void mark(Set<UUID> references, Set<UUID> reclaimable, CleanupContext context) throws IOException {
        Map<UUID, List<UUID>> graph = this.getGraph();
        TarEntry[] entries = this.getEntries();
        for (int i = entries.length - 1; i >= 0; --i) {
            TarEntry entry = entries[i];
            UUID id = new UUID(entry.msb(), entry.lsb());
            if (context.shouldReclaim(id, entry.generation(), references.remove(id))) {
                reclaimable.add(id);
                continue;
            }
            for (UUID refId : TarReader.getReferences(id, graph)) {
                if (!context.shouldFollow(id, refId)) continue;
                references.add(refId);
            }
        }
    }

    TarReader sweep(@Nonnull Set<UUID> reclaim, @Nonnull Set<UUID> reclaimed) throws IOException {
        int pos;
        char generation;
        String name = this.file.getName();
        log.debug("Cleaning up {}", (Object)name);
        HashSet cleaned = Sets.newHashSet();
        int afterSize = 0;
        int beforeSize = 0;
        int afterCount = 0;
        TarEntry[] entries = this.getEntries();
        for (int i = 0; i < entries.length; ++i) {
            TarEntry entry = entries[i];
            beforeSize += TarReader.getEntrySize(entry.size());
            UUID id2 = new UUID(entry.msb(), entry.lsb());
            if (reclaim.contains(id2)) {
                cleaned.add(id2);
                entries[i] = null;
                continue;
            }
            afterSize += TarReader.getEntrySize(entry.size());
            ++afterCount;
        }
        if (afterCount == 0) {
            log.debug("None of the entries of {} are referenceable.", (Object)name);
            return null;
        }
        if (afterSize >= beforeSize * 3 / 4 && this.hasGraph()) {
            log.debug("Not enough space savings. ({}/{}). Skipping clean up of {}", new Object[]{this.access.length() - afterSize, this.access.length(), name});
            return this;
        }
        if (!this.hasGraph()) {
            log.warn("Recovering {}, which is missing its graph.", (Object)name);
        }
        if ((generation = name.charAt(pos = name.length() - "a.tar".length())) == 'z') {
            log.debug("No garbage collection after reaching generation z: {}", (Object)name);
            return this;
        }
        File newFile = new File(this.file.getParentFile(), name.substring(0, pos) + (char)(generation + '\u0001') + ".tar");
        log.debug("Writing new generation {}", (Object)newFile.getName());
        TarWriter writer = new TarWriter(newFile, this.ioMonitor);
        for (TarEntry entry : entries) {
            if (entry == null) continue;
            long msb = entry.msb();
            long lsb = entry.lsb();
            int offset = entry.offset();
            int size = entry.size();
            GCGeneration gen2 = entry.generation();
            byte[] data = new byte[size];
            this.readSegment(msb, lsb, offset, size).get(data);
            writer.writeEntry(msb, lsb, data, 0, size, gen2);
        }
        Map<UUID, List<UUID>> graph = this.getGraph();
        for (Map.Entry<UUID, List<UUID>> e : graph.entrySet()) {
            if (cleaned.contains(e.getKey())) continue;
            HashSet vertices = Sets.newHashSet();
            for (UUID vertex : e.getValue()) {
                if (cleaned.contains(vertex)) continue;
                vertices.add(vertex);
            }
            for (UUID vertex : vertices) {
                writer.addGraphEdge(e.getKey(), vertex);
            }
        }
        BinaryReferencesIndex references = this.getBinaryReferences();
        if (references != null) {
            references.forEach((gen, full, compacted, id, reference) -> {
                if (cleaned.contains(id)) {
                    return;
                }
                writer.addBinaryReference(GCGeneration.newGCGeneration(gen, full, compacted), id, reference);
            });
        }
        writer.close();
        TarReader reader = TarReader.openFirstFileWithValidIndex(Collections.singletonList(newFile), this.access.isMemoryMapped(), this.ioMonitor);
        if (reader != null) {
            reclaimed.addAll(cleaned);
            return reader;
        }
        log.warn("Failed to open cleaned up tar file {}", (Object)this.file);
        return this;
    }

    @Override
    public void close() throws IOException {
        this.access.close();
    }

    Map<UUID, List<UUID>> getGraph() throws IOException {
        ByteBuffer graph = this.loadGraph();
        if (graph == null) {
            return null;
        }
        return TarReader.parseGraph(graph);
    }

    private boolean hasGraph() {
        if (!this.hasGraph) {
            try {
                this.loadGraph();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return this.hasGraph;
    }

    private int getIndexEntrySize() {
        return TarReader.getEntrySize(this.index.size());
    }

    private int getGraphEntrySize() {
        ByteBuffer buffer;
        try {
            buffer = this.loadGraph();
        }
        catch (IOException e) {
            log.warn("Exception while loading pre-compiled tar graph", (Throwable)e);
            return 0;
        }
        if (buffer == null) {
            return 0;
        }
        return TarReader.getEntrySize(buffer.getInt(buffer.limit() - 8));
    }

    BinaryReferencesIndex getBinaryReferences() {
        BinaryReferencesIndex index = null;
        try {
            index = this.loadBinaryReferences();
        }
        catch (IOException | InvalidBinaryReferencesIndexException e) {
            log.warn("Exception while loading binary reference", (Throwable)e);
        }
        return index;
    }

    private BinaryReferencesIndex loadBinaryReferences() throws IOException, InvalidBinaryReferencesIndexException {
        int end = this.access.length() - 1024 - this.getIndexEntrySize() - this.getGraphEntrySize();
        return BinaryReferencesIndexLoader.loadBinaryReferencesIndex((whence, size) -> this.access.read(end - whence, size));
    }

    private ByteBuffer loadGraph() throws IOException {
        int pos = this.access.length() - 1024 - this.getIndexEntrySize();
        ByteBuffer meta = this.access.read(pos - 16, 16);
        int crc32 = meta.getInt();
        int count = meta.getInt();
        int bytes = meta.getInt();
        int magic = meta.getInt();
        if (magic != 170936074) {
            log.warn("Invalid graph magic number in {}", (Object)this.file);
            return null;
        }
        if (count < 0) {
            log.warn("Invalid number of entries in {}", (Object)this.file);
            return null;
        }
        if (bytes < 4 + count * 34) {
            log.warn("Invalid entry size in {}", (Object)this.file);
            return null;
        }
        ByteBuffer graph = this.access.read(pos - bytes, bytes);
        byte[] b = new byte[bytes - 16];
        graph.mark();
        graph.get(b);
        graph.reset();
        CRC32 checksum = new CRC32();
        checksum.update(b);
        if (crc32 != (int)checksum.getValue()) {
            log.warn("Invalid graph checksum in tar file {}", (Object)this.file);
            return null;
        }
        this.hasGraph = true;
        return graph;
    }

    private ByteBuffer readSegment(long msb, long lsb, int offset, int size) throws IOException {
        this.ioMonitor.beforeSegmentRead(this.file, msb, lsb, size);
        Stopwatch stopwatch = Stopwatch.createStarted();
        ByteBuffer buffer = this.access.read(offset, size);
        long elapsed = stopwatch.elapsed(TimeUnit.NANOSECONDS);
        this.ioMonitor.afterSegmentRead(this.file, msb, lsb, size, elapsed);
        return buffer;
    }

    private static Map<UUID, List<UUID>> parseGraph(ByteBuffer buffer) {
        int nEntries = buffer.getInt(buffer.limit() - 12);
        HashMap graph = Maps.newHashMapWithExpectedSize((int)nEntries);
        for (int i = 0; i < nEntries; ++i) {
            long msb = buffer.getLong();
            long lsb = buffer.getLong();
            int nVertices = buffer.getInt();
            ArrayList vertices = Lists.newArrayListWithCapacity((int)nVertices);
            for (int j = 0; j < nVertices; ++j) {
                long vMsb = buffer.getLong();
                long vLsb = buffer.getLong();
                vertices.add(new UUID(vMsb, vLsb));
            }
            graph.put(new UUID(msb, lsb), vertices);
        }
        return graph;
    }

    private static String readString(ByteBuffer buffer, int fieldSize) {
        int n;
        byte[] b = new byte[fieldSize];
        buffer.get(b);
        for (n = 0; n < fieldSize && b[n] != 0; ++n) {
        }
        return new String(b, 0, n, Charsets.UTF_8);
    }

    private static int readNumber(ByteBuffer buffer, int fieldSize) {
        int digit;
        byte[] b = new byte[fieldSize];
        buffer.get(b);
        int number = 0;
        for (int i = 0; i < fieldSize && 48 <= (digit = b[i] & 0xFF) && digit <= 55; ++i) {
            number = number * 8 + digit - 48;
        }
        return number;
    }

    File getFile() {
        return this.file;
    }

    public String toString() {
        return this.file.toString();
    }
}

