/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.segment.file.tar;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.Consumer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import org.apache.commons.io.FileUtils;
import org.apache.jackrabbit.oak.segment.file.tar.CleanupContext;
import org.apache.jackrabbit.oak.segment.file.tar.FileStoreMonitor;
import org.apache.jackrabbit.oak.segment.file.tar.GCGeneration;
import org.apache.jackrabbit.oak.segment.file.tar.IOMonitor;
import org.apache.jackrabbit.oak.segment.file.tar.TarReader;
import org.apache.jackrabbit.oak.segment.file.tar.TarRecovery;
import org.apache.jackrabbit.oak.segment.file.tar.TarWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TarFiles
implements Closeable {
    private static final Logger log = LoggerFactory.getLogger(TarFiles.class);
    private static final Pattern FILE_NAME_PATTERN = Pattern.compile("(data)((0|[1-9][0-9]*)[0-9]{4})([a-z])?.tar");
    private final long maxFileSize;
    private final boolean memoryMapping;
    private final IOMonitor ioMonitor;
    private final ReadWriteLock lock = new ReentrantReadWriteLock();
    private Node readers;
    private TarWriter writer;
    private volatile boolean shutdown;

    private static Node reverse(Node n) {
        Node r = null;
        while (n != null) {
            r = new Node(n.reader, r);
            n = n.next;
        }
        return r;
    }

    private static Iterable<TarReader> iterable(final Node head) {
        return new Iterable<TarReader>(){

            @Override
            @Nonnull
            public Iterator<TarReader> iterator() {
                return new Iterator<TarReader>(){
                    private Node next;
                    {
                        this.next = head;
                    }

                    @Override
                    public boolean hasNext() {
                        return this.next != null;
                    }

                    @Override
                    public TarReader next() {
                        if (!this.hasNext()) {
                            throw new NoSuchElementException();
                        }
                        Node current = this.next;
                        this.next = current.next;
                        return current.reader;
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException("not implemented");
                    }
                };
            }
        };
    }

    private static Map<Integer, Map<Character, File>> collectFiles(File directory) {
        HashMap dataFiles = Maps.newHashMap();
        for (File file : FileUtils.listFiles((File)directory, null, (boolean)false)) {
            Matcher matcher = FILE_NAME_PATTERN.matcher(file.getName());
            if (!matcher.matches()) continue;
            Integer index = Integer.parseInt(matcher.group(2));
            Map files = (Map)dataFiles.get(index);
            if (files == null) {
                files = Maps.newHashMap();
                dataFiles.put(index, files);
            }
            Character generation = Character.valueOf('a');
            if (matcher.group(4) != null) {
                generation = Character.valueOf(matcher.group(4).charAt(0));
            }
            Preconditions.checkState((files.put(generation, file) == null ? 1 : 0) != 0);
        }
        return dataFiles;
    }

    public static Builder builder() {
        return new Builder();
    }

    private TarFiles(Builder builder) throws IOException {
        this.maxFileSize = builder.maxFileSize;
        this.memoryMapping = builder.memoryMapping;
        this.ioMonitor = builder.ioMonitor;
        Map<Integer, Map<Character, File>> map = TarFiles.collectFiles(builder.directory);
        Object[] indices = map.keySet().toArray(new Integer[map.size()]);
        Arrays.sort(indices);
        for (Object index : indices) {
            TarReader r = builder.readOnly ? TarReader.openRO(map.get(index), this.memoryMapping, builder.tarRecovery, this.ioMonitor) : TarReader.open(map.get(index), this.memoryMapping, builder.tarRecovery, this.ioMonitor);
            this.readers = new Node(r, this.readers);
        }
        if (builder.readOnly) {
            return;
        }
        int writeNumber = 0;
        if (indices.length > 0) {
            writeNumber = (Integer)indices[indices.length - 1] + 1;
        }
        this.writer = new TarWriter(builder.directory, builder.fileStoreMonitor, writeNumber, builder.ioMonitor);
    }

    @Override
    public void close() throws IOException {
        Node head;
        TarWriter w;
        this.shutdown = true;
        this.lock.writeLock().lock();
        try {
            w = this.writer;
            head = this.readers;
        }
        finally {
            this.lock.writeLock().unlock();
        }
        IOException exception = null;
        if (w != null) {
            try {
                w.close();
            }
            catch (IOException e) {
                exception = e;
            }
        }
        for (TarReader reader : TarFiles.iterable(head)) {
            try {
                reader.close();
            }
            catch (IOException e) {
                if (exception == null) {
                    exception = e;
                    continue;
                }
                exception.addSuppressed(e);
            }
        }
        if (exception != null) {
            throw exception;
        }
    }

    public String toString() {
        Node head;
        String w = null;
        this.lock.readLock().lock();
        try {
            if (this.writer != null) {
                w = this.writer.toString();
            }
            head = this.readers;
        }
        finally {
            this.lock.readLock().unlock();
        }
        return String.format("TarFiles{readers=%s,writer=%s}", Lists.newArrayList(TarFiles.iterable(head)), w);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long size() {
        Node head;
        long size = 0L;
        this.lock.readLock().lock();
        try {
            if (this.writer != null) {
                size = this.writer.fileLength();
            }
            head = this.readers;
        }
        finally {
            this.lock.readLock().unlock();
        }
        for (TarReader reader : TarFiles.iterable(head)) {
            size += reader.size();
        }
        return size;
    }

    public int readerCount() {
        Node head;
        this.lock.readLock().lock();
        try {
            head = this.readers;
        }
        finally {
            this.lock.readLock().unlock();
        }
        return Iterables.size(TarFiles.iterable(head));
    }

    public void flush() throws IOException {
        this.lock.readLock().lock();
        try {
            this.writer.flush();
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean containsSegment(long msb, long lsb) {
        Node head;
        this.lock.readLock().lock();
        try {
            if (this.writer != null && this.writer.containsEntry(msb, lsb)) {
                boolean bl = true;
                return bl;
            }
            head = this.readers;
        }
        finally {
            this.lock.readLock().unlock();
        }
        for (TarReader reader : TarFiles.iterable(head)) {
            if (!reader.containsEntry(msb, lsb)) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ByteBuffer readSegment(long msb, long lsb) {
        try {
            TarReader reader;
            ByteBuffer b;
            Node head;
            this.lock.readLock().lock();
            try {
                ByteBuffer b2;
                if (this.writer != null && (b2 = this.writer.readEntry(msb, lsb)) != null) {
                    ByteBuffer byteBuffer = b2;
                    return byteBuffer;
                }
                head = this.readers;
            }
            finally {
                this.lock.readLock().unlock();
            }
            Iterator<TarReader> iterator = TarFiles.iterable(head).iterator();
            do {
                if (!iterator.hasNext()) return null;
            } while ((b = (reader = iterator.next()).readEntry(msb, lsb)) == null);
            return b;
        }
        catch (IOException e) {
            log.warn("Unable to read from TAR file", (Throwable)e);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeSegment(UUID id, byte[] buffer, int offset, int length, GCGeneration generation, Set<UUID> references, Set<String> binaryReferences) throws IOException {
        this.lock.writeLock().lock();
        try {
            long size = this.writer.writeEntry(id.getMostSignificantBits(), id.getLeastSignificantBits(), buffer, offset, length, generation);
            if (references != null) {
                for (UUID uUID : references) {
                    this.writer.addGraphEdge(id, uUID);
                }
            }
            if (binaryReferences != null) {
                for (String string : binaryReferences) {
                    this.writer.addBinaryReference(generation, id, string);
                }
            }
            if (size >= this.maxFileSize) {
                this.internalNewWriter();
            }
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    private void internalNewWriter() throws IOException {
        TarWriter newWriter = this.writer.createNextGeneration();
        if (newWriter == this.writer) {
            return;
        }
        this.readers = new Node(TarReader.open(this.writer.getFile(), this.memoryMapping, this.ioMonitor), this.readers);
        this.writer = newWriter;
    }

    void newWriter() throws IOException {
        this.lock.writeLock().lock();
        try {
            this.internalNewWriter();
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public CleanupResult cleanup(CleanupContext context) throws IOException {
        void var7_14;
        long reclaimed;
        HashSet<UUID> references;
        Node head;
        CleanupResult result = new CleanupResult();
        result.removableFiles = new ArrayList();
        result.reclaimedSegmentIds = new HashSet();
        this.lock.writeLock().lock();
        this.lock.readLock().lock();
        try {
            try {
                this.internalNewWriter();
            }
            finally {
                this.lock.writeLock().unlock();
            }
            head = this.readers;
            references = new HashSet<UUID>(context.initialReferences());
        }
        finally {
            this.lock.readLock().unlock();
        }
        LinkedHashMap<TarReader, TarReader> cleaned = new LinkedHashMap<TarReader, TarReader>();
        for (TarReader tarReader : TarFiles.iterable(head)) {
            cleaned.put(tarReader, tarReader);
            CleanupResult cleanupResult = result;
            cleanupResult.reclaimedSize = cleanupResult.reclaimedSize + tarReader.size();
        }
        HashSet reclaim = Sets.newHashSet();
        for (TarReader reader : cleaned.keySet()) {
            if (this.shutdown) {
                result.interrupted = true;
                return result;
            }
            reader.mark(references, reclaim, context);
        }
        for (TarReader reader : cleaned.keySet()) {
            if (this.shutdown) {
                result.interrupted = true;
                return result;
            }
            cleaned.put(reader, reader.sweep(reclaim, result.reclaimedSegmentIds));
        }
        while (true) {
            Object var7_13 = null;
            reclaimed = 0L;
            Node swept = null;
            for (TarReader reader : TarFiles.iterable(head)) {
                if (cleaned.containsKey(reader)) {
                    TarReader cleanedReader = (TarReader)cleaned.get(reader);
                    if (cleanedReader != null) {
                        swept = new Node(cleanedReader, swept);
                        reclaimed += cleanedReader.size();
                    }
                    if (cleanedReader == reader) continue;
                    Node node = new Node(reader, (Node)var7_14);
                    continue;
                }
                swept = new Node(reader, swept);
            }
            swept = TarFiles.reverse(swept);
            this.lock.writeLock().lock();
            try {
                if (this.readers == head) {
                    this.readers = swept;
                    break;
                }
                head = this.readers;
                continue;
            }
            finally {
                this.lock.writeLock().unlock();
                continue;
            }
            break;
        }
        CleanupResult cleanupResult = result;
        cleanupResult.reclaimedSize = cleanupResult.reclaimedSize - reclaimed;
        for (TarReader closeable : TarFiles.iterable((Node)var7_14)) {
            try {
                closeable.close();
            }
            catch (IOException e) {
                log.warn("Unable to close swept TAR reader", (Throwable)e);
            }
            result.removableFiles.add(closeable.getFile());
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void collectBlobReferences(Consumer<String> collector, Predicate<GCGeneration> reclaim) throws IOException {
        Node head;
        this.lock.writeLock().lock();
        try {
            if (this.writer != null) {
                this.internalNewWriter();
            }
            head = this.readers;
        }
        finally {
            this.lock.writeLock().unlock();
        }
        for (TarReader reader : TarFiles.iterable(head)) {
            reader.collectBlobReferences(collector, reclaim);
        }
    }

    public Iterable<UUID> getSegmentIds() {
        Node head;
        this.lock.readLock().lock();
        try {
            head = this.readers;
        }
        finally {
            this.lock.readLock().unlock();
        }
        ArrayList<UUID> ids = new ArrayList<UUID>();
        for (TarReader reader : TarFiles.iterable(head)) {
            ids.addAll(reader.getUUIDs());
        }
        return ids;
    }

    public Map<UUID, Set<UUID>> getGraph(String fileName) throws IOException {
        Node head;
        this.lock.readLock().lock();
        try {
            head = this.readers;
        }
        finally {
            this.lock.readLock().unlock();
        }
        Set<UUID> index = null;
        Map<UUID, List<UUID>> graph = null;
        for (TarReader reader : TarFiles.iterable(head)) {
            if (!fileName.equals(reader.getFile().getName())) continue;
            index = reader.getUUIDs();
            graph = reader.getGraph();
            break;
        }
        HashMap<UUID, Set<UUID>> result = new HashMap<UUID, Set<UUID>>();
        if (index != null) {
            for (UUID uUID : index) {
                result.put(uUID, Collections.emptySet());
            }
        }
        if (graph != null) {
            for (Map.Entry entry : graph.entrySet()) {
                result.put((UUID)entry.getKey(), new HashSet((Collection)entry.getValue()));
            }
        }
        return result;
    }

    public Map<String, Set<UUID>> getIndices() {
        Node head;
        this.lock.readLock().lock();
        try {
            head = this.readers;
        }
        finally {
            this.lock.readLock().unlock();
        }
        HashMap<String, Set<UUID>> index = new HashMap<String, Set<UUID>>();
        for (TarReader reader : TarFiles.iterable(head)) {
            index.put(reader.getFile().getName(), reader.getUUIDs());
        }
        return index;
    }

    public static class Builder {
        private File directory;
        private boolean memoryMapping;
        private TarRecovery tarRecovery;
        private IOMonitor ioMonitor;
        private FileStoreMonitor fileStoreMonitor;
        private long maxFileSize;
        private boolean readOnly;

        private Builder() {
        }

        public Builder withDirectory(File directory) {
            this.directory = (File)Preconditions.checkNotNull((Object)directory);
            return this;
        }

        public Builder withMemoryMapping(boolean memoryMapping) {
            this.memoryMapping = memoryMapping;
            return this;
        }

        public Builder withTarRecovery(TarRecovery tarRecovery) {
            this.tarRecovery = (TarRecovery)Preconditions.checkNotNull((Object)tarRecovery);
            return this;
        }

        public Builder withIOMonitor(IOMonitor ioMonitor) {
            this.ioMonitor = (IOMonitor)Preconditions.checkNotNull((Object)ioMonitor);
            return this;
        }

        public Builder withFileStoreMonitor(FileStoreMonitor fileStoreStats) {
            this.fileStoreMonitor = (FileStoreMonitor)Preconditions.checkNotNull((Object)fileStoreStats);
            return this;
        }

        public Builder withMaxFileSize(long maxFileSize) {
            Preconditions.checkArgument((maxFileSize > 0L ? 1 : 0) != 0);
            this.maxFileSize = maxFileSize;
            return this;
        }

        public Builder withReadOnly() {
            this.readOnly = true;
            return this;
        }

        public TarFiles build() throws IOException {
            Preconditions.checkState((this.directory != null ? 1 : 0) != 0, (Object)"Directory not specified");
            Preconditions.checkState((this.tarRecovery != null ? 1 : 0) != 0, (Object)"TAR recovery strategy not specified");
            Preconditions.checkState((this.ioMonitor != null ? 1 : 0) != 0, (Object)"I/O monitor not specified");
            Preconditions.checkState((this.readOnly || this.fileStoreMonitor != null ? 1 : 0) != 0, (Object)"File store statistics not specified");
            Preconditions.checkState((this.readOnly || this.maxFileSize != 0L ? 1 : 0) != 0, (Object)"Max file size not specified");
            return new TarFiles(this);
        }
    }

    public static class CleanupResult {
        private boolean interrupted;
        private long reclaimedSize;
        private List<File> removableFiles;
        private Set<UUID> reclaimedSegmentIds;

        private CleanupResult() {
        }

        public long getReclaimedSize() {
            return this.reclaimedSize;
        }

        public List<File> getRemovableFiles() {
            return this.removableFiles;
        }

        public Set<UUID> getReclaimedSegmentIds() {
            return this.reclaimedSegmentIds;
        }

        public boolean isInterrupted() {
            return this.interrupted;
        }
    }

    private static class Node {
        final TarReader reader;
        final Node next;

        Node(TarReader reader, Node next) {
            this.reader = reader;
            this.next = next;
        }
    }
}

