/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.segment.file.tar;

import java.util.Comparator;
import org.apache.jackrabbit.oak.segment.file.tar.GCGeneration;

class TarEntry {
    static final int SIZE = 33;
    static final Comparator<TarEntry> OFFSET_ORDER = new Comparator<TarEntry>(){

        @Override
        public int compare(TarEntry a, TarEntry b) {
            if (a.offset > b.offset) {
                return 1;
            }
            if (a.offset < b.offset) {
                return -1;
            }
            return 0;
        }
    };
    private final long msb;
    private final long lsb;
    private final int offset;
    private final int size;
    private final GCGeneration generation;

    TarEntry(long msb, long lsb, int offset, int size, GCGeneration generation) {
        this.msb = msb;
        this.lsb = lsb;
        this.offset = offset;
        this.size = size;
        this.generation = generation;
    }

    long msb() {
        return this.msb;
    }

    long lsb() {
        return this.lsb;
    }

    int offset() {
        return this.offset;
    }

    int size() {
        return this.size;
    }

    GCGeneration generation() {
        return this.generation;
    }
}

