/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.segment.file.tar;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import javax.annotation.Nonnull;

public final class GCGeneration {
    public static final GCGeneration NULL = new GCGeneration(0, 0, false);
    private final int generation;
    private final int fullGeneration;
    private final boolean isCompacted;

    public static GCGeneration newGCGeneration(int generation, int fullGeneration, boolean isCompacted) {
        return new GCGeneration(generation, fullGeneration, isCompacted);
    }

    private GCGeneration(int generation, int fullGeneration, boolean isCompacted) {
        this.generation = generation;
        this.fullGeneration = fullGeneration;
        this.isCompacted = isCompacted;
    }

    public int getGeneration() {
        return this.generation;
    }

    public int getFullGeneration() {
        return this.fullGeneration;
    }

    public boolean isCompacted() {
        return this.isCompacted;
    }

    @Nonnull
    public GCGeneration nextFull() {
        return new GCGeneration(this.generation + 1, this.fullGeneration + 1, true);
    }

    @Nonnull
    public GCGeneration nextTail() {
        return new GCGeneration(this.generation + 1, this.fullGeneration, true);
    }

    @Nonnull
    public GCGeneration nonGC() {
        return new GCGeneration(this.generation, this.fullGeneration, false);
    }

    public int compareWith(@Nonnull GCGeneration gcGeneration) {
        return this.generation - ((GCGeneration)Preconditions.checkNotNull((Object)gcGeneration)).generation;
    }

    public int compareFullGenerationWith(@Nonnull GCGeneration gcGeneration) {
        return this.fullGeneration - ((GCGeneration)Preconditions.checkNotNull((Object)gcGeneration)).fullGeneration;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        GCGeneration that = (GCGeneration)other;
        return this.generation == that.generation && this.fullGeneration == that.fullGeneration && this.isCompacted == that.isCompacted;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.generation, this.fullGeneration, this.isCompacted});
    }

    public String toString() {
        return "GCGeneration{generation=" + this.generation + ',' + "fullGeneration=" + this.fullGeneration + ',' + "isCompacted=" + this.isCompacted + '}';
    }
}

