/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.segment.file.tar;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;

abstract class FileAccess {
    FileAccess() {
    }

    abstract boolean isMemoryMapped();

    abstract int length() throws IOException;

    abstract ByteBuffer read(int var1, int var2) throws IOException;

    abstract void close() throws IOException;

    static class Random
    extends FileAccess {
        private final RandomAccessFile file;

        Random(RandomAccessFile file) {
            this.file = file;
        }

        @Override
        boolean isMemoryMapped() {
            return false;
        }

        @Override
        public synchronized int length() throws IOException {
            long length = this.file.length();
            Preconditions.checkState((length < Integer.MAX_VALUE ? 1 : 0) != 0);
            return (int)length;
        }

        @Override
        public synchronized ByteBuffer read(int position, int length) throws IOException {
            ByteBuffer entry = ByteBuffer.allocate(length);
            this.file.seek(position);
            this.file.readFully(entry.array());
            return entry;
        }

        @Override
        public synchronized void close() throws IOException {
            this.file.close();
        }
    }

    static class Mapped
    extends FileAccess {
        private final RandomAccessFile file;
        private MappedByteBuffer buffer;

        Mapped(RandomAccessFile file) throws IOException {
            this.file = file;
            this.buffer = file.getChannel().map(FileChannel.MapMode.READ_ONLY, 0L, file.length());
        }

        @Override
        boolean isMemoryMapped() {
            return true;
        }

        @Override
        public int length() {
            return this.buffer.remaining();
        }

        @Override
        public ByteBuffer read(int position, int length) {
            ByteBuffer entry = this.buffer.asReadOnlyBuffer();
            entry.position(entry.position() + position);
            entry.limit(entry.position() + length);
            return entry.slice();
        }

        @Override
        public void close() throws IOException {
            this.buffer = null;
            this.file.close();
        }
    }
}

