/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.segment.file;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import org.apache.jackrabbit.oak.segment.RecordId;
import org.apache.jackrabbit.oak.segment.Revisions;
import org.apache.jackrabbit.oak.segment.SegmentIdProvider;
import org.apache.jackrabbit.oak.segment.SegmentStore;
import org.apache.jackrabbit.oak.segment.file.FileStoreUtil;
import org.apache.jackrabbit.oak.segment.file.Flusher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TarRevisions
implements Revisions,
Closeable {
    private static final Logger LOG = LoggerFactory.getLogger(TarRevisions.class);
    public static final String JOURNAL_FILE_NAME = "journal.log";
    private final Lock journalFileLock = new ReentrantLock();
    @Nonnull
    private final AtomicReference<RecordId> head;
    @Nonnull
    private final File directory;
    private volatile RandomAccessFile journalFile;
    @Nonnull
    private final AtomicReference<RecordId> persistedHead;
    @Nonnull
    private final ReadWriteLock rwLock = new ReentrantReadWriteLock(true);
    public static final Revisions.Option EXPEDITE_OPTION = new Revisions.Option(){

        public String toString() {
            return "Expedite Option";
        }
    };
    public static final Revisions.Option INFINITY = new TimeOutOption(Long.MAX_VALUE, TimeUnit.DAYS);

    public static Revisions.Option timeout(long time, TimeUnit unit) {
        return new TimeOutOption(time, unit);
    }

    public TarRevisions(@Nonnull File directory) throws IOException {
        this.directory = (File)Preconditions.checkNotNull((Object)directory);
        this.journalFile = new RandomAccessFile(new File(directory, JOURNAL_FILE_NAME), "rw");
        this.journalFile.seek(this.journalFile.length());
        this.head = new AtomicReference<Object>(null);
        this.persistedHead = new AtomicReference<Object>(null);
    }

    synchronized void bind(@Nonnull SegmentStore store, @Nonnull SegmentIdProvider idProvider, @Nonnull Supplier<RecordId> writeInitialNode) throws IOException {
        if (this.head.get() != null) {
            return;
        }
        RecordId persistedId = FileStoreUtil.findPersistedRecordId(store, idProvider, new File(this.directory, JOURNAL_FILE_NAME));
        if (persistedId == null) {
            this.head.set((RecordId)writeInitialNode.get());
        } else {
            this.persistedHead.set(persistedId);
            this.head.set(persistedId);
        }
    }

    private void checkBound() {
        Preconditions.checkState((this.head.get() != null ? 1 : 0) != 0, (Object)"Revisions not bound to a store");
    }

    void flush(Flusher flusher) throws IOException {
        if (this.head.get() == null) {
            LOG.debug("No head available, skipping flush");
            return;
        }
        this.journalFileLock.lock();
        try {
            this.doFlush(flusher);
        }
        finally {
            this.journalFileLock.unlock();
        }
    }

    void tryFlush(Flusher flusher) throws IOException {
        if (this.head.get() == null) {
            LOG.debug("No head available, skipping flush");
            return;
        }
        if (this.journalFileLock.tryLock()) {
            try {
                this.doFlush(flusher);
            }
            finally {
                this.journalFileLock.unlock();
            }
        } else {
            LOG.debug("Unable to lock the journal, skipping flush");
        }
    }

    private void doFlush(Flusher flusher) throws IOException {
        if (this.journalFile == null) {
            LOG.debug("No journal file available, skipping flush");
            return;
        }
        RecordId before = this.persistedHead.get();
        RecordId after = this.getHead();
        if (after.equals(before)) {
            LOG.debug("Head state did not change, skipping flush");
            return;
        }
        flusher.flush();
        LOG.debug("TarMK journal update {} -> {}", (Object)before, (Object)after);
        this.journalFile.writeBytes(after.toString10() + " root " + System.currentTimeMillis() + "\n");
        this.journalFile.getChannel().force(false);
        this.persistedHead.set(after);
    }

    @Override
    @Nonnull
    public RecordId getHead() {
        this.checkBound();
        return this.head.get();
    }

    @Override
    @Nonnull
    public RecordId getPersistedHead() {
        this.checkBound();
        return this.persistedHead.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean setHead(@Nonnull RecordId expected, @Nonnull RecordId head, Revisions.Option ... options) {
        this.checkBound();
        Lock lock = TarRevisions.isExpedited(options) ? this.rwLock.writeLock() : this.rwLock.readLock();
        lock.lock();
        try {
            RecordId id = this.head.get();
            boolean bl = id.equals(expected) && this.head.compareAndSet(id, head);
            return bl;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RecordId setHead(@Nonnull Function<RecordId, RecordId> newHead, Revisions.Option ... options) throws InterruptedException {
        this.checkBound();
        TimeOutOption timeout = TarRevisions.getTimeout(options);
        if (this.rwLock.writeLock().tryLock(timeout.time, timeout.unit)) {
            try {
                RecordId after = (RecordId)newHead.apply((Object)this.getHead());
                if (after != null) {
                    this.head.set(after);
                    RecordId recordId = after;
                    return recordId;
                }
                RecordId recordId = null;
                return recordId;
            }
            finally {
                this.rwLock.writeLock().unlock();
            }
        }
        return null;
    }

    private static boolean isExpedited(Revisions.Option[] options) {
        if (options.length == 0) {
            return false;
        }
        if (options.length == 1) {
            return options[0] == EXPEDITE_OPTION;
        }
        throw new IllegalArgumentException("Expected zero or one options, got " + options.length);
    }

    @Nonnull
    private static TimeOutOption getTimeout(@Nonnull Revisions.Option[] options) {
        if (options.length == 0) {
            return TimeOutOption.from(INFINITY);
        }
        if (options.length == 1) {
            return TimeOutOption.from(options[0]);
        }
        throw new IllegalArgumentException("Expected zero or one options, got " + options.length);
    }

    @Override
    public void close() throws IOException {
        this.journalFileLock.lock();
        try {
            if (this.journalFile == null) {
                return;
            }
            this.journalFile.close();
            this.journalFile = null;
        }
        finally {
            this.journalFileLock.unlock();
        }
    }

    private static class TimeOutOption
    implements Revisions.Option {
        private final long time;
        @Nonnull
        private final TimeUnit unit;

        TimeOutOption(long time, @Nonnull TimeUnit unit) {
            this.time = time;
            this.unit = unit;
        }

        @Nonnull
        public static TimeOutOption from(@CheckForNull Revisions.Option option) {
            if (option instanceof TimeOutOption) {
                return (TimeOutOption)option;
            }
            throw new IllegalArgumentException("Invalid option " + option);
        }
    }
}

