/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.segment.file;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import javax.annotation.Nonnull;
import org.apache.jackrabbit.oak.segment.file.GCEstimation;
import org.apache.jackrabbit.oak.segment.file.GCEstimationResult;
import org.apache.jackrabbit.oak.segment.file.GCJournal;
import org.apache.jackrabbit.oak.segment.file.PrintableBytes;

class SizeDeltaGcEstimation
implements GCEstimation {
    private final long delta;
    private final GCJournal gcJournal;
    private final long currentSize;
    private final boolean full;

    SizeDeltaGcEstimation(long delta, @Nonnull GCJournal gcJournal, long currentSize, boolean full) {
        this.delta = delta;
        this.gcJournal = (GCJournal)Preconditions.checkNotNull((Object)gcJournal);
        this.currentSize = currentSize;
        this.full = full;
    }

    @Override
    public GCEstimationResult estimate() {
        if (this.delta == 0L) {
            return new GCEstimationResult(true, "Estimation skipped because the size delta value equals 0");
        }
        long previousSize = this.readPreviousSize();
        if (previousSize < 0L) {
            return new GCEstimationResult(true, "Estimation skipped because of missing gc journal data (expected on first run)");
        }
        if (this.full && this.previousIsTail()) {
            return new GCEstimationResult(true, "Detected previous garbage collection of type tail so running full garbage collection now.");
        }
        long gain = this.currentSize - previousSize;
        boolean gcNeeded = gain > this.delta;
        String gcInfo = String.format("Segmentstore size has increased since the last %s garbage collection from %s to %s, an increase of %s or %s%%. ", this.full ? "full" : "tail", PrintableBytes.newPrintableBytes(previousSize), PrintableBytes.newPrintableBytes(this.currentSize), PrintableBytes.newPrintableBytes(gain), 100L * gain / previousSize);
        gcInfo = gcNeeded ? gcInfo + String.format("This is greater than sizeDeltaEstimation=%s, so running garbage collection", PrintableBytes.newPrintableBytes(this.delta)) : gcInfo + String.format("This is less than sizeDeltaEstimation=%s, so skipping garbage collection", PrintableBytes.newPrintableBytes(this.delta));
        return new GCEstimationResult(gcNeeded, gcInfo);
    }

    private long readPreviousSize() {
        if (this.full) {
            return this.readPreviousFullCleanupSize();
        }
        return this.readPreviousTailCleanupSize();
    }

    private long readPreviousFullCleanupSize() {
        ArrayList<GCJournal.GCJournalEntry> entries = new ArrayList<GCJournal.GCJournalEntry>(this.gcJournal.readAll());
        if (entries.isEmpty()) {
            return -1L;
        }
        entries.sort((a, b) -> {
            if (a.getGcGeneration().getFullGeneration() > b.getGcGeneration().getFullGeneration()) {
                return -1;
            }
            if (a.getGcGeneration().getFullGeneration() < b.getGcGeneration().getFullGeneration()) {
                return 1;
            }
            return Integer.compare(a.getGcGeneration().getGeneration(), b.getGcGeneration().getGeneration());
        });
        return ((GCJournal.GCJournalEntry)entries.iterator().next()).getRepoSize();
    }

    private long readPreviousTailCleanupSize() {
        return this.gcJournal.read().getRepoSize();
    }

    private boolean previousIsTail() {
        int n;
        ArrayList entries = Lists.newArrayList(this.gcJournal.readAll());
        if (entries.isEmpty()) {
            return true;
        }
        if (entries.size() == 1) {
            return false;
        }
        int m = ((GCJournal.GCJournalEntry)entries.get(entries.size() - 2)).getGcGeneration().getFullGeneration();
        return m == (n = ((GCJournal.GCJournalEntry)entries.get(entries.size() - 1)).getGcGeneration().getFullGeneration());
    }
}

