/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.segment.file;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.Nonnull;
import org.apache.jackrabbit.oak.segment.RecordId;
import org.apache.jackrabbit.oak.segment.Revisions;
import org.apache.jackrabbit.oak.segment.SegmentIdProvider;
import org.apache.jackrabbit.oak.segment.SegmentStore;
import org.apache.jackrabbit.oak.segment.file.FileStoreUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReadOnlyRevisions
implements Revisions,
Closeable {
    private static final Logger LOG = LoggerFactory.getLogger(ReadOnlyRevisions.class);
    public static final String JOURNAL_FILE_NAME = "journal.log";
    @Nonnull
    private final AtomicReference<RecordId> head;
    @Nonnull
    private final File directory;
    @Nonnull
    private final RandomAccessFile journalFile;

    public ReadOnlyRevisions(@Nonnull File directory) throws IOException {
        this.directory = (File)Preconditions.checkNotNull((Object)directory);
        this.journalFile = new RandomAccessFile(new File(directory, JOURNAL_FILE_NAME), "r");
        this.journalFile.seek(this.journalFile.length());
        this.head = new AtomicReference<Object>(null);
    }

    synchronized void bind(@Nonnull SegmentStore store, @Nonnull SegmentIdProvider idProvider) throws IOException {
        if (this.head.get() != null) {
            return;
        }
        RecordId persistedId = FileStoreUtil.findPersistedRecordId(store, idProvider, new File(this.directory, JOURNAL_FILE_NAME));
        if (persistedId == null) {
            throw new IllegalStateException("Cannot start readonly store from empty journal");
        }
        this.head.set(persistedId);
    }

    private void checkBound() {
        Preconditions.checkState((this.head.get() != null ? 1 : 0) != 0, (Object)"Revisions not bound to a store");
    }

    @Override
    @Nonnull
    public RecordId getHead() {
        this.checkBound();
        return this.head.get();
    }

    @Override
    @Nonnull
    public RecordId getPersistedHead() {
        return this.getHead();
    }

    @Override
    public boolean setHead(@Nonnull RecordId expected, @Nonnull RecordId head, Revisions.Option ... options) {
        this.checkBound();
        RecordId id = this.head.get();
        return id.equals(expected) && this.head.compareAndSet(id, head);
    }

    @Override
    public RecordId setHead(@Nonnull Function<RecordId, RecordId> newHead, Revisions.Option ... options) throws InterruptedException {
        throw new UnsupportedOperationException("ReadOnly Revisions");
    }

    @Override
    public void close() throws IOException {
        this.journalFile.close();
    }
}

