/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.segment.file;

import java.io.File;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;
import org.apache.jackrabbit.oak.segment.file.tar.IOMonitorAdapter;
import org.apache.jackrabbit.oak.stats.MeterStats;
import org.apache.jackrabbit.oak.stats.StatisticsProvider;
import org.apache.jackrabbit.oak.stats.StatsOptions;
import org.apache.jackrabbit.oak.stats.TimerStats;

public class MetricsIOMonitor
extends IOMonitorAdapter {
    public static final String OAK_SEGMENT_SEGMENT_READ_BYTES = "oak.segment.segment-read-bytes";
    public static final String OAK_SEGMENT_SEGMENT_WRITE_BYTES = "oak.segment.segment-write-bytes";
    public static final String OAK_SEGMENT_SEGMENT_READ_TIME = "oak.segment.segment-read-time";
    public static final String OAK_SEGMENT_SEGMENT_WRITE_TIME = "oak.segment.segment-write-time";
    private final MeterStats segmentReadBytes;
    private final MeterStats segmentWriteBytes;
    private final TimerStats segmentReadTime;
    private final TimerStats segmentWriteTime;

    public MetricsIOMonitor(@Nonnull StatisticsProvider statisticsProvider) {
        this.segmentReadBytes = statisticsProvider.getMeter(OAK_SEGMENT_SEGMENT_READ_BYTES, StatsOptions.METRICS_ONLY);
        this.segmentWriteBytes = statisticsProvider.getMeter(OAK_SEGMENT_SEGMENT_WRITE_BYTES, StatsOptions.METRICS_ONLY);
        this.segmentReadTime = statisticsProvider.getTimer(OAK_SEGMENT_SEGMENT_READ_TIME, StatsOptions.METRICS_ONLY);
        this.segmentWriteTime = statisticsProvider.getTimer(OAK_SEGMENT_SEGMENT_WRITE_TIME, StatsOptions.METRICS_ONLY);
    }

    @Override
    public void afterSegmentRead(File file, long msb, long lsb, int length, long elapsed) {
        this.segmentReadBytes.mark((long)length);
        this.segmentReadTime.update(elapsed, TimeUnit.NANOSECONDS);
    }

    @Override
    public void afterSegmentWrite(File file, long msb, long lsb, int length, long elapsed) {
        this.segmentWriteBytes.mark((long)length);
        this.segmentWriteTime.update(elapsed, TimeUnit.NANOSECONDS);
    }
}

