/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.segment.file;

import java.io.File;
import java.io.IOException;
import org.apache.jackrabbit.oak.segment.RecordId;
import org.apache.jackrabbit.oak.segment.SegmentIdProvider;
import org.apache.jackrabbit.oak.segment.SegmentStore;
import org.apache.jackrabbit.oak.segment.file.JournalEntry;
import org.apache.jackrabbit.oak.segment.file.JournalReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class FileStoreUtil {
    private static final Logger log = LoggerFactory.getLogger(FileStoreUtil.class);

    private FileStoreUtil() {
    }

    static RecordId findPersistedRecordId(SegmentStore store, SegmentIdProvider idProvider, File journal) throws IOException {
        try (JournalReader journalReader = new JournalReader(journal);){
            while (journalReader.hasNext()) {
                RecordId id;
                JournalEntry entry;
                block19: {
                    entry = (JournalEntry)journalReader.next();
                    id = RecordId.fromString(idProvider, entry.getRevision());
                    if (!store.containsSegment(id.getSegmentId())) break block19;
                    RecordId recordId = id;
                    return recordId;
                }
                try {
                    log.warn("Unable to access revision {}, rewinding...", (Object)id);
                }
                catch (IllegalArgumentException ignore) {
                    log.warn("Skipping invalid record id {}", (Object)entry);
                }
            }
        }
        return null;
    }
}

