/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.segment.file;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import java.io.File;
import java.io.IOException;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import org.apache.jackrabbit.oak.segment.CacheWeights;
import org.apache.jackrabbit.oak.segment.RecordCache;
import org.apache.jackrabbit.oak.segment.SegmentNotFoundExceptionListener;
import org.apache.jackrabbit.oak.segment.WriterCacheManager;
import org.apache.jackrabbit.oak.segment.compaction.SegmentGCOptions;
import org.apache.jackrabbit.oak.segment.file.FileStore;
import org.apache.jackrabbit.oak.segment.file.GCListener;
import org.apache.jackrabbit.oak.segment.file.InvalidFileStoreVersionException;
import org.apache.jackrabbit.oak.segment.file.PriorityCache;
import org.apache.jackrabbit.oak.segment.file.ReadOnlyFileStore;
import org.apache.jackrabbit.oak.segment.file.ReadOnlyRevisions;
import org.apache.jackrabbit.oak.segment.file.TarRevisions;
import org.apache.jackrabbit.oak.segment.file.tar.GCGeneration;
import org.apache.jackrabbit.oak.segment.file.tar.IOMonitor;
import org.apache.jackrabbit.oak.segment.file.tar.IOMonitorAdapter;
import org.apache.jackrabbit.oak.spi.blob.BlobStore;
import org.apache.jackrabbit.oak.spi.gc.DelegatingGCMonitor;
import org.apache.jackrabbit.oak.spi.gc.GCMonitor;
import org.apache.jackrabbit.oak.spi.gc.LoggingGCMonitor;
import org.apache.jackrabbit.oak.stats.StatisticsProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileStoreBuilder {
    private static final Logger LOG = LoggerFactory.getLogger(FileStore.class);
    private static final boolean MEMORY_MAPPING_DEFAULT = "64".equals(System.getProperty("sun.arch.data.model", "32"));
    public static final int DEFAULT_MAX_FILE_SIZE = 256;
    @Nonnull
    private final File directory;
    @CheckForNull
    private BlobStore blobStore;
    private int maxFileSize = 256;
    private int segmentCacheSize = 256;
    private int stringCacheSize = 256;
    private int templateCacheSize = 64;
    private int stringDeduplicationCacheSize = WriterCacheManager.DEFAULT_STRING_CACHE_SIZE;
    private int templateDeduplicationCacheSize = WriterCacheManager.DEFAULT_TEMPLATE_CACHE_SIZE;
    private int nodeDeduplicationCacheSize = WriterCacheManager.DEFAULT_NODE_CACHE_SIZE;
    private boolean memoryMapping = MEMORY_MAPPING_DEFAULT;
    @Nonnull
    private StatisticsProvider statsProvider = StatisticsProvider.NOOP;
    @Nonnull
    private SegmentGCOptions gcOptions = SegmentGCOptions.defaultGCOptions();
    @CheckForNull
    private EvictingWriteCacheManager cacheManager;
    @Nonnull
    private final FileStoreGCListener gcListener = new FileStoreGCListener();
    @Nonnull
    private SegmentNotFoundExceptionListener snfeListener = SegmentNotFoundExceptionListener.LOG_SNFE;
    private IOMonitor ioMonitor = new IOMonitorAdapter();
    private boolean strictVersionCheck;
    private boolean built;

    @Nonnull
    public static FileStoreBuilder fileStoreBuilder(@Nonnull File directory) {
        return new FileStoreBuilder(directory);
    }

    private FileStoreBuilder(@Nonnull File directory) {
        this.directory = (File)Preconditions.checkNotNull((Object)directory);
        this.gcListener.registerGCMonitor((GCMonitor)new LoggingGCMonitor(LOG));
    }

    @Nonnull
    public FileStoreBuilder withBlobStore(@Nonnull BlobStore blobStore) {
        this.blobStore = (BlobStore)Preconditions.checkNotNull((Object)blobStore);
        return this;
    }

    @Nonnull
    public FileStoreBuilder withMaxFileSize(int maxFileSize) {
        this.maxFileSize = maxFileSize;
        return this;
    }

    @Nonnull
    public FileStoreBuilder withSegmentCacheSize(int segmentCacheSize) {
        this.segmentCacheSize = segmentCacheSize;
        return this;
    }

    @Nonnull
    public FileStoreBuilder withStringCacheSize(int stringCacheSize) {
        this.stringCacheSize = stringCacheSize;
        return this;
    }

    @Nonnull
    public FileStoreBuilder withTemplateCacheSize(int templateCacheSize) {
        this.templateCacheSize = templateCacheSize;
        return this;
    }

    @Nonnull
    public FileStoreBuilder withStringDeduplicationCacheSize(int stringDeduplicationCacheSize) {
        this.stringDeduplicationCacheSize = stringDeduplicationCacheSize;
        return this;
    }

    @Nonnull
    public FileStoreBuilder withTemplateDeduplicationCacheSize(int templateDeduplicationCacheSize) {
        this.templateDeduplicationCacheSize = templateDeduplicationCacheSize;
        return this;
    }

    @Nonnull
    public FileStoreBuilder withNodeDeduplicationCacheSize(int nodeDeduplicationCacheSize) {
        this.nodeDeduplicationCacheSize = nodeDeduplicationCacheSize;
        return this;
    }

    @Nonnull
    public FileStoreBuilder withMemoryMapping(boolean memoryMapping) {
        this.memoryMapping = memoryMapping;
        return this;
    }

    @Nonnull
    public FileStoreBuilder withDefaultMemoryMapping() {
        this.memoryMapping = MEMORY_MAPPING_DEFAULT;
        return this;
    }

    @Nonnull
    public FileStoreBuilder withGCMonitor(@Nonnull GCMonitor gcMonitor) {
        this.gcListener.registerGCMonitor((GCMonitor)Preconditions.checkNotNull((Object)gcMonitor));
        return this;
    }

    @Nonnull
    public FileStoreBuilder withStatisticsProvider(@Nonnull StatisticsProvider statisticsProvider) {
        this.statsProvider = (StatisticsProvider)Preconditions.checkNotNull((Object)statisticsProvider);
        return this;
    }

    @Nonnull
    public FileStoreBuilder withGCOptions(SegmentGCOptions gcOptions) {
        this.gcOptions = (SegmentGCOptions)Preconditions.checkNotNull((Object)gcOptions);
        return this;
    }

    @Nonnull
    public FileStoreBuilder withSnfeListener(@Nonnull SegmentNotFoundExceptionListener snfeListener) {
        this.snfeListener = (SegmentNotFoundExceptionListener)Preconditions.checkNotNull((Object)snfeListener);
        return this;
    }

    @Nonnull
    public FileStoreBuilder withIOMonitor(IOMonitor ioMonitor) {
        this.ioMonitor = (IOMonitor)Preconditions.checkNotNull((Object)ioMonitor);
        return this;
    }

    @Nonnull
    public FileStoreBuilder withStrictVersionCheck(boolean strictVersionCheck) {
        this.strictVersionCheck = strictVersionCheck;
        return this;
    }

    @Nonnull
    public FileStore build() throws InvalidFileStoreVersionException, IOException {
        FileStore store;
        Preconditions.checkState((!this.built ? 1 : 0) != 0, (Object)"Cannot re-use builder");
        this.built = true;
        this.directory.mkdirs();
        TarRevisions revisions = new TarRevisions(this.directory);
        LOG.info("Creating file store {}", (Object)this);
        try {
            store = new FileStore(this);
        }
        catch (IOException | InvalidFileStoreVersionException e) {
            try {
                revisions.close();
            }
            catch (IOException re) {
                LOG.warn("Unable to close TarRevisions", (Throwable)re);
            }
            throw e;
        }
        store.bind(revisions);
        return store;
    }

    @Nonnull
    public ReadOnlyFileStore buildReadOnly() throws InvalidFileStoreVersionException, IOException {
        ReadOnlyFileStore store;
        Preconditions.checkState((!this.built ? 1 : 0) != 0, (Object)"Cannot re-use builder");
        Preconditions.checkState((this.directory.exists() && this.directory.isDirectory() ? 1 : 0) != 0, (String)"%s does not exist or is not a directory", (Object[])new Object[]{this.directory});
        this.built = true;
        ReadOnlyRevisions revisions = new ReadOnlyRevisions(this.directory);
        LOG.info("Creating file store {}", (Object)this);
        try {
            store = new ReadOnlyFileStore(this);
        }
        catch (IOException | InvalidFileStoreVersionException e) {
            try {
                revisions.close();
            }
            catch (IOException re) {
                LOG.warn("Unable to close ReadOnlyRevisions", (Throwable)re);
            }
            throw e;
        }
        store.bind(revisions);
        return store;
    }

    @Nonnull
    File getDirectory() {
        return this.directory;
    }

    @CheckForNull
    BlobStore getBlobStore() {
        return this.blobStore;
    }

    public int getMaxFileSize() {
        return this.maxFileSize;
    }

    int getSegmentCacheSize() {
        return this.segmentCacheSize;
    }

    int getStringCacheSize() {
        return this.stringCacheSize;
    }

    int getTemplateCacheSize() {
        return this.templateCacheSize;
    }

    boolean getMemoryMapping() {
        return this.memoryMapping;
    }

    @Nonnull
    GCListener getGcListener() {
        return this.gcListener;
    }

    @Nonnull
    StatisticsProvider getStatsProvider() {
        return this.statsProvider;
    }

    @Nonnull
    SegmentGCOptions getGcOptions() {
        return this.gcOptions;
    }

    @Nonnull
    SegmentNotFoundExceptionListener getSnfeListener() {
        return this.snfeListener;
    }

    @Nonnull
    public WriterCacheManager getCacheManager() {
        if (this.cacheManager == null) {
            this.cacheManager = new EvictingWriteCacheManager(this.stringDeduplicationCacheSize, this.templateDeduplicationCacheSize, this.nodeDeduplicationCacheSize);
        }
        return this.cacheManager;
    }

    IOMonitor getIOMonitor() {
        return this.ioMonitor;
    }

    boolean getStrictVersionCheck() {
        return this.strictVersionCheck;
    }

    public String toString() {
        return "FileStoreBuilder{version=" + this.getClass().getPackage().getImplementationVersion() + ", directory=" + this.directory + ", blobStore=" + this.blobStore + ", maxFileSize=" + this.maxFileSize + ", segmentCacheSize=" + this.segmentCacheSize + ", stringCacheSize=" + this.stringCacheSize + ", templateCacheSize=" + this.templateCacheSize + ", stringDeduplicationCacheSize=" + this.stringDeduplicationCacheSize + ", templateDeduplicationCacheSize=" + this.templateDeduplicationCacheSize + ", nodeDeduplicationCacheSize=" + this.nodeDeduplicationCacheSize + ", memoryMapping=" + this.memoryMapping + ", gcOptions=" + this.gcOptions + '}';
    }

    private static class EvictingWriteCacheManager
    extends WriterCacheManager.Default {
        public EvictingWriteCacheManager(int stringCacheSize, int templateCacheSize, int nodeCacheSize) {
            super(RecordCache.factory(stringCacheSize, new CacheWeights.StringCacheWeigher()), RecordCache.factory(templateCacheSize, new CacheWeights.TemplateCacheWeigher()), PriorityCache.factory(nodeCacheSize, new CacheWeights.NodeCacheWeigher()));
        }

        void evictOldGeneration(final int newGeneration) {
            this.evictCaches(new Predicate<Integer>(){

                public boolean apply(Integer generation) {
                    return generation < newGeneration;
                }
            });
        }

        void evictGeneration(final int newGeneration) {
            this.evictCaches(new Predicate<Integer>(){

                public boolean apply(Integer generation) {
                    return generation == newGeneration;
                }
            });
        }
    }

    private class FileStoreGCListener
    extends DelegatingGCMonitor
    implements GCListener {
        private FileStoreGCListener() {
        }

        @Override
        public void compactionSucceeded(@Nonnull GCGeneration newGeneration) {
            this.compacted();
            if (FileStoreBuilder.this.cacheManager != null) {
                FileStoreBuilder.this.cacheManager.evictOldGeneration(newGeneration.getGeneration());
            }
        }

        @Override
        public void compactionFailed(@Nonnull GCGeneration failedGeneration) {
            if (FileStoreBuilder.this.cacheManager != null) {
                FileStoreBuilder.this.cacheManager.evictGeneration(failedGeneration.getGeneration());
            }
        }
    }
}

