/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.segment.file;

import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class FileReaper {
    private static final Logger logger = LoggerFactory.getLogger(FileReaper.class);
    private final Set<File> files = new HashSet<File>();
    private final Object lock = new Object();

    FileReaper() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void add(Iterable<File> files) {
        Object object = this.lock;
        synchronized (object) {
            for (File file : files) {
                this.files.add(file);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void reap() {
        HashSet<File> reap;
        Object object = this.lock;
        synchronized (object) {
            reap = new HashSet<File>(this.files);
            this.files.clear();
        }
        HashSet<File> redo = new HashSet<File>();
        ArrayList removed = Lists.newArrayList();
        for (File file : reap) {
            try {
                Files.deleteIfExists(file.toPath());
                removed.add(file);
            }
            catch (IOException e) {
                logger.warn(String.format("Unable to remove file %s", file), (Throwable)e);
                redo.add(file);
            }
        }
        if (!removed.isEmpty()) {
            logger.info("Removed files {}", (Object)Joiner.on((String)",").join((Iterable)removed));
        }
        if (redo.isEmpty()) {
            return;
        }
        this.add(redo);
    }
}

