/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.segment.data;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.WritableByteChannel;
import org.apache.commons.io.HexDump;

class SegmentDataUtils {
    private static final int MAX_SEGMENT_SIZE = 262144;

    private SegmentDataUtils() {
    }

    static void hexDump(ByteBuffer buffer, OutputStream stream) throws IOException {
        byte[] data = new byte[buffer.remaining()];
        buffer.duplicate().get(data);
        HexDump.dump((byte[])data, (long)0L, (OutputStream)stream, (int)0);
    }

    static void binDump(ByteBuffer buffer, OutputStream stream) throws IOException {
        ByteBuffer data = buffer.duplicate();
        try (WritableByteChannel channel = Channels.newChannel(stream);){
            while (data.hasRemaining()) {
                channel.write(data);
            }
        }
    }

    static int estimateMemoryUsage(ByteBuffer buffer) {
        return buffer.isDirect() ? 0 : buffer.remaining();
    }

    static ByteBuffer readBytes(ByteBuffer buffer, int index, int size) {
        ByteBuffer duplicate = buffer.duplicate();
        duplicate.position(index);
        duplicate.limit(index + size);
        return duplicate.slice();
    }

    static int index(ByteBuffer buffer, int recordReferenceOffset) {
        return buffer.limit() - (262144 - recordReferenceOffset);
    }
}

