/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.segment.data;

import java.nio.ByteBuffer;
import org.apache.jackrabbit.oak.segment.data.SegmentData;
import org.apache.jackrabbit.oak.segment.data.SegmentDataRaw;
import org.apache.jackrabbit.oak.segment.data.SegmentDataV12;
import org.apache.jackrabbit.oak.segment.data.SegmentDataV13;

class SegmentDataLoader {
    private static final int VERSION_OFFSET = 3;
    private static final byte SEGMENT_DATA_V12 = 12;
    private static final byte SEGMENT_DATA_V13 = 13;

    static SegmentData newSegmentData(ByteBuffer buffer) {
        switch (buffer.get(3)) {
            case 12: {
                return new SegmentDataV12(buffer);
            }
            case 13: {
                return new SegmentDataV13(buffer);
            }
        }
        throw new IllegalArgumentException("invalid segment buffer");
    }

    static SegmentData newRawSegmentData(ByteBuffer buffer) {
        return new SegmentDataRaw(buffer);
    }

    private SegmentDataLoader() {
    }
}

