/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.segment.data;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import org.apache.jackrabbit.oak.segment.data.RecordIdData;
import org.apache.jackrabbit.oak.segment.data.SegmentDataLoader;
import org.apache.jackrabbit.oak.segment.data.StringData;

public interface SegmentData {
    public static SegmentData newSegmentData(ByteBuffer buffer) {
        return SegmentDataLoader.newSegmentData(buffer);
    }

    public static SegmentData newRawSegmentData(ByteBuffer buffer) {
        return SegmentDataLoader.newRawSegmentData(buffer);
    }

    public byte getVersion();

    public String getSignature();

    public int getFullGeneration();

    public boolean isCompacted();

    public int getGeneration();

    public int getSegmentReferencesCount();

    public int getRecordReferencesCount();

    public int getRecordReferenceNumber(int var1);

    public byte getRecordReferenceType(int var1);

    public int getRecordReferenceOffset(int var1);

    public long getSegmentReferenceMsb(int var1);

    public long getSegmentReferenceLsb(int var1);

    public long readLength(int var1);

    public StringData readString(int var1);

    public RecordIdData readRecordId(int var1);

    public byte readByte(int var1);

    public int readInt(int var1);

    public short readShort(int var1);

    public long readLong(int var1);

    public ByteBuffer readBytes(int var1, int var2);

    public int size();

    public void hexDump(OutputStream var1) throws IOException;

    public void binDump(OutputStream var1) throws IOException;

    public int estimateMemoryUsage();
}

