/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.segment;

import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.jackrabbit.oak.api.Blob;
import org.apache.jackrabbit.oak.api.CommitFailedException;
import org.apache.jackrabbit.oak.api.PropertyState;
import org.apache.jackrabbit.oak.api.Type;
import org.apache.jackrabbit.oak.plugins.blob.BlobStoreBlob;
import org.apache.jackrabbit.oak.segment.Revisions;
import org.apache.jackrabbit.oak.segment.SegmentBlob;
import org.apache.jackrabbit.oak.segment.SegmentNodeBuilder;
import org.apache.jackrabbit.oak.segment.SegmentNodeState;
import org.apache.jackrabbit.oak.segment.SegmentNodeStoreStats;
import org.apache.jackrabbit.oak.segment.SegmentReader;
import org.apache.jackrabbit.oak.segment.SegmentWriter;
import org.apache.jackrabbit.oak.segment.scheduler.Commit;
import org.apache.jackrabbit.oak.segment.scheduler.LockBasedScheduler;
import org.apache.jackrabbit.oak.segment.scheduler.Scheduler;
import org.apache.jackrabbit.oak.spi.blob.BlobStore;
import org.apache.jackrabbit.oak.spi.commit.CommitHook;
import org.apache.jackrabbit.oak.spi.commit.CommitInfo;
import org.apache.jackrabbit.oak.spi.commit.Observable;
import org.apache.jackrabbit.oak.spi.commit.Observer;
import org.apache.jackrabbit.oak.spi.state.ConflictAnnotatingRebaseDiff;
import org.apache.jackrabbit.oak.spi.state.NodeBuilder;
import org.apache.jackrabbit.oak.spi.state.NodeState;
import org.apache.jackrabbit.oak.spi.state.NodeStateDiff;
import org.apache.jackrabbit.oak.spi.state.NodeStore;
import org.apache.jackrabbit.oak.stats.StatisticsProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SegmentNodeStore
implements NodeStore,
Observable {
    static final String ROOT = "root";
    public static final String CHECKPOINTS = "checkpoints";
    @Nonnull
    private final SegmentWriter writer;
    @Nonnull
    private final Scheduler scheduler;
    @CheckForNull
    private final BlobStore blobStore;
    private final SegmentNodeStoreStats stats;

    @Nonnull
    public static SegmentNodeStoreBuilder builder(@Nonnull Revisions revisions, @Nonnull SegmentReader reader, @Nonnull SegmentWriter writer, @Nullable BlobStore blobStore) {
        return new SegmentNodeStoreBuilder((Revisions)Preconditions.checkNotNull((Object)revisions), (SegmentReader)Preconditions.checkNotNull((Object)reader), (SegmentWriter)Preconditions.checkNotNull((Object)writer), blobStore);
    }

    private SegmentNodeStore(SegmentNodeStoreBuilder builder) {
        this.writer = builder.writer;
        this.blobStore = builder.blobStore;
        this.scheduler = LockBasedScheduler.builder(builder.revisions, builder.reader).dispatchChanges(builder.dispatchChanges).withStatisticsProvider(builder.statsProvider).build();
        this.stats = new SegmentNodeStoreStats(builder.statsProvider);
    }

    public Closeable addObserver(Observer observer) {
        if (this.scheduler instanceof Observable) {
            return ((Observable)this.scheduler).addObserver(observer);
        }
        return () -> {};
    }

    @Nonnull
    public NodeState getRoot() {
        return this.scheduler.getHeadNodeState().getChildNode(ROOT);
    }

    @Nonnull
    public NodeState merge(@Nonnull NodeBuilder builder, @Nonnull CommitHook commitHook, @Nonnull CommitInfo info) throws CommitFailedException {
        Preconditions.checkArgument((boolean)(builder instanceof SegmentNodeBuilder));
        Preconditions.checkArgument((boolean)((SegmentNodeBuilder)builder).isRootBuilder());
        return this.scheduler.schedule(new Commit(builder, commitHook, info), new Scheduler.SchedulerOption[0]);
    }

    @Nonnull
    public NodeState rebase(@Nonnull NodeBuilder builder) {
        Preconditions.checkArgument((boolean)(builder instanceof SegmentNodeBuilder));
        SegmentNodeBuilder snb = (SegmentNodeBuilder)builder;
        NodeState root = this.getRoot();
        NodeState before = snb.getBaseState();
        if (!SegmentNodeState.fastEquals(before, root)) {
            SegmentNodeState after = snb.getNodeState();
            snb.reset(root);
            after.compareAgainstBaseState(before, (NodeStateDiff)new ConflictAnnotatingRebaseDiff((NodeBuilder)snb));
        }
        return snb.getNodeState();
    }

    @Nonnull
    public NodeState reset(@Nonnull NodeBuilder builder) {
        Preconditions.checkArgument((boolean)(builder instanceof SegmentNodeBuilder));
        SegmentNodeBuilder snb = (SegmentNodeBuilder)builder;
        NodeState root = this.getRoot();
        snb.reset(root);
        return root;
    }

    @Nonnull
    public Blob createBlob(InputStream stream) throws IOException {
        return new SegmentBlob(this.blobStore, this.writer.writeStream(stream));
    }

    public Blob getBlob(@Nonnull String reference) {
        if (this.blobStore != null) {
            String blobId = this.blobStore.getBlobId(reference);
            if (blobId != null) {
                return new BlobStoreBlob(this.blobStore, blobId);
            }
            return null;
        }
        throw new IllegalStateException("Attempt to read external blob with blobId [" + reference + "] without specifying BlobStore");
    }

    @Nonnull
    public String checkpoint(long lifetime, @Nonnull Map<String, String> properties) {
        return this.scheduler.checkpoint(lifetime, properties);
    }

    @Nonnull
    public synchronized String checkpoint(long lifetime) {
        return this.checkpoint(lifetime, Collections.emptyMap());
    }

    @Nonnull
    public Map<String, String> checkpointInfo(@Nonnull String checkpoint) {
        HashMap properties = Maps.newHashMap();
        Preconditions.checkNotNull((Object)checkpoint);
        NodeState cp = this.scheduler.getHeadNodeState().getChildNode(CHECKPOINTS).getChildNode(checkpoint).getChildNode("properties");
        for (PropertyState prop : cp.getProperties()) {
            properties.put(prop.getName(), prop.getValue(Type.STRING));
        }
        return properties;
    }

    @Nonnull
    public Iterable<String> checkpoints() {
        return this.getCheckpoints().getChildNodeNames();
    }

    @CheckForNull
    public NodeState retrieve(@Nonnull String checkpoint) {
        Preconditions.checkNotNull((Object)checkpoint);
        NodeState cp = this.scheduler.getHeadNodeState().getChildNode(CHECKPOINTS).getChildNode(checkpoint).getChildNode(ROOT);
        if (cp.exists()) {
            return cp;
        }
        return null;
    }

    public boolean release(@Nonnull String checkpoint) {
        return this.scheduler.removeCheckpoint(checkpoint);
    }

    NodeState getCheckpoints() {
        return this.scheduler.getHeadNodeState().getChildNode(CHECKPOINTS);
    }

    public SegmentNodeStoreStats getStats() {
        return this.stats;
    }

    public static class SegmentNodeStoreBuilder {
        private static final Logger LOG = LoggerFactory.getLogger(SegmentNodeStoreBuilder.class);
        @Nonnull
        private final Revisions revisions;
        @Nonnull
        private final SegmentReader reader;
        @Nonnull
        private final SegmentWriter writer;
        @CheckForNull
        private final BlobStore blobStore;
        private boolean isCreated;
        private boolean dispatchChanges = true;
        @Nonnull
        private StatisticsProvider statsProvider = StatisticsProvider.NOOP;

        private SegmentNodeStoreBuilder(@Nonnull Revisions revisions, @Nonnull SegmentReader reader, @Nonnull SegmentWriter writer, @Nullable BlobStore blobStore) {
            this.revisions = revisions;
            this.reader = reader;
            this.writer = writer;
            this.blobStore = blobStore;
        }

        @Nonnull
        public SegmentNodeStoreBuilder dispatchChanges(boolean dispatchChanges) {
            this.dispatchChanges = dispatchChanges;
            return this;
        }

        @Nonnull
        public SegmentNodeStoreBuilder withStatisticsProvider(@Nonnull StatisticsProvider statisticsProvider) {
            this.statsProvider = (StatisticsProvider)Preconditions.checkNotNull((Object)statisticsProvider);
            return this;
        }

        @Nonnull
        public SegmentNodeStore build() {
            Preconditions.checkState((!this.isCreated ? 1 : 0) != 0);
            this.isCreated = true;
            LOG.info("Creating segment node store {}", (Object)this);
            return new SegmentNodeStore(this);
        }

        @Nonnull
        private static String getString(@CheckForNull BlobStore blobStore) {
            return "blobStore=" + (blobStore == null ? "inline" : blobStore);
        }

        public String toString() {
            return "SegmentNodeStoreBuilder{" + SegmentNodeStoreBuilder.getString(this.blobStore) + '}';
        }
    }
}

